;	DESC:	Writes character attributes to the screen            V1.00
;	IN:	*{PAGE} page number (0-3) 4 available pages in 80 column mode
;		*{ROWCOL} row(0-24),col(0-79) (ie 0345 indicating fourth row,
;		 46th column)
;		*{ATRB} attribute (see technical reference manual for
;		 information on color graphics adapter)
;		*{NUM_CHARS} # of chars to be affected
;	SAMPLE:	Callm	ATRB_WRT,<PAGE,ROWCOL,ATRB,NUM_CHARS>,
;	##################################################################

ATRB_WRD Segment Para Public 'DATA'
ATRIB		DB	7			;default color attribute.
PAGEL		DB	0			;page number (0-3).
LINE		DB	160			;lnumber of bytes in a
						;screen line.
ATRB_WRD Ends
 
	Extrn	PUSHALL:Near			;save and restore registers.
	Extrn	POPALL:Near
	Extrn	SCRN_TYP:Near			;determine video memory loc.

ATRB_WRC	Segment
	Assume	CS:ATRB_WRC,DS:ATRB_WRD
	Public	ATRB_WRT

	Include	CALLM.MAC

						;notice.
	DB	'ATRB_WRT - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

ATRB_WRT	Proc	Near
	Call	PUSHALL				;save registers.

	Mov	AX,ATRB_WRD			;setup workarea.
	Mov	DS,AX

	Callm	SCRN_TYP,,<BX>			;determine video memory loc.

COLOR:	Mov	AX,4096				;determine page offset.
	Pop	ES				;remove args. and replace.
	Pop	SI
	Pop	DI
	Pop	CX
	Push	ES
	Push	SI
	Push	DI

	Mov	PAGEL,CL			;determine offset in memory
	Mul	PAGEL				;as PAGEL pages of 4096 bytes.

	Mov	CL,4				;divide by 16 to get
	Shr	AX,CL				;segment value.

	Add	BX,AX				;add to total offset of video
	Mov	ES,BX				;memory and move to ES.
	
	Pop	AX				;determine offset of
	Mov	BX,AX				;row, col on screen.

	Xchg	AH,AL				;xchg row and column.
	Mov	AH,0				;clear top of AX.
	Mul	LINE				;compute total offset of rows.

	Mov	BH,0				;compute offset of columns.
	Shl	BX,1

	Add	AX,BX				;add for total offset and
	Mov	DI,AX				;place in DI.

	Pop	AX				;recover attribute.
	Pop	CX				;find number of characters
						;to apply attribute to.

	Mov	ATRIB,AL			;load attribute from register.

CONT:	Mov	SI,OFFSET ATRIB			;move attribute to affect
	Inc	DI				;screen string repeatedly
	Cld					;until CX is exhausted.
	Movs	ES:BYTE PTR[DI],DS:[SI]	
	Dec	CX
	Jcxz	READY
	Jmp	CONT
READY:	Call	POPALL
	Ret

ATRB_WRT	Endp
ATRB_WRC	Ends
	End
