;	DESC:	Gets Cursor Position                                 V1.00
;	IN:	*{PAGE_NUM} page number (0-7) in 40 character mode
;		 or (0-3) in 80 character mode (i.e. 0003) is page 4
;	OUT:	*{ROWCOL} row (0-24),col (0-79)  (i.e. 0104)
;		 1st row, 5th column
;		*{CURS_MODE} cursor mode (see manual for description)
;	SAMPLE:	Callm	CURS_GET,<PAGE_NUM>,<ROWCOL,CURS_MODE>
;	##################################################################

	Extrn	PUSHALL:Near
	Extrn	POPALL:Near

CURS_GEC	Segment
	Assume	CS:CURS_GEC
	Public	CURS_GET

						;notice.
	DB	'CURS_GET  - V1.00, Copyright 1987, CoreTechs  ',0DH,0AH

CURS_GET	Proc	Near
	Call	PUSHALL				;save registers.

	Pop	BX				;recover page nuumber.
	Xchg	BH,BL				;put page number in BH.

	Mov	AH,3				;determine cursor location.
	Int	10H

	Push	CX				;save report.
	Push	DX

	Call	POPALL				;recover registers.
	Ret

CURS_GET	Endp
CURS_GEC	Ends
	End
