;	DESC:	Gets the system date                                 V1.00
;	OUT:	*{SEG_VAL} segment and
;		*{OFFSET} offset of system date in format MM/DD/YY
;	SAMPLE:	Callm	DATE_GET,<SEG_VAL,OFFSET>,
;	##################################################################

DATE_GED	Segment Para Public 'DATA'
MONTH		DW	0
		DB	'/'
DAY		DW	0
		DB	'/'
YEAR		DW	0
		DB	0
DATE_GED	Ends

	Extrn	HEX_ASC:Near
	Extrn	PUSHALL:Near
	Extrn	POPALL:Near

DATE_GEC	Segment
	Assume	CS:DATE_GEC,DS:DATE_GED
	Public	DATE_GET

	Include	CALLM.MAC

						;notice.
	DB	'DATE_GET - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

DATE_GET	Proc	Near

	Call	PUSHALL				;save registers.

	Mov	AX,DATE_GED			;setup workarea.
	Mov	DS,AX

	Mov	AH,2AH				;get system date.
	Int	21H

	Xor	AX,AX				;isolate month.
	Mov	AL,DH
	Callm	HEX_ASC,<0,AX>,<AX,AX,AX,AX,AX>	;convert month to ASCII.
	Xchg	AH,AL				;flip bytes for storage.
	Mov	MONTH,AX

	Xor	AX,AX				;isolate day.
	Mov	AL,DL
	Callm	HEX_ASC,<0,AX>,<AX,AX,AX,AX,AX>	;convert day to ASCII.
	Xchg	AH,AL				;flip bytes for storage.
	Or	AX,3030H			;change blanks to 0's.
	Mov	DAY,AX

	Sub	CX,1900
	Callm	HEX_ASC,<0,CX>,<AX,AX,AX,AX,AX>	;convert year to ASCII.
	Xchg	AH,AL				;flip bytes for storage.
	Or	AX,3030H			;change blanks to 0's.
	Mov	YEAR,AX

	Mov	DX,OFFSET MONTH			;return location of ASCII
	Push	DX				;date.
	Push	DS

	Call	POPALL				;recover registers.
	Ret
DATE_GET	Endp
DATE_GEC	Ends
	End
