;	DESC:	Performs repeated executions of a program on a       V1.00
;		set of files
;	IN:	*d:\path1\path2\...filename.ext is the name of the program
;		 to be executed
;		*d:\path1\path2\...filename.ext with wildcards allowed
;		 and is the set of files on which to operate the program
;	OUT:	*repeated executions of the programs.
;	SAMPLE:	MULT_EXE program *.ASM {run the program on all files
;		with a .ASM extension}
;	####################################################################

MULT_EXD Segment Para Public 'DATA'
		DW	0			;help message.
		DW	0
		DD	MHELP
		DW	EHELP
MHELP		DB	0DH,0AH,'               '
		DB	'DESC:   Performs repeated executions of a program'
		DB	0DH,0AH,'               '
		DB	'on a set of files'
		DB	0DH,0AH,'               '
		DB	'IN:     *d:\path1\path2\...filename.ext is the name'
		DB	0DH,0AH,'               '
		DB	'of the program to be executed'
		DB	0DH,0AH,'               '
		DB	'*d:\path1\path2\...filename.ext with wildcards'
		DB	0DH,0AH,'               '
		DB	'allowed and is the set of files on which to operate'
		DB	0DH,0AH,'               '
		DB	'the program'
		DB	0DH,0AH,'               '
		DB	'OUT:    *repeated executions of the programs.'
		DB	0DH,0AH,'               '
		DB	'SAMPLE: MULT_EXE program *.ASM {run the program on'
		DB	0DH,0AH,'               '
		DB	'all files with a .ASM extension}'
		DB	0DH,0AH,'               '
EHELP		DB	0

PAR		DB	0			;parameter block.
		DB	20H
PAR2		DB	50 Dup(0DH)		;filename.

TOP		DW	0

MULT_EXD Ends

	Extrn	SRCH_FIL:Near			;locate files matching the
						;search string.
	Extrn	SRCH_NXT:Near			;searches for next match.
	Extrn	ERRORMSG:Near			;prints error exit messages.
	Extrn	EXECUTE:Near			;executes other program.
	Extrn	MOVE_BYT:Near			;moves data place to place.
	Extrn	PARM_BRK:Near			;separates parameters.
	Extrn	HELP:Near			;provides help information.

MULT_EXC	Segment Para Public 'CODE'
	Assume CS:MULT_EXC,DS:MULT_EXD

	Include	CALLM.MAC			;macro file which allows
						;input and output of
						;parameters to subroutines.
	DW	0,0,0,180,0,0,0

						;notice.
	DB	'MULT_EXE - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

MULT_EXE	Proc	Far			;main procedure.

	Push	DS				;store return address.
	Xor	AX,AX
	Push	AX

	Mov	BX,DS				;save initial data segment.

	Mov	AX,MULT_EXD			;assign data segment location.
	Mov	DS,AX

	Mov	TOP,BX

	Callm	HELP,<BX,AX>,<ES,BX,CX>		;get DOS data line
						;specifying program to
						;execute repeatedly.

	Callm	PARM_BRK,<ES,BX,CX>,<CX>	;break up multiple params.

	Cmp	CX,2				;if two params., OK.
	Jz	CONT0

	Callm	ERRORMSG,<22>,			;wrong number of params.

CONT0:	Pop	ES				;recover second param.
	Pop	BX
	Pop	CX

	Mov	CX,20H				;locate first filename.
	Callm	SRCH_FIL,<ES,BX>,<AX,AX,AX,AX,ES,BX,CX>
	Jcxz	ERROR1				;exit if no matching files.
	Jmp	CONT1

ERROR1:	Callm	ERRORMSG,<2>,			;display no File(s) found.

CONT1:	Pop	SI				;recover name of program
	Pop	DI				;to run on file in first
	Pop	AX				;parameter.

CONT2:						;move filename to internal
						;buffer.
	Callm	MOVE_BYT,<ES,BX,DS,<OFFSET PAR2>,CX>,

	Inc	CL				;move parameter length
	Mov	PAR,CL				;to start of block.
	Dec	CL

	Add	CX,OFFSET PAR2			;setup end of param. block.
	Mov	BP,CX
	Mov	DS:BYTE PTR[BP],0DH

						;execute program.
	Callm	EXECUTE,<SI,DI,DS,<OFFSET PAR>,TOP,500>,

	Mov	CX,20H				;locate first filename.
	Callm	SRCH_NXT,<ES,BX>,<AX,AX,AX,AX,ES,BX,CX>
	Jcxz	ERROR2				;exit if no more files.
	Jmp	CONT2				;return to start of loop.

ERROR2:	Callm	ERRORMSG,<18>,			;display no More Files(s).

MULT_EXE	Endp
MULT_EXC	Ends
	End	MULT_EXE
