;	DESC:	Searches for a string in the indicated buffer        V1.02
;	IN:	*{DIR} direction of search (0:forward,1-FFFF:reverse)
;		*{SEG_VAL} segment and
;		*{OFFSET} offset of buffer to search
;		*{LENGTH} length of search string
;		*{SSTRNG} segment and
;		*{OSTRNG} offset of search string
;	OUT:	*{OSEG} segment and
;		*{OOFF} of search string (both zero if not found)
;	SAMPLE:	Callm	SEARCH,<DIR,SEG_VAL,OFFSET,LENGTH,SSTRNG,OSTRNG>,
;		               <OSEG,OOFF>
;	####################################################################

	Extrn	PUSHALL:Near
	Extrn	POPALL:Near
	Extrn	SCAN_BYT:Near


SEARCHC	Segment
	Assume	CS:SEARCHC
	Public	SEARCH

	Include	CALLM.MAC
						;notice.
	DB	'SEARCH   - V1.02, Copyright 1987, CoreTechs   ',0DH,0AH

SEARCH	Proc	Near
	Call	PUSHALL				;save registers.

	Pop	SI				;recover offset and
	Pop	DS				;segment of search string.

	Mov	BP,SI
	Mov	AH,0
	Mov	AL,DS:BYTE PTR[BP]		;get first char. of string.

	Pop	BP				;recover length of string.

	Pop	BX				;recover offset and
	Pop	DX				;segment of search buffer.

T1:	Pop	CX				;recover search direction.
	Jcxz	FORWRD				;if 0, then search forward.

	Std					;other then 0, reverse search.
	Jmp	S1				;start search

FORWRD:	Cld

S1:	Callm	SCAN_BYT,<DX,BX,AX,1>,<BX,BX>	;locate start of string.

	Cmp	BX,0				;exit if no match
	JZ	DONE2
	Cmp	BX,0FFFFH
	JZ	DONE2

	Mov	DI,BX				;setup for compare and
	Jcxz	FOR1				;possible additional searches.
	Dec	BX
	Jmp	CON1

FOR1:	Inc	BX

CON1:	Push	CX				;store direction.
	Cld					;and clear for compare.

	Mov	CX,BP				;length of string.
	Mov	ES,DX				;segment of buffer.
	Push	SI
	Repz	CMPSB				;see if this is the string.
	Pop	SI

	Jcxz	DONEP				;search is possibly complete.
	Jmp	T1

DONEP:	Jz	DONE				;search is done.
	Jmp	T1
	
DONE:	Pop	CX
	Jcxz	FOR2
	Inc	BX
	Jmp	CON2

DONE2:	Mov	BX,0
	Mov	DX,0
	Jmp	CON2

FOR2:	Dec	BX
CON2:	Push	BX				;return search results.
	Push	DX

	Call	POPALL				;recover registers.
	Ret

SEARCH	Endp
SEARCHC	Ends
	End
