;Ŀ
;             CUBESRCH.INC - Include file for the Cube Solver		    
;
;Ŀ
;    CurrentTreePosition is a word-size table, indexed by piece number	    
;    that contains the branch number we're currently exploring. It's	    
;    initialized to 0's and each branch is explored from there...	    
;
CurrentTreePosition	dw	NUMBER_OF_PIECES dup (0)

;Ŀ
;    CurrentMasterCube is the master puzzle cube as it stands at each	    
;    level of the tree.						    
;
MasterCubeLevel		db   ((SUB_CUBE_COUNT+1) * NUMBER_OF_PIECES) dup(0)

MergedPieceOffset	dw	?	; offset of the piece to be merged

;Ŀ
;  This table of SUB_CUBE_COUNT displacements is used to avoid multiplies  
;
PDT		LABEL	WORD	; PDT = Piece Displacement Table
Displacement	=	0
		REPT	128
		dw	Displacement
Displacement	=	Displacement + (SUB_CUBE_COUNT+1)
		ENDM

;****************************************************************************
;****************************************************************************
;Ŀ
;                       The tree searching code ...			    
;

;
;  We come here with CurrentPiece = 0-8 indicating the piece we're trying
;  to find a place to fit into the cube ...
;
;  Register Usage:
;       ax - general
;	bx - CurrentPiece * 2
;	cx - counter
;	dx - count of cubes/2 (reloads cx)
;	si - compare pointer #1
;	di - compare pointer #2
;	bp - working table offset in DS
;
;
SearchTheTree:	zero	bx				; initial piece #
		mov	dx, (SUB_CUBE_COUNT+1)/2	; get byte count
		mov	bp, OFFSET WorkingPieceTable	; and destination
;
PlaceTheFirst:	zero	ax			; clear out the working cube
		mov	cx, dx
		mov	di, bp			; working piece table

		rep stosw
;
TestThePiece:	mov	cx, dx			; get the count
		mov	si, bp			; and the Working Table
		call	GetPieceOffset		; di gets piece's image
		push	di

;
CheckCollision:	lodsw			; get piece image, inc si
		test	ax, [di]	; does it intersect the working?
		jnz	Collision	; yes, so terminate it
		add	di, 2		; point to next working
		loop	CheckCollision

;
		mov	cx, dx
		pop	si		; recover the piece's image
		mov	di, bp		; and the current working table
MergePieceIn:	lodsw			; get piece image and point to next
		or	[di], ax	; merge the image's bits
		add	di, 2		; point to next working
		loop	MergePieceIn

;
ShowThePiece:	call	ShowCurrentPiece 	; preserves bx, dx, bp
		call	OperatorCheck
;
		mov	cx, dx
		mov	si, bp			; working piece table
		mov	di, PDT[bx]		; get the level to reload
		add	di, OFFSET MasterCubeLevel ; reset to level's master
		rep movsw		

		cmp	bx, 8*2		; are we already at the top?
		je	Collision2	; yep, so look for another match!
		add	bx, 2		; advance to next level
		jmp	TestThePiece

;
Collision:	add	sp, 2		; discard the saved di
Collision2:	call	NextBranch	; advance this level's branch
		jb	TestThePiece	; got another branch to try
					; no more branches, so back up!
;
BackUpTheTree:	call	BlankCurrentPiece
		sub	bx, 2		; point to prior piece (level*2)
		jnz	GetNextBranch
		cmp	CurrentTreePosition[bx], 2
		jae	Pause

;
GetNextBranch:	call	NextBranch
		jae	BackUpTheTree

;
SetPriorLevel:	mov	cx, dx
		check	bx			; are we back to level 0 ?
		jz	PlaceTheFirst		; yep ... so clear us out


;
CopyPriorImage:	mov	si, PDT[bx-2]		; get the level to reload
		add	si, OFFSET MasterCubeLevel ; reset to level's master
		mov	di, bp			; working piece table
		rep movsw		
		jmp	TestThePiece


;͸
;       Advances the branch at position BX, or zeros it if no more	    
;
NextBranch:	mov	ax, CurrentTreePosition[bx]	; setup for next pos
		inc	ax
		cmp	ax, PieceImageCounts[bx]	; are we exhausted?
		jb	SaveNewBranch
		zero	ax
SaveNewBranch:	mov	CurrentTreePosition[bx], ax
		ret


;͸
;       Sets DI to the offset of the piece just merged ...		    
;
GetPieceOffset:	mov	di, CurrentTreePosition[bx]	; get current pos
		double	di				; PDT is word indexed
		mov	di, PDT[di]			; get offset
		add	di, PieceTableOffsets[bx]	; and start of table
		mov	MergedPieceOffset, di
		ret

