;Ŀ
;             CUBESYS.INC - Include file for the Cube Solver		    
;
BRIGHT_ON_BLACK		equ	0Fh
CYAN_ON_BLUE		equ	13h
MAGENTA_ON_BLUE		equ	15h
BRIGHT_ON_BLUE		equ	1Fh
BRIGHT_ON_MAGENTA	equ	5Fh
DIM_ON_MAGENTA		equ	57h

;
LINE_LENGTH		equ	80	; chars
LINE_COUNT		equ	25	; lines

;
STACK_DEPTH		equ	512

;
InvocationCursor	dw	?	; the caller's initial cursor loc.
ScreenSegment		dw	0B800h	; our default display seg
ExitingMessage		dw	OFFSET NormalTermination
OldTimerVector		dd	?
Count1			dw	0
Count2			dw	0
TickCount1		dw	0
TickCount2		dw	0
SingleStepping		db	TRUE
Animation		db	TRUE
Sound			db	FALSE
PausePoint		dw	00FEh		; no pause code

;
Period			dw	0	; Sound system symbols
DeltaFreq		dw	0
Duration		dw	0
PhasorPosition		dw	0

;
ColorChart	db	 3 dup (MAGENTA_ON_BLUE)
		db	 2 dup (BRIGHT_ON_BLUE)
		db	13 dup (CYAN_ON_BLUE)
		db	 2 dup (BRIGHT_ON_BLUE)
		db	 5 dup (MAGENTA_ON_BLUE)

;
ScreenOffset	dw	(6*80+ 3)*2, (6*80+10)*2, (6*80+17)*2, (6*80+24)*2
		dw	(6*80+31)*2, (6*80+38)*2, (6*80+45)*2, (6*80+52)*2
		dw	(6*80+59)*2

;
NumericsPosition   dw	(18*80+ 6)*2,(18*80+13)*2,(18*80+20)*2,(18*80+27)*2
		   dw	(18*80+34)*2,(18*80+41)*2,(18*80+48)*2,(18*80+55)*2
		   dw	(18*80+62)*2

;
CharacterTable	dw	0B2B2h, 0, 020DBh, 0DCDCh, 0DFDFh, 0DB20h, 0, 0B0B0h



;
SetupTheSystem:
;Ŀ
;       Get everything up and running ...				    
;
		call	SaveScreenAndCursor
		Hook	TIMER_INT, OldTimerVector, CountTicks
		call	AllocateMemoryRegions
		jmp	DisplayTheScreen	; EXIT THROUGH ...

Exit:
;Ŀ
;       Restore Timer vector, user's screen, and exit to DOS ...	    
;
		mov	dx, WORD PTR OldTimerVector
		mov	ds, WORD PTR OldTimerVector+2
		mov	ax, DOS_SET_VECTOR*256 + TIMER_INT
		int	DOS_FUNC
		pupop	ds, cs		
;
		mov	cx, SCREEN_LENGTH / 2
		mov	si, OFFSET InitScreenBuffer
		zero	di
		mov	es, ScreenSegment
		rep movsw
;
		mov	ax, SET_CURSOR_POS*256
		zero	bh			; (screen page 0)
		mov	dx, InvocationCursor
		int	VIDEO_IO
;
		mov	dx, ExitingMessage	; print the standard message
		mov	ah, DOS_PRINTSTRING
		int	DOS_FUNC
		int	COM_TERMINATE
;****************************************************************************


DisplayTheScreen:
;Ŀ
;		 Blast the thrasher's data screen into screen               
;		 memory then fixup the colorizing attributes.		    
;
		zero	bx			; init the line counter
		mov	si, OFFSET ScreenDisplay
		zero	di
		mov	es, ScreenSegment
;
MoveALine:	mov	ah, ColorChart[bx]
		mov	cx, LINE_LENGTH
MoveIt:		lodsb
		stosw
		loop	MoveIt
		inc	bx
		cmp	bx, LINE_COUNT
		jb	MoveALine


;Ŀ
;                   Color the top and bottom text lines		    
;
		mov	al, BRIGHT_ON_MAGENTA
		mov	cx, 80-2
		zero	di
;
WhiteWash:	mov	es:[di+( 1*80+1)*2+1], al
		mov	es:[di+(21*80+1)*2+1], al
		mov	es:[di+(22*80+1)*2+1], al
		mov	es:[di+(23*80+1)*2+1], al
		add	di, 2
		loop	WhiteWash
;
		mov	di, (21*80+30)*2
		call	ColorSix
		mov	di, (21*80+60)*2
		call	ColorSix
;
		call	PaintLowerRight

;
		call	BlankEmAll
		mov	di, (6*80+71)*2
		call	BlankAtDI
;
		pupop	es, cs
		jmp	RefreshScreen		; return through ...


BlankEmAll:
;͸
;              Blanks all of the piece regions			            
;
		push	bx
		zero	bx
BlankOne:	call	BlankCurrentPiece
		add	bx, 2
		cmp	bx, 9*2
		jb	BlankOne
		pop	bx
		ret


ColorSix:
;͸
;       Finishes coloring the display screen by dropping four colors	    
;
		mov	ax, MAGENTA_ON_BLUE * 256 + " "
		mov	cx, 3
ColorTwo:	stosw
		stosw
		add	di, (80-2)*2
		loop	ColorTwo
		ret


PaintLowerRight:
;͸
;    Re-Paints the lower right of the screen which was overcolored ...	    
;
		mov	al, BRIGHT_ON_BLUE
		mov	di, (20*80+62)*2+1
		call	Paintshort
		mov	al, MAGENTA_ON_BLUE
		mov	di, (21*80+62)*2+1
PaintShort:	mov	cx, 17
PaintAttrib:	stosb
		inc	di
		loop	PaintAttrib
		ret


BlankCurrentPiece:
;͸
;               This routine blanks the current branch number		    
;
		mov	di, ScreenOffset[bx]	; get the upper left corner
;
BlankAtDI:	push	es
		mov	es, ScreenSegment
		bool	Animation
		iffalse	BlankNumbers
;
		mov	cx, 3		; we have three levels
BlankOneLevel:	push	cx
		mov	cx, 3		; each level has three lines
BlankOneLine:	push	cx
		mov	ax, BRIGHT_ON_BLACK + " "
		mov	cx, 6		; each line has three blocks
		rep stosw
;
		add	di, (80-6)*2		; drop to next line
		pop	cx
		loop	BlankOneLine
;
		add	di, 160			; skip one line
		pop	cx
		loop	BlankOneLevel
;
BlankNumbers:	mov	di, NumericsPosition[bx]
		mov	BYTE PTR es:[di], " "
		mov	BYTE PTR es:[di-2], " "
;
		pop	es
		ret



ShowAllPieces:
;͸
;     This routine updates all the pieces.  It's called when the puzzle    
;     has been solved. most recently succesfully ...			    
;
		call	BlankEmAll
		push	bx
		push	dx
		mov	dx, bx
		zero	bx
ShowNextPiece:	call	GetPieceOffset
		call	ShowItNow
		add	bx, 2
		cmp	bx, dx
		jbe	ShowNextPiece
		pop	dx
		pop	bx
		ret


ShowCurrentPiece:
;͸
;     This routine shows the piece most recently succesfully ...	    
;     Called with BX = CurrentPiece*2               (bx, dx, bp preserved) 
;
		bool	Animation
		iffalse	ShowNumbers
;
ShowItNow:	mov	di, ScreenOffset[bx]	; get the upper left corner
		mov	si, MergedPieceOffset
		call	DisplayPiece
		call	ShowCurrentPuzzle
ShowNumbers:	jmp	ShowNumerics


ShowCurrentPuzzle:
;͸
;     This routine shows the current pieces placed ino the puzzle ...	    
;                                                   (bx, dx, bp preserved) 
;
		mov	di, (6*80+71)*2
		mov	si, bp

DisplayPiece:
;Ŀ
;  This routine displays a 27-byte piece data-structure at screen loc DI.  
;
		push	bx
		push	es
		mov	es, ScreenSegment

;
		mov	cx, 3		; we have three levels
CvrtOneLevel:	push	cx
		mov	cx, 3		; each level has three lines
CvrtOneLine:	push	cx
		mov	cx, 3		; each line has three blocks
CvrtOneBlock:	lodsb			; get the next byte
		cmp	al, 0
		jne	NotEmpty
		mov	bx, 02020h
		jmp	Stuffit
;
NotEmpty:	cmp	al, 0FFh
		jne	NotFull
		mov	bx, 0DBDBh
		jmp	Stuffit
;
NotFull:	and	ax, 0007h	; get just the bottom 3 bits
		mov	bx, ax
		double	bx
		mov	bx, CharacterTable[bx]
;
Stuffit:	mov	ah, BRIGHT_ON_BLACK
		mov	al, bl
		stosw
		mov	al, bh
		stosw
		loop	CvrtOneBlock
;
		add	di, (80-6)*2		; drop to next line
		pop	cx
		loop	CvrtOneLine
;
		add	di, 160			; skip one line
		pop	cx
		loop	CvrtOneLevel
;
		pop	es
		pop	bx
		ret


ShowNumerics:
;͸
;            Show the current piece and the total number of moves	    
;
		push	bx
		push	dx
		push	bp
		push	es
		mov	es, ScreenSegment
		mov	ax, CurrentTreePosition[bx]	; get current pos
		inc	ax
		mov	di, NumericsPosition[bx]
		cmp	ax, 10
		jae	DoTheNumber
		mov	BYTE PTR es:[di-2], " "	; less than 10, so blank 10's place
DoTheNumber:	call	DoNumeric


;
;		     Now update the total move display
;
		mov	ax, Count2
		mov	bx, Count1
		mov	di, (19*80+78)*2
		call	PlaceLargeNumb
;
		mov	ax, TickCount2
		mov	bx, TickCount1
		mov	di, (20*80+78)*2
		call	PlaceLargeNumb
;
		pop	es
		pop	bp
		pop	dx
		pop	bx
JustReturn:	ret


PlaceLargeNumb:	
;͸
;                          At [di] place ax,bx				    
;
		mov	cx, 10		; divisor
		mov	bp, 1
;
DoAnotherDig:	zero	dx		; clear the high side
		div	cx		; divide high half by ten
		xchg	ax, bx
		div	cx
		xchg	ax, bx
		add	dl, "0"		; turn it into ASCII
PlaceChar:	mov	es:[di], dl	; stuff an ascii digit
		sub	di, 2		; back up 1 byte to the left
		mov	dx, ax		; are we all done ?
		or	dx, bx
		jz	JustReturn
;
CheckComma:	inc	bp
		cmp	bp, 4
		jb	DoAnotherDig
		mov	dl, ","
		zero	bp
		jmp	PlaceChar



ShowImageCount:
;͸
;       Show the number of images for the current piece ...		    
;
		mov	ax, PieceImageCounts[bx]	; get the count
		mov	di, NumericsPosition[bx]
		mov	es, ScreenSegment
		call	DoNumeric
		pupop	es, cs
		ret

DoNumeric:	
;͸
;       Convert the value of AX into on On-Screen number ...		    
;
		mov	cx, 10		; divisor
DoADigit:	zero	dx		; clear the high side
		div	cx
		add	dl, "0"		; turn it into ASCII
		mov	es:[di], dl	; stuff an ascii digit
		sub	di, 2		; back up 1 byte to the left
		check	ax
		jnz	DoADigit
		ret

SaveScreenAndCursor:
;Ŀ
;           Tuck the caller's screen and cursor away for safety	    
;
		mov	cx, SCREEN_LENGTH / 2		; save initial screen
		zero	si
		mov	di, OFFSET InitScreenBuffer
		mov	ds, ScreenSegment
		rep movsw
		pupop	ds, cs
;
		mov	ax, GET_CURSOR_POS*256	; save prior cursor pos
		zero	bh
		int	VIDEO_IO
		mov	InvocationCursor, dx
;
		mov	ax, SET_CURSOR_POS*256	; and remove the cursor
		zero	bh			; (screen page 0)
		mov	dx, 25*256+0		; line 26, column 0
		int	VIDEO_IO
		ret

AllocateMemoryRegions:
;Ŀ
;       Free up the system's RAM, then make the following regions:	    
;       64K - for the piece positions.					    
;
		mov	ah, DOS_SETBLOCK
		mov	bx, (TopOfStack-StartOfProg+15)/16
		pupop	es, cs
		int	DOS_FUNC		; reduce our allocation
		ret

CountTicks:
;Ŀ
;             Accumulate the total number of ticks accumulated		    
;
		pushf
		bool	cs:SingleStepping
		iftrue	TickCounted
		inc	cs:TickCount1
		jnz	TickCounted
		inc	cs:TickCount2
TickCounted:	popf
		jmp	cs:[OldTimerVector]  ; and proceed to Original Int8


OperatorCheck:
;Ŀ
;           Accumulate the total number of tests performed ...		    
;
		bool	Sound
		iffalse	IncCount
		call	ToggleSpeaker
IncCount:	inc	Count1
		jnz	Accumed
		inc	Count2
;
Accumed:	cmp	bx, 8*2
		jne	NotDone
		call	AttentionSound
		call	AttentionSound
		jmp	SetPause

;
NotDone:	cmp	bx, PausePoint
		je	SetPause

;
CheckStep:	bool	SingleStepping
		iftrue	Pause
		mov	ah, GETKEY_NOWAIT
		int	KEYBOARD_IO
		jnz	Pause
		ret

;
SetPause:	set	SingleStepping
		call	AttentionSound
Pause:		call	ShowAllPieces
		call	WaitForKeyPress
		call	KeystrokeSound
;
CheckPress:	cmp	al, ESC_
		je	Exit
		cmp	al, " "
		jne	NotSpace
		set	SingleStepping
		ret

;
NotSpace:	cmp	al, CR
		jne	NotCR
		xor	SingleStepping, 0FFh
		jnz	CheckStep
		call	WaitForClockTick
		jmp	CheckStep


;
NotCR:		cmp	al, "9"
		ja	NotNumeric
		cmp	al, "0"
		jb	NotNumeric
		sub	al, "1"		; al = 0 to 8
		double	al
		mov	BYTE PTR PausePoint, al
		jmp	RefreshUs

;
NotNumeric:	cmp	al, "a"
		jae	CheckAscii
		add	al, "a"-"A"
;
CheckAscii:	cmp	al, "a"
		jne	SoundOnOff
		xor	Animation, 0FFh
RefreshUs:	call	RefreshScreen
		jmp	CheckStep
;
SoundOnOff:	cmp	al, "s"
		jne	Update
		xor	Sound, 0FFh
		jmp	RefreshUs
;
Update:		cmp	al, "u"
		jne	CheckStep
		Call	ShowAllPieces
		jmp	RefreshUs


RefreshScreen:
;Ŀ
;  Shows the current state of the Animation, Sound, and Partial booleans   
;
		mov	es, ScreenSegment
		bool	Animation
		mov	di, (23*80+3)*2+1
		call	RefreshOne
;
		bool	Sound
		mov	di, (21*80+34)*2+1
		call	RefreshOne
;
		mov	al, BYTE PTR PausePoint
		halve	al			; 0-9
		add	al, "1"			; "0" - "9"
		cmp	al, 0B0h
		jne	ShowPause
		mov	al, "-"
ShowPause:	mov	di, (23*80+57)*2
		mov	es, ScreenSegment
		stosb
		pupop	es, cs
		ret


;
RefreshOne:	mov	cx, 25
		mov	al, BRIGHT_ON_MAGENTA
		mov	si, OFFSET ONStatus
		iftrue	RefreshIt
		mov	al, DIM_ON_MAGENTA
		mov	si, OFFSET OFFStatus
RefreshIt:	stosb
		inc	di
		loop	RefreshIt
		sub	di, 7
		mov	cx, 3
RefreshWord:	movsb
		inc	di
		loop	RefreshWord
		ret	

;͸
;                         Sound Generation Sub-System			    
;;
KeystrokeSound:	mov	Period, 500		; typing thunk sound
		mov	Duration, 18
		jmp	ToneBurst

;
AttentionSound:	mov	Period, 1500		; first period
		mov	DeltaFreq, 35		; period change each half-cyc
		mov	Duration,  40		; half-cycle count
		jmp	ToneSlide

;͸
;    Enter with "Period", "Duration" and "DeltaFreq" all set as needed...  
;
ToneBurst:	mov	DeltaFreq, 0
ToneSlide:  	pushf
		push	ax
		cli
		Call	GetPhasorPos	; set initial angle
		mov	PhasorPosition, ax

NextCycle:	mov	ax, Period	; update the phasor angle
		sub	PhasorPosition, ax

GetCycleEnd:	Call	GetPhasorPos
		sub	ax, PhasorPosition
		abs_	ax
		cmp	ax, 100
		jae	GetCycleEnd

		Call	ToggleSpeaker
		mov	ax, DeltaFreq
		sub	Period, ax
		dec	Duration
		jnz	NextCycle
		sti
		pop	ax
ToneMade:	popf
		ret


;
GetPhasorPos:	mov	al, 00000100B	; latch timer_0
		outt	TIMER_MODE, al
		inn	al, TIMER_0	; LSB
		xchg	ah, al
		inn	al, TIMER_0	; MSB
		xchg	ah, al		; finally form the count
		ret
		
;
ToggleSpeaker:	inn	al, SPEAKER_GATE
		and	al, NOT OSCILLATOR_GATE_BIT	; kill OSC Input
		xor	al, SPEAKER_DATA_BIT		; invert Spkr Data
		outt	SPEAKER_GATE, al
		ret


WaitForClockTick:
;͸
;                     Wait for a Timer Tick to occur			    
;
		sti
		mov	ax, TickCount1
KeepWaiting:	cmp	ax, TickCount1
		je	KeepWaiting
		ret










ScreenDisplay:
;
db "  "
db "   Heuristic Combinatorial Cube Solver  (c) 1990, Gibson Research Corporation   "
db "  "
db "       Pieces Ŀ        Result   "
db "      1      2      3      4      5      6      7      8      9         Cube    "
db "    "
db "                                                                            "
db "                                                                            "
db "                                                                            "
db "                                                                            "
db "                                                                            "
db "                                                                            "
db "                                                                            "
db "                                                                            "
db "                                                                            "
db "                                                                            "
db "                                                                            "
db "    "
db "                                                                                "
db "       Position   Moves:         "
db "         Time:         "
db "   [ENTER] to Start / Stop        [S] Sound Monitor            "
db "   [SPACEBAR] to Stop / Step      [U] Update Positions          Press the ESC   "
db "   [A] Animate Screen             [0-9] Pause at piece  - -      key to Exit.   "
db "      "

NormalTermination:
;
db CR,LF
db "                       ",CR,LF
db "                          Cubit terminated normally.  ",CR,LF
db "                       ",CR,LF,"$"
;
ONStatus:	db	"ON "
OFFStatus:	db	"OFF"

;Ŀ
;                   End of the CUBESYS.INC include file		    
;

