.XLIST		; suspend all listing during this header processing
;͸
; macros.h                                                 created: 5/12/85
;									    
;       This is a subset of my more than 100K MONSTER standard.h	    
;       assembly languange header file.  Only those items required	    
;       for the assembly of CUBE.ASM are included here.		    
;									    
;;

;
FALSE			equ	0
TRUE			equ	-1
SCREEN_LENGTH	equ	25*80*2		; length of the text buffer ....

;
KEYBOARD_IO	equ	16H			; BIOS INT
;
GETKEY_WAIT	equ	0
GETKEY_NOWAIT	equ	1
GET_STATUS	equ	2

;
VIDEO_IO	equ	10H			; bios Call
;
SET_CURSOR_POS	equ	2
GET_CURSOR_POS	equ	3

;
COM_TERMINATE		equ	20H		; .COM program termination
DOS_FUNC		equ	21H		; dos Call
;
DOS_PRINTSTRING		equ	09H
DOS_SET_VECTOR		equ	25h
DOS_GET_VECTOR		equ	35h
DOS_SETBLOCK		equ	4AH

;
TIMER_INT		equ	08h		; bios interrupt
;
TIMER_0			equ	40h		; hardware ports and data
TIMER_MODE		equ	43h
SPEAKER_GATE		equ	61h
 OSCILLATOR_GATE_BIT	equ	01h
 SPEAKER_DATA_BIT	equ	02h

;
CR		equ	00Dh		; CARRIAGE RETURN
LF		equ	00Ah		; LINE FEED
ESC_		equ	01BH		; Escape Code

;
zero	MACRO p1			; fast zero of a register
		xor	p1,p1
	ENDM

;
halve	MACRO p1			; halve the size of the argument
		shr	p1,1
	ENDM

;
double	MACRO p1			; double the size of the argument
		shl	p1,1
	ENDM

;
check	MACRO p1			; set flags based upon the arg
		or	p1,p1
	ENDM

;
pupop	MACRO p1, p2			; move values between seg registers
		push	p2
		pop	p1
	ENDM

;
bool	MACRO p1			; this preceeds the iffalse macro
		test	p1, -1
	ENDM

;
iftrue	MACRO p1			; another meaning for jnz
		jnz	p1
	ENDM

;
iffalse	MACRO p1			; another meaning for jz
		jz	p1
	ENDM

;
set	MACRO p1			; a boolean equivalence
		mov	p1, -1
	ENDM

;
abs_	MACRO p1			; invert the polarity if negative
	LOCAL L1
		or	p1, p1		; < not generally needed!
		jns	L1
		neg	p1
	L1:
	ENDM

;
inn	MACRO p1,p2			; get data from a slow NMOS device
	LOCAL L1
		jmp	short L1	; this flushes the pre-fetch queue
	L1:	in	p1,p2
	ENDM

;
outt	MACRO p1,p2			; place data into a slow NMOS device
	LOCAL L1
		jmp	short L1	; this flushes the pre-fetch queue
	L1:	out	p1,p2
	ENDM

;
Hook	MACRO p1,p2,p3			; hook an interrupt vector (see usage)
	mov	ax, DOS_GET_VECTOR*256 + p1
	int	DOS_FUNC
	mov	WORD PTR p2  , bx
	mov	WORD PTR p2+2, es
	mov	dx, OFFSET p3
	mov	ax, DOS_SET_VECTOR*256 + p1
	int	DOS_FUNC
	ENDM

;Ŀ
;  End of HEADER.ASM file  
;
.LIST		; resume listing here ...

