10 '--------------------------------------------------------------------------
11 '|	UASM-JMP  1.05		12 Sept, 1983		White Crane Systems  |
12 '|	copyright 1983		Guy C. Gordon		3194 Friar Tuck Way  |
13 '|							Doraville, GA 30340  |
14 '|									     |
16 '|	This program takes the Unassemble output from DEBUG and changes	     |
18 '|	all Jump, Call and Loop addresses into labels of the form Lhhhh	     |
20 '|	where hhhh is the hex address.  All addresses are stripped from	     |
22 '|	the lines except those referenced in this block of code, which	     |
24 '|	are made into labels.   Your unassembled input file should con-	     |
26 '|	sist of all of the code and none of the data areas.		     |
28 '|									     |
30 '|	In addition, blank lines are inserted after all unconditional 	     |
32 '|	program transfers (JMP, JMPS, RET, IRET) to make the division of     |
34 '|	the program into subroutines more visible.  Such lines are forced    |
35 '|	to have labels, even if not referenced anywhere in the code.         |
36 '|	A warning comment is appended in this case.			     |
40 '|									     |
42 '|	UASM-JMP replaces COM2ASM by Richard Winkel on which it is based.    |
44 '|	It gives about a 2X advantage in speed,  depending on file size.     |
46 '|	For best speed, and to save wear on your drives, specify the in-     |
48 '|	put and output files on separate drives.  			     |
50 '********************************* NOTICE *********************************
51 '*          USER SUPPORTED SOFTWARE (With thanks to Andrew Flugelman)     *
52 '*                                                                        *
53 '*   A limited license is granted to all users of this program, to make   *
54 '*   copies of this program and distribute them to other users subject    *
55 '*   to the following conditions:                                         *
56 '*           1.  None of the notices or credits are to be bypassed,       *
57 '*               altered, or removed.                                     *
58 '*           2.  The program is not to be distributed in modified form.   *
59 '*               (Users are encouraged to distribute MERGE files.)        *
60 '*           3.  No fee is to be charged (or any other consideration      *
61 '*               received) for copying or distributing the program        *
62 '*               without an express written agreement with                *
63 '*               White Crane Systems.                                     *
64 '**************************************************************************
70 CLS 'PRINT CHR$(27)+"E";   'CLS
71 PRINT "                                UASM-JMP
72 PRINT "              White Crane Systems Unassembler - Jump module
73 PRINT "
74 PRINT "           If you are using this program and finding it of value
75 PRINT "      please send  a cash contribution to support its upkeep and
76 PRINT "      distribution.   Use the UASM system  of programs to  unas-
77 PRINT "      semble one average length .COM file, look over the results
78 PRINT "      and calculate how many hours this would have taken you  to
79 PRINT "      to produce,  multiply by the minimum wage, contribute that
80 PRINT "      amount and use the program free thereafter.  If that's too
81 PRINT "      much just send $20.   Supporters will receive  free notice 
82 PRINT "      of enhancements and updates.
83 PRINT "           In any case you are encouraged to copy and distribute 
84 PRINT "      UASM to your friends provided you do so free of charge and
85 PRINT "      in unmodified form.
87 PRINT " 
88 PRINT "                      	Guy C. Gordon
89 PRINT "                      	White Crane Systems
90 PRINT "			3194 Friar Tuck Way
91 PRINT "                      	Doraville, GA 30340
100				'INITIALIZATION
110 DEFINT A-Z
120 DIM LIN$(999)
130 TRUE=(1=1): FALSE=NOT TRUE: BELL$=CHR$(7)
132 WARNING$=":		; WARNING!  No code for this label"
135 PRINT
140 INPUT "Enter name of  input file: ",INFILE$
150	DR=INSTR(INFILE$,":"): EXT=INSTR(INFILE$,".")
160	IF EXT=0 THEN INFILE$=INFILE$+".DB": EXT=INSTR(INFILE$,".")
170 INPUT "Enter name of output file: ",OUTFILE$
173	IF INSTR(OUTFILE$,":")=LEN(OUTFILE$) THEN OUTFILE$=OUTFILE$+MID$(INFILE$,DR+1,EXT-DR-1)
175	IF INSTR(OUTFILE$,".")=0 THEN OUTFILE$=OUTFILE$+".JMP"
180 OPEN INFILE$ FOR INPUT AS #1
190 OPEN OUTFILE$ FOR OUTPUT AS #2: PRINT #2,".RADIX	16": PRINT #2,
200 '
400 '-------------------------------------------------------------------------
401 '				READ INPUT FILE		(First pass)	     |
402 '-------------------------------------------------------------------------
405 PRINT: PRINT "Pass 1:   Reading "INFILE$: T1$=TIME$
410 WHILE NOT EOF(1)
420   LINE INPUT #1,A$: IF LEN(A$)<28 THEN 480
425   '				look for various Jumps, CALL, or LOOP
430   IF MID$(A$,25,1)<>"J" AND MID$(A$,25,4)<>"CALL" AND MID$(A$,25,4)<>"LOOP" THEN 480
440   '				make certain we have found a hex address
450   IF MID$(A$,33,1)<"0" OR MID$(A$,33,1)>"F" OR MID$(A$,34,1)<"0" OR MID$(A$,34,1)>"F" OR MID$(A$,35,1)<"0" OR MID$(A$,35,1)>"F" OR MID$(A$,36,1)<"0" OR MID$(A$,36,1)>"F" THEN 480
455   '				skip termination or inter-segment jumps
460   IF MID$(A$,33,4)="0000" OR MID$(A$,37,1)=":" THEN 480
470   LIN=LIN+1: LIN$(LIN)=MID$(A$,33,4)	'Found a reference
480 WEND
490 CLOSE #1			'done with first pass
500 '
600 '-------------------------------------------------------------------------
601 '				SUPER SHELL SORT (Byte, May '83)	     |
602 '-------------------------------------------------------------------------
605 T2$=TIME$
610 PRINT "Sorting:  ";		'sort referenced addresses
620 D=2^INT(LOG(LIN)/LOG(2))-1 
630 FOR I=1 TO LIN-D
640   IF LIN$(I)<=LIN$(I+D) THEN 700 ELSE T$=LIN$(I+D):LIN$(I+D)=LIN$(I)
650   IF I<=D THEN LIN$(I)=T$:GOTO 700
670   FOR J=I-D TO 1 STEP -D:IF T$>=LIN$(J) THEN 690 ELSE LIN$(J+D)=LIN$(J):NEXT
690   LIN$(J+D)=T$
700 NEXT I: PRINT ".";
710 D=INT(D/2):IF D>0 THEN 630 ELSE PRINT: PRINT
800 '-------------------------------------------------------------------------
801 '				ELIMINATE DUPLICATE REFERENCES		     |
802 '-------------------------------------------------------------------------
805 T3$=TIME$
810 I=1: FOR J=2 TO LIN
820   IF LIN$(I)=LIN$(J) THEN 840
830   I=I+1: IF J<>I THEN LIN$(I)=LIN$(J)
840 NEXT J
850 LIN=I
1000 '------------------------------------------------------------------------
1001 '				READ INPUT & WRITE OUTPUT  (Pass 2)	     |
1002 '------------------------------------------------------------------------
1010 T4$=TIME$: L=1 	'now go back thru file and plug in labels for addresses
1020 OPEN INFILE$ FOR INPUT AS #1
1030 FORCE.LABEL=TRUE		'First line is force labeled
1040 WHILE NOT EOF(1) 
1050   LINE INPUT #1, A$: IF LEN(A$)<28 THEN 1490
1100   '			Label This Line?
1110   T$=MID$(A$,6,4)			'offset of this line
1120   IF T$=LIN$(L) THEN MID$(A$,6,6)="L"+T$+":":  L=L+1:  FORCE.LABEL=FALSE:  GOTO 1200
1125   IF FORCE.LABEL AND T$="0100" THEN MID$(A$,6,6)="START:":FORCE.LABEL=FALSE: GOTO 1200
1130   IF FORCE.LABEL THEN MID$(A$,6,6)="L"+T$+":" ELSE MID$(A$,6,6)=SPACE$(6)
1150   IF T$<=LIN$(L) OR L>LIN THEN 1200
1160   PRINT BELL$:   PRINT "L"+LIN$(L)+WARNING$: PRINT
1170   PRINT #2,: PRINT #2, "L"+LIN$(L)+WARNING$: PRINT #2,
1190   L=L+1: GOTO 1120		'Loop back and test next reference
1200   '				Find reference in this line
1210   IF MID$(A$,25,1)<>"J" AND MID$(A$,25,4)<>"CALL" AND MID$(A$,25,4)<>"LOOP" THEN 1300
1220   IF MID$(A$,33,1)<"0" OR MID$(A$,33,1)>"F" OR MID$(A$,34,1)<"0" OR MID$(A$,34,1)>"F" OR MID$(A$,35,1)<"0" OR MID$(A$,35,1)>"F" OR MID$(A$,36,1)<"0" OR MID$(A$,36,1)>"F" OR MID$(A$,37,1)=":" THEN 1300
1230   A$=LEFT$(A$,32)+"L"+MID$(A$,33)		'Make destination addr. a label
1300   '				Test for "The Force"
1310   IF NOT FORCE.LABEL THEN 1400
1320   I=LEN(A$): WHILE MID$(A$,I,1)=" " AND I>26: I=I-1: WEND 'last non-blank
1330   A$=LEFT$(A$,I)+"		;WARNING!  This label not referenced"
1340   PRINT BELL$;
1350   FORCE.LABEL=FALSE
1400   '				FINALLY, print the thing
1410   I=LEN(A$): WHILE MID$(A$,I,1)=" " AND I>26: I=I-1: WEND	'last non-blank
1420   PRINT #2, MID$(A$,6,6)+"  "+MID$(A$,25,I-24)
1430   PRINT     MID$(A$,6,6)+"  "+MID$(A$,25,I-24)
1440   IF MID$(A$,25,3)="JMP" THEN 1470			'one blank line
1450   IF MID$(A$,25,3)<>"RET" AND MID$(A$,25,4)<>"IRET" THEN 1490
1460	 PRINT #2,: PRINT #2,				'two blank lines
1470	 PRINT #2,: PRINT
1480	 FORCE.LABEL=TRUE		'Must have label after JMP(S) or (I)RET
1490 WEND
1500 '------------------------------------------------------------------------
1501 '				END and ERROR Checking			     |
1502 '------------------------------------------------------------------------
1510 IF L>LIN THEN 1550
1520 PRINT BELL$: PRINT "Error: End Of File on "INFILE$"
1530 PRINT "The following refereces were not processed:": PRINT
1540 FOR I=L TO LIN: PRINT LIN$(I),: PRINT #2,"L";LIN$(I);WARNING$: NEXT
1550 PRINT: PRINT " START"," PASS 1","  SORT","  DUPS"," PASS 2"
1560 PRINT T1$,T2$,T3$,T4$,TIME$
1570 CLOSE: END
2000 'End of program UASM-JMP
