10 '--------------------------------------------------------------------------
11 '|	UASM-STR  1.06		23 Oct., 1983		White Crane Systems  |
12 '|	copyright 1983		Guy C. Gordon		3194 Friar Tuck Way  |
13 '|	  						Doraville, GA 30340  |
14 '|									     |
16 '|	This program takes the Unassemble output from UASM-INT and puts in   |
18 '|	the strings printed with DOSCALL PRINT$ (hex 09) and appends to the  |
20 '|	output file, (.STR) the assembler data definitions (DB insructions)  |
22 '|	that are needed to create the strings.  You may also enter up to     |
30 '|	10 address ranges (from DEBUG) and the program will find all strings |
32 '|	within that range and append them also.				     |
44 '|									     |
46 '|	For best speed, and to save wear on your floppy disk drives,	     |
48 '|	specify the input and output files on separate dirves.		     |
50 '********************************* NOTICE *********************************
51 '*          USER SUPPORTED SOFTWARE (With thanks to Andrew Flugelman)     *
52 '*                                                                        *
53 '*   A limited license is granted to all users of this program, to make   *
54 '*   copies of this program and distribute them to other users subject    *
55 '*   to the following conditions:                                         *
56 '*           1.  None of the notices or credits are to be bypassed,       *
57 '*               altered, or removed.                                     *
58 '*           2.  The program is not to be distributed in modified form.   *
59 '*               (Users are encouraged to distribute MERGE files.)        *
60 '*           3.  No fee is to be charged (or any other consideration      *
61 '*               received) for copying or distributing the program        *
62 '*               without an express written agreement with                *
63 '*               White Crane Systems.                                     *
64 '**************************************************************************
70 CLS 'PRINT CHR$(27)+"E";   'CLS
71 PRINT "                                UASM-STR
72 PRINT "              White Crane Systems Unassembler - String Module
73 PRINT "
74 PRINT "           If you are using this program and finding it of value
75 PRINT "      please send  a cash contribution to support its upkeep and
76 PRINT "      distribution.   Use the UASM system  of programs to  unas-
77 PRINT "      semble one average length .COM file, look over the results
78 PRINT "      and calculate how many hours this would have taken you  to
79 PRINT "      to produce,  multiply by the minimum wage, contribute that
80 PRINT "      amount and use the programs free thereafter. If that's too
81 PRINT "      much just send $20.   Supporters will receive  free notice 
82 PRINT "      of enhancements and updates.
83 PRINT "           In any case you are encouraged to copy and distribute 
84 PRINT "      UASM to your friends provided you do so free of charge and
85 PRINT "      in unmodified form.
87 PRINT " 
88 PRINT "                           Guy C. Gordon
89 PRINT "                           White Crane Systems
90 PRINT "                           3194 Friar Tuck Way
91 PRINT "                           Doraville, GA 30340
92 PRINT " 
100	DEFINT A-Z
110	MAXS=200: DIM LIN$(MAXS), S$(MAXS)	'Max # of strings
120	TRUE=(1=1): FALSE=NOT TRUE
130	CR$=CHR$(13): LF$=CHR$(10): TAB$=CHR$(9): ESC$=CHR$(27): DQ$="'"
135	PRINT
140	INPUT "Enter name of  input file: ",INFILE$
150	  DR=INSTR(INFILE$,":"): EXT=INSTR(INFILE$,".")
160	  IF EXT=0 THEN INFILE$=INFILE$+".INT": EXT=INSTR(INFILE$,".")
170	INPUT "Enter name of output file: ",OUTFILE$
180	  IF INSTR(OUTFILE$,":")=LEN(OUTFILE$) THEN OUTFILE$=OUTFILE$+MID$(INFILE$,DR+1,EXT-DR-1)
190	  IF INSTR(OUTFILE$,".")=0 THEN OUTFILE$=OUTFILE$+".STR"
200	INPUT "Enter name of oiginal binary file: ",BINFILE$
210	  IF INSTR(BINFILE$,":")=LEN(BINFILE$) THEN BINFILE$=BINFILE$+MID$(INFILE$,DR+1,EXT-DR-1)
220	  IF INSTR(BINFILE$,".")=0 THEN BINFILE$=BINFILE$+".COM"
300 '-------------------------------------------------------------------------
301 '|				OPEN BINARY FILE & READ STRINGS		     |
302 '-------------------------------------------------------------------------
310	PRINT: PRINT TIME$,"Reading "BINFILE$: PRINT
320	OPEN "R",#3,BINFILE$,1: FIELD #3, 1 AS N$
325	'		This field statement limits the .COM file to 32K
330	PRINT "Enter String Area addresses from DEBUG.  End list with a blank line."
340	PRINT "hhhh kkkk (range) or hhhh (single string address)"
350	FOR I=1 TO 10: LINE INPUT A$
360	  AA$(I)=LEFT$(A$,4): AZ$(I)=MID$(A$,6,4)
370	IF AZ$(I)="" THEN AZ$(I)=AA$(I)
380	IF AA$(I)<>"" THEN NEXT I
400 '-------------------------------------------------------------------------
401 '|				LOOP THROUGH ADDRESS RANGES		     |
402 '-------------------------------------------------------------------------	
410	FOR K=1 TO 10: IF AA$(K)="" THEN 500
420	  START=VAL("&H"+AA$(K))
430	  WHILE START<=VAL("&H"+AZ$(K))
440	    GOSUB 1000			'Get string up to $ terminator
450	    LIN$(L)=HEX$(START): IF START<&H1000 THEN LIN$(L)="0"+LIN$(L)
460	    PRINT "D"+LIN$(L)+TAB$+"DB"+TAB$+S$(L)
470	    START=ENDS+1
480	  WEND	 	
490	NEXT K
500 '------------------------------------------------------------------------
501 '|				     OPEN FILES			            |
502 '------------------------------------------------------------------------
510	PRINT: PRINT TIME$,"Reading "INFILE$
520	PRINT ,"Writing "OUTFILE$: PRINT
530	OPEN  INFILE$ FOR  INPUT AS #1
540	OPEN OUTFILE$ FOR OUTPUT AS #2
600 '------------------------------------------------------------------------
601 '|				     MAIN LOOP				    | 
602 '------------------------------------------------------------------------ 
610	WHILE NOT EOF(1)
620	  LINE INPUT #1,A$
630	  IF MID$(A$,9,6)<>"PRINT$" THEN 770
640	  '			make certain we have a hex address
650	  IF MID$(A$,21,1)<"0" OR MID$(A$,21,1)>"F" OR MID$(A$,22,1)<"0" OR MID$(A$,22,1)>"F" OR MID$(A$,23,1)<"0" OR MID$(A$,23,1)>"F" OR MID$(A$,24,1)<"0" OR MID$(A$,24,1)>"F" THEN 770
660	  D$=MID$(A$,21,4): START=VAL("&H"+D$)	'get string addr
700	  IF START<&H100 THEN 770
710	    I=1			'check for duplicates
720	    WHILE I<=L: IF LIN$(I)=D$ THEN 740 ELSE I=I+1: WEND
730	    GOSUB 1000: LIN$(L)=D$		'Go get string
735	    I=L
740	    PRINT "D"+D$+TAB$+"DB"+TAB$+S$(I)
750	    PRINT #2, MID$(A$,1,14)+",D"+D$+TAB$+";"+S$(I)
760	    GOTO 780
770	  GOSUB 5000		'Check for DX,hhhh & if hhhh -> string
780	WEND
800 '------------------------------------------------------------------------
801 '|				WRITE DB STRINGS TO OUTFILE		    |
802 '------------------------------------------------------------------------
810	PRINT #2, ";END CODE"
820	PRINT #2, ".RADIX	16"
830	PRINT #2, "CR	EQU	0D"
840	PRINT #2, "LF	EQU	0A"
850	PRINT #2, "TAB	EQU	09"
860	PRINT #2, "ESC	EQU	1B"
870	PRINT #2, "$	EQU	24"
900	'			LOOP THROUGH SAVED STRINGS
910	FOR I=1 TO L: PRINT #2, "D"+LIN$(I)+TAB$+"DB"+TAB$+S$(I): NEXT
920	'
930	PRINT: PRINT TIME$,"UASM-STR Complete"
999	END
1000 '-----------------------------------------------------------------------
1001 '|				GET STRING FROM BINARY FILE		    |
1002 '-----------------------------------------------------------------------
1010	INSTRING=FALSE: STR.ERROR=FALSE
1020	L=L+1            			'New string
1030	I=START-&H100                 	'adjust for 100h program prefix
1040	WHILE LEN(S$(L))<180 : I=I+1		'can't let string get too long
1050	  IF I>LOF(3) THEN 3000			'or run past the EOF
1060	  GET #3, I				'I'th char of file.COM into N$
1070	  IF N$="$" THEN 4000			'Found string terminator
1080	  IF N$<" " OR N$>"~" THEN 2000		'non-printing character
1090			'Found characters in a string
1100	  IF NOT INSTRING THEN S$(L)=S$(L)+DQ$: INSTRING=TRUE
1120	  S$(L)=S$(L)+N$
1130	  GOTO 2999				'Read next character
2000 '-----------------------------------------------------------------------
2001 '|				NON-PRINTING CHARACTERS			    |
2002 '-----------------------------------------------------------------------
2010	  IF INSTRING THEN S$(L)=S$(L)+DQ$+",":INSTRING=FALSE 'Terminate string
2020	  IF N$=CR$  THEN S$(L)=S$(L)+"CR,": GOTO 2999
2030	  IF N$=LF$  THEN S$(L)=S$(L)+"LF,": GOTO 2999
2040	  IF N$=TAB$ THEN S$(L)=S$(L)+"TAB,": GOTO 2999
2050	  IF N$=ESC$ THEN S$(L)=S$(L)+"ESC,": GOTO 2999
2400 '-----------------------------------------------------------------------
2401 '|			MAKE NON-PRINTING CHAR A HEX CONSTANT		    |
2402 '-----------------------------------------------------------------------
2410	  IF ASC(N$)<&HA0 AND ASC(N$)>&HF  THEN S$(L)=S$(L)+HEX$(ASC(N$))+"," ELSE S$(L)=S$(L)+"0"+HEX$(ASC(N$))+","
2999	WEND
3000	STR.ERROR=TRUE		'Fell through loop
4000 '-----------------------------------------------------------------------
4001 '|			TERMINATE STRING AND OUTPUT			    |
4002 '-----------------------------------------------------------------------
4010	S$(L)=S$(L)+"$"
4020	IF INSTRING THEN S$(L)=S$(L)+DQ$: INSTRING=FALSE
4050	IF NOT STR.ERROR THEN 4070 
4060	S$(L)=S$(L)+CR$+LF$+TAB$+TAB$+TAB$+"WARNING! String terminator ($) not found"
4070	ENDS=I+&HFF		'end of string
4080	RETURN
5000 '----------------------------------------------------------------------
5001 '|		SEE IF DX IS BEING LOADED WITH A STRING ADDRESS	   	   |
5002 '----------------------------------------------------------------------
5010	IF MID$(A$,17,2)<>"DX" THEN 5100
5020	D$=MID$(A$,20)
5030	IF INSTR(D$," ")<>0 THEN D$=LEFT$(D$,INSTR(D$," ")-1)
5040	IF LEN(D$)<>4 THEN 5100
5050	FOR I=1 TO L: IF LIN$(I)<>D$ THEN NEXT: GOTO 5100
5060	'					Found a string!
5070	PRINT "D"+D$+TAB$+"DB"+TAB$+S$(I)
5080	PRINT #2, LEFT$(A$,19) +"D"+D$+TAB$+";"+S$(I)
5090	RETURN
5100	'					No such luck.
5110	PRINT #2, A$
5120	RETURN
6000 'End of program UASM-STR
