;****************************************************************************
; Filename: C0.ASM
;   Author: Adam Seychell and Peter Anderson
;  Version: 0.0
;  Created: ?
;  Updated: 1995.03.12 - Peter Andersson, general update for DOS32 v3.0
;           1995.07.08 - Added CTRL+BREAK/CTRL+C handler, Adam Seychell
;           1995.11.20 - modified heap allocation to reserve base memory.
;  Comment: Startup file.
;****************************************************************************
; Copyright Adam Seychell, 1994-1995.
; All rights reserved.
;****************************************************************************

    Include STDDEF.INC

; Stack size constant below determines the amount of stack space allocated
; for the application. Adjust this value according to application requirments
; however it must never be set below 256 bytes.

    STACK_SIZE = 1024*16


; The memory heap size. This constant sets the amout of memory to
; initally allocate for the memory pool used by the malloc memory
; functions. If the availible free memory is less than this value then
; it will allocate as much as it can provided its above the contant
; MIN_HEAP_SIZE. 
;

    MAX_HEAP_SIZE = 0FFFFFFFFh



; This constant sets the minimum memory required by the application.
; If the availible memory is less than this value then the program will
; immediatly abort with an 'out of memory' error message.
;
    MIN_HEAP_SIZE = 1024 * 4



; The constant below sets the maximum amount of base memory to reserve once
; the heap has been allocated. This is useful if you would like to run DOS
; programs within a DOS32 application, for example, a DOS shell.

   BASE_MEMORY  = 1024 * 0




;--------------------------------------------------------------------------


    Stack   STACK_SIZE

    Codeseg

Public AbortStackPos
Public NoLanguage ExitSlow,NoLanguage ExitQuick, startup
Extrn __setupio :Near

extrn System_Setup :Near
PROC   startup NoLanguage


            Mov Ax,0EE02h       ; Fixup the standard variables
            Int 31h
            Neg Ebx
            Mov [_psp],Esi
            Mov [_environ],Edi
            Mov [_zero],Ebx
            Mov [exesize],Edx
            Mov [exename],Ecx

            mov ax,0EE21h               ; Hook real mode interrupt 1Bh
            mov esi,offset BREAK_handler
            int 31h
            mov ebx,[_zero]
            mov eax,[ebx+1Bh*4]         ; Save real mode int vector
            mov [_RM_int1Bh_vec],eax
            mov [ebx+1Bh*4],dx          ; Set real mode int vector
            mov [ebx+1Bh*4+2],cx

            mov ax,204h                 ; save INT 23h
            mov bl,23h
            int 31h
            mov [DWORD _int23h_vector],edx
            mov [WORD _int23h_vector+4],cx

            mov ax,205h                 ; set INT 23h
            mov bl,23h
            mov edx,Offset CTRL_C_handler
            mov cx,cs
            int 31h



        Ifndef  NO_DMA
            Mov Eax,0EE41h      ; Allocate 16Kb DMA buffer
            Int 31h
            Jc  @@Exit01
            Mov [DMA_addr],Edx      ; Store near pointer
            Mov [DMA_phys],Ebx      ; Store physical address
        Endif

            Mov Ax,0EE00h
            Int 31h
            And Eax,0FFFFh
            Mov [dos32version],Eax  ; Save DOS32 version number
            Mov [dos32system],Dl    ; Save DOS32 system type
            Mov [_zero_sel],Ebx

     If BASE_MEMORY GT 640*1024
       BASE_MEMORY = 640*1024
     Endif
     If MIN_HEAP_SIZE GT MAX_HEAP_SIZE
       MIN_HEAP_SIZE = MAX_HEAP_SIZE
     Endif


     IfE  MAX_HEAP_SIZE EQ 0

            Mov Edx,MAX_HEAP_SIZE
            test [dos32system],1000b
            jnz @@Allocate_it

        ;  Get memory size.
        ;
            Mov Ax,0EE42h           ; Allocate heap
            Mov Edx,-1
            Int 31h                 ; EAX = size, EDX = ptr
            Push Eax
            Mov Ax,0EE40h           ; Deallocate heap
            Int 31h
            Pop Edx
            Cmp Edx,MAX_HEAP_SIZE
            Jbe  @@J43
            Mov Edx,MAX_HEAP_SIZE
@@J43:
            Sub Edx,MIN_HEAP_SIZE
            Jb @@Exit01

            Sub Edx,BASE_MEMORY
            Jae @@J41
            Clear Edx
@@J41:
            Add Edx,MIN_HEAP_SIZE


@@Allocate_it:

            Mov Ax,0EE42h           ; Allocate heap
            Int 31h                 ; EAX = size, EDX = ptr
            cmp eax,MIN_HEAP_SIZE
            jb @@Exit01

            Xchg    Eax,Edx
            Call    @setmem
            TestZ   Eax
            Jz  @@Exit01
      EndIf

            call    __setupio      ; inialize file stream functions

    ;
    ; Fixup the environment pointer table and it's varibles
    ;
                Mov Eax,[_environ]  ; Get the environment pointer
                Mov Edi,Esp
    Align   4
@@Loop01:       Mov [Esp],Eax       ; Save EAX
                Call    @strlen
                TestZ   Eax
                Jz  @@Next01
                Add Eax,[Esp]
                Inc Eax
                Push    Eax
                Jmp @@Loop01
    Align   4
@@Next01:       Mov Ecx,[Edi]   ; Swap first and last to make the last
                Xchg    [Esp],Ecx   ; one a zero length string
                Mov [Edi],Ecx
                Mov [environ],Esp   ; Save environment pointer table pointer
                Sub Edi,Esp
                Shr Edi,2
                Mov [_envsize],Edi  ; Save environment size


 ;
 ; Fixup command line argument table on the stack
 ;
       ; If the CMDLINE environment varible is availbe then
       ; take the command tail from here. 4DOS command shell
       ; sets this environment varible each time a command is executed
       ;
       ; The CMDLINE environment varible is used on the following conditions;
       ;  It must be present
       ;  The PSP cmd tail is greater than 127 bytes
       ;  The PSP string = the first 127 bytes of CMDLINE string.
       ; Otherwise use the cmd line from offset 80h of the PSP.
       ;
                Mov     Eax,Offset CMDLINE_environ
                Call    @getenv
                TestZ	Eax
                Jz      @@skipEnvCmd
                Mov		Dl,' ' 				; Search for ' '
                call	@strchr
                TestZ	Eax
                Jz      @@skipEnvCmd
                Mov		Esi,Eax				; Save cmdline string ptr
                call	@strlen
                Mov     Ebx,Eax             ; Save CMDLINE length in EBX
                Mov 	Eax,[_psp]
                Add     Eax,80h
                Movzx 	Ecx,[BYTE Eax]      ; Get size of psp cmd string
                Cmp     Ecx,127
                Jl      @@skipEnvCmd        ; use psp cmd tail if < 127
                Inc     Eax
                Mov     Edx,Esi
                call    @strncmp
                TestZ   Eax
                jz      @@copycmdtail
@@skipEnvCmd:
                Clear   Ebx
                Mov 	Eax,[_psp]
                Mov 	Bl,[Eax+80h]
                Lea     Esi,[Eax+81h]     ; Esi -> first character in cmd tail

@@copycmdtail:  Mov     Ecx,Ebx
                Sub     Esp,Ebx           ; Allocate mem for cmd tail
                Sub		Esp,8
                And		Esp,NOT 3		  ; always keep ESP aligned
                Mov     Edi,Esp
                Cld
                Rep     Movsb             ; copy cmd tail to stack
                Mov     Ecx,Ebx           ; restore Ecx
                Lea     Edi,[Esp+Ecx-1]   ; Esi -> last character in cmd tail
                Std
                Mov     Al," "
                Mov     Ebx,1

CmdTailLoop:
                Repe    Scasb                   ; search for a non " " char

                TestZ   Ecx
                Jz      TailExit
                Inc     Ebx
                Inc     Edi
                Mov     [Byte Edi+1],0
                Inc     Ecx
                Repne   Scasb                   ; search for a " " char
                Inc     Edi
                Push    Edi                     ; push argv[] pointer on stack
                Inc     [Dword PTR Esp]
                TestZ   Ecx
                Jz      TailExit
                Inc     Ecx
                jmp     CmdTailLoop
TailExit:       Push    [exename]             ; Store EXE file namepath
                Mov     Eax,Esp


                Mov [AbortStackPos],Esp ; Save the stack pointer

    ; Save in these varibles
    ;
                mov     [_argc],ebx
                mov     [_argv],eax
    ;
    ; Call the main!    /*  int main ( int argc, char * argv[], environ); */
    ;
                Push    [_environ]            ; pass environment pointer
                Push    Eax                   ; pass pointer to pointer array
                Push    Ebx                   ; pass arg count
                Call    main                  ; Start up the main()!

ExitSlow:       Mov Esi,Eax
                Call _cexit
ExitQuick:      mov ebx,[_zero]             ; restore Real Mode int 1Bh
                mov eax,[_RM_int1Bh_vec]
                mov [ebx+1Bh*4],eax
                mov ax,205h                 ; restore int 23h vector
                mov bl,23h
                mov edx,[DWORD _int23h_vector]
                mov cx,[WORD _int23h_vector+4]
                int 31h
                Mov Eax,Esi
                Mov Ah,4Ch
                Int 21h
    Align   4
@@Exit01:       Mov Edx,Offset MemoryError
                Mov Ah,9
                Int 21h
                Mov Al,3
                Jmp ExitQuick
ENDP


;
; BIOS CTRL+BREAK handler. This is called when a real mode interrupt 1Bh
; has occured.
;
PROC BREAK_handler
        Push    DS
        Push    Eax
        Mov     ax,SEG ctrl_break_count
        Mov     ds,ax
        inc     [ctrl_break_count]
        Pop     Eax
        Pop     DS
        retf
ENDP

;
; DOS CTRL+C/CTRL+BREAK handler. This is called when protected mode
; int 23H is called. DOS32 initially redirects real mode int 23h
; to the protected mode int 23h.
;
PROC CTRL_C_handler      ;( protected mode INT 23h handler )
        Push    DS
        Push    Eax
        Mov     ax,SEG ctrl_break_count
        Mov     ds,ax
        inc     [ctrl_break_count]
        Pop     Eax
        Pop     DS
        Iretd
ENDP



    Dataseg

    Ifndef  NO_DMA
DMA_addr    Dd  ?           ; DMA near pointer address
DMA_size    Dd  8192            ; DMA size in bytes
DMA_phys    Dd  ?           ; DMA physical address
    Endif


_environ        Dd  ?       ; pointer to environment
_envsize        Dd  ?       ; environment table entries.
environ         Dd  ?       ; Table environment pointer
_psp            Dd  ?       ; PSP pointer
exesize         Dd  ?       ; Executable size
exename         Dd  ?       ; Executable name
_zero           Dd  ?       ; Relative address to zero
_zero_sel       Dd  ?       ; 4GB ZERO selector (not NULL!)
_argc           Dd  ?       ; commane line ptr table size
_argv           Dd  ?       ; ptr of command line ptr table
_RM_int1Bh_vec  Dd  ?       ; origonal Real Mode int 1Bh vector
_int23h_vector  Df  ?       ; origonal int 23h vector
dos32version    Dd  ?       ; DOS32 version
dos32system     Db  ?       ; System extender type

AbortStackPos   Dd  ?       ; Saved stack position (abort)
ExitStatus      Db  3       ; Exit status
ctrl_break_count Db     0       ; Ctrl+C/Break count varible
CMDLINE_environ Db  "CMDLINE",0

MemoryError Db  "Out of memory...",CRLF,'$'

    End startup
