;****************************************************************************
; Filename: FFLUSH.ASM
;   Author: Adam Seychell
;  Version: 0.0
;  Created: 1995.April.29
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: int @fflush(FILE * stream);
;  Comment: imeadiatly writes output buffer contents to device.
;    Input: Eax = pointer to file stream.
;   Output: 0 if successful, EOF if error.
;****************************************************************************
; Function: void __updatebuffer(FILE * stream)
;  Comment: updates file i/o buffer.
;    Input: Eax = pointer to opened file stream.
;   Output: Nothing.
;****************************************************************************

        Include STDDEF.INC


Public __UpdateBuffer

        Codeseg

Proc fflush , 1
        Push    Edi
        Mov     Edi,Eax
        Test    [Edi+FILE._mode],8              ; Error if error flag
        Jnz      @@error
        Test    [Edi+FILE._mode],2
        Jz      @@reset_read
        Mov     Edx,[Edi+FILE._base]           ; only flush writables
        Mov     Ecx,[Edi+FILE._position]
        TestZ   Ecx
        Jz      @@exit
        Mov     [Edi+FILE._position],0          ; clear buffer
        Mov     Ax,[Edi+FILE._handle]
        Call    @write
        Cmp     Eax,-1
        Jne     @@exit
@@error:
        Or      [Edi+FILE._mode],8          ; mark error flag
        Mov     Eax,EOF
        Pop     Edi
        Ret

@@reset_read:
        Test    [Edi+FILE._mode],1          ; if readabale then sub position
        jz      @@exit
        Mov     Edx,[Edi+FILE._position]
        Sub     Edx,[Edi+FILE._size]
        Jz      @@exit
        Mov     [Edi+FILE._position], 0
        Mov     [Edi+FILE._size], 0
        Mov     Ax, [Edi+FILE._handle]
        Mov     Ecx, SEEK_CUR
        call    @lseek                      ; seek to end of buffer position
        Cmp     Eax,-1
        Je      @@error
@@exit:
        Xor     Eax,Eax
        Pop     Edi
        Ret

Endp

PROC __UpdateBuffer
        Push    Edi
        Mov     Edi,Eax
        Mov     [Edi+FILE._position],0
        Mov     Ax,[Edi+FILE._handle]
        Mov     Edx,[Edi+FILE._base]
        Mov     Ecx,[Edi+FILE._buffersize]
        Call    @read
        Cmp     Eax,-1
        Je      @@error
        Mov     [Edi+FILE._size],Eax
        Pop     Edi
        Ret
@@error:
        Mov     [Edi+FILE._size],0
        Pop     Edi
        Ret
Endp

        End
