;****************************************************************************
; Filename: FPUTC.ASM
;   Author: Adam Seychell
;  Version: 0.0
;  Created: 1995.Aug.11
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: char @fputc(char,  FILE * stream)
;  Comment: writes a single character to file stream.
;    Input: Eax = pointer to opened file stream.
;    Input: Dl = character to write.
;   Output: Eax = character written to file/device. Returns EOF on error.
;****************************************************************************

        Include STDDEF.INC


Extrn __UpdateBuffer:Near

        Codeseg

Proc  fputc, 2
        Push    Eax
;        Test    [Edx+FILE._mode],2          ; Error if not writable
;        Jz      @@EOF
;        And     [Edx+FILE._mode],NOT 1      ; clear readable flag


        Mov     Ecx, [edx+FILE._position]
        Add     Ecx, [edx+FILE._base]
        Mov     [ecx],Al                    ; Put character in buffer.
        Inc     [edx+FILE._position]

        Mov     Ecx, [edx+FILE._position]
        Cmp     Ecx, [edx+FILE._buffersize]
        Jb      @@NoUpdate1                 ; flush buffer when full.
        Mov     Eax,Edx
        Call    @fflush
        And     Eax,Eax
        Jnz     @@EOF
@@NoUpdate1:
        Pop     Eax
        And     Eax,0FFh
        Ret

@@EOF:
        Pop     Eax
        Mov     Eax,EOF
        Ret

Endp

        End
