;****************************************************************************
; Filename: FSEEK.ASM
;   Author: Adam Seychell
;  Version: 0.0
;  Created: 1995.April.29
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: int @fseek(FILE * file_pointer, int offset, int whence )
;  Comment: Repositions the position marker in the file referenced by
;           file_pointer.
;    Input: Eax = file_pointer
;           Edx = signed number of bytes to seek
;           Ecx = seek type; 0 = from start of file.
;                            1 = from current position.
;                            2 = from end of file.
;   Output: 0 if successful, otherwise non zero;
;****************************************************************************

        Include STDDEF.INC

        Codeseg


Proc    fseek, 3
        Push    Eax
        Push    Edx
        Push    Ecx
        Call    @fflush
        Cmp     Eax,EOF
        Pop     Ecx
        Pop     Edx
        Pop     Eax
        Je      @@error
        Mov     Ax, [Eax+FILE._handle]
        call    @lseek                      ; do the file seek
        Cmp     Eax,-1
        Je      @@error
        Clear   Eax
@@error:
        Ret
Endp


        End
