;**************************************************************************
;  EG4.ASM
;
;  This example program will display the current directory
;
; By Adam Seychell
;**************************************************************************
.386
.model  flat
.stack 200h
.code

ASCIIZ_path     db  '*.*',0         ; String for search path
PSP_Address     DD  0


Start32:                        ; first intruction executed here

  ;
  ;  Call the DOS's "Find first" service
  ;
        mov     edx,offset ASCIIZ_path
        mov     cx,00000b
        mov     ah,4Eh
        int     21h
        jc exit
              ; The file info is put in the DTA buffer which is initally set
              ; to offset 80h in the PSP segment


        mov     ax,0EE02h            ; Get DOS32 address information
        int     31h
        mov     PSP_Address,esi      ; Save the PSP pointer.

;--------------------------- file display loop ---------------------------
Find_next_loop:
        mov     edi,PSP_Address
        add     edi,80h+1Eh


         ; Print ASCIIZ string that was stored in the DTA buffer.
	 ;
      str_loop:
                mov     al,[edi]              ; get char from DTA
                cmp     al,0                  ; if zero the string has ended
	        jz string_end
                call Print_Char               ; plot it
                inc edi                       ; get next char
                jmp str_loop                  ; loop around

string_end:
 ;
 ; Finished printing the ASCIIZ file name.   Now to carrage return
 ;
       mov al,10
       call Print_Char
       mov al,13
       call Print_Char

;
;    Loop around and keep on calling DOS's "Find Next" service until there
; are no more files left.
;
       mov  ah,4Fh
       int  21h
       jnc Find_next_loop

exit:
        mov     ah,4ch
        int     21h




 ;
 ; A procedure to send character to the screen.
 ;
Print_Char PROC
        mov     bh,0
        mov     ah,0Eh
        int     10h
        ret
Print_Char ENDP


END Start32
