;****************************************************************************
; EMSINFO displays information about expanded memory, including the EMS
; version number, the amount of expanded memory installed and available,
; the number of active handles, and the page frame segment. Its syntax is:
;
;       EMSINFO
;
; If the EMS version is 4.0 or higher, EMSINFO also reports the number of
; EMS handles available.
;****************************************************************************

code            segment
                assume  cs:code,ds:code
                org     100h
begin:          jmp     main

copyright       db      "EMSInfo 1.1 Copyright (c) 1993 Jeff Prosise",13,10
                db      "From: PC Magazine DOS 6 Memory Management "
                db      "with Utilities",13,10,13,10,"$"

helpmsg         db      "Displays information about expanded memory."
crlf            db      13,10,"$"

devname         db      "EMMXXXX0"
errmsg1         db      "No expanded memory manager installed",13,10,"$"
errmsg2         db      "EMS error. Reload the EMS driver and try again."
                db      13,10,"$"

text1           db      "  EMS version  . . . . . . . . . . . . . . . . .  $"
text2           db      "  Available expanded memory pages  . . . . . . . $"
text3           db      "  Unallocated expanded memory pages  . . . . . . $"
text4           db      "  Available expanded memory handles  . . . . . . $"
text5           db      "  Active expanded memory handles . . . . . . . . $"
text6           db      "  Page frame segment . . . . . . . . . . . . . . $"
text7           db      "None$"

ems_version             db      ?               ;EMS version number
ems_pages_total         dw      ?               ;Total EMS pages
ems_pages_free          dw      ?               ;Available EMS pages
ems_handles_total       dw      ?               ;Total EMS handles
ems_handles_active      dw      ?               ;Active EMS handles
ems_page_frame          dw      0               ;Page frame segment

;****************************************************************************
; Procedure MAIN
;****************************************************************************

main            proc    near
                cld                             ;Clear direction flag
                mov     si,81h                  ;Point SI to command line
                call    scanhelp                ;Scan for "/?" switch
                jnc     main1                   ;Branch if not found

                mov     ah,09h                  ;Display help text and exit
                mov     dx,offset helpmsg       ;with ERRORLEVEL=0
                int     21h
                mov     ax,4C00h
                int     21h
;
; Make sure there is an expanded memory manager installed.
;
main1:          mov     ah,09h                  ;Display the copyright
                mov     dx,offset copyright     ;message
                int     21h

                mov     ax,3567h                ;Check for the signature
                int     21h                     ;"EMMXXX0" 10 bytes past
                mov     di,10                   ;the point that the INT
                mov     si,offset devname       ;67h vector points to
                mov     cx,8
                repe    cmpsb
                je      main2                   ;Branch if driver found
                mov     dx,offset errmsg1       ;Display error message if
                jmp     short error_2           ;driver not installed

ems_error:      mov     dx,offset errmsg2       ;Display error message
error_2:        mov     ah,09h                  ;and exit with
                int     21h                     ;ERRORLEVEL=1
                mov     ax,4C01h
                int     21h
;
; Get the information we need from the driver.
;
main2:          mov     ax,cs                   ;Make sure the driver and
                mov     es,ax                   ;hardware are functioning
                mov     ah,40h
                int     67h
                or      ah,ah
                jnz     ems_error

                mov     ah,46h                  ;Get the EMS version
                int     67h
                or      ah,ah
                jnz     ems_error
                mov     ems_version,al

                mov     ah,41h                  ;Get the page frame address
                int     67h
                or      ah,ah
                jnz     main3
                mov     ems_page_frame,bx

main3:          mov     ah,42h                  ;Get the number of pages
                int     67h                     ;present and available
                or      ah,ah
                jnz     ems_error
                mov     ems_pages_total,dx
                mov     ems_pages_free,bx

                mov     ah,4Bh                  ;Get the number of active
                int     67h                     ;handles
                or      ah,ah
                jnz     ems_error
                mov     ems_handles_active,bx

                cmp     ems_version,40h         ;If this is EMS 4.0 or
                jb      main4                   ;higher, get the number
                mov     ax,5402h                ;of handles supported
                int     67h
                or      ah,ah
                jnz     ems_error
                mov     ems_handles_total,bx
;
; Output the results.
;
main4:          mov     ah,09h                  ;Display the EMS version
                mov     dx,offset text1         ;number
                int     21h
                mov     ah,02h
                mov     dl,ems_version
                mov     cl,4
                shr     dl,cl
                add     dl,30h
                int     21h
                mov     ah,02h
                mov     dl,"."
                int     21h
                mov     dl,ems_version
                and     dl,0Fh
                add     dl,30h
                int     21h
                call    newline

                mov     ah,09h                  ;Display total pages
                mov     dx,offset text2
                int     21h
                mov     ax,ems_pages_total
                call    bin2asc

                mov     ah,09h                  ;Display free pages
                mov     dx,offset text3
                int     21h
                mov     ax,ems_pages_free
                call    bin2asc

                cmp     ems_version,40h         ;Branch if EMS version is
                jb      main5                   ;4.0 or less
                mov     ah,09h                  ;Display total handles
                mov     dx,offset text4
                int     21h
                mov     ax,ems_handles_total
                call    bin2asc

main5:          mov     ah,09h                  ;Display active handles
                mov     dx,offset text5
                int     21h
                mov     ax,ems_handles_active
                call    bin2asc

                mov     ah,09h                  ;Display page frame segment
                mov     dx,offset text6
                int     21h
                cmp     ems_page_frame,0
                jne     main6
                mov     ah,09h
                mov     dx,offset text7
                int     21h
                jmp     short main7
main6:          mov     ax,ems_page_frame
                call    bin2hex
main7:          call    newline

                mov     ax,4C00h                ;Exit with ERRORLEVEL=0
                int     21h
main            endp

;****************************************************************************
; SCANHELP scans the command line for a /? switch. If found, carry returns
; set and SI contains its offset. If not found, carry returns clear.
;****************************************************************************

scanhelp        proc    near
                push    si                      ;Save SI
scanloop:       lodsb                           ;Get a character
                cmp     al,0Dh                  ;Exit if end of line
                je      scan_exit
                cmp     al,"?"                  ;Loop if not "?"
                jne     scanloop
                cmp     byte ptr [si-2],"/"     ;Loop if not "/"
                jne     scanloop

                add     sp,2                    ;Clear the stack
                sub     si,2                    ;Adjust SI
                stc                             ;Set carry and exit
                ret

scan_exit:      pop     si                      ;Restore SI
                clc                             ;Clear carry and exit
                ret
scanhelp        endp

;****************************************************************************
; BIN2ASC converts a binary value in AX to ASCII form and displays it
; right-justified.
;****************************************************************************

bin2asc         proc    near
                mov     bx,10                   ;Initialize divisor word and
                xor     cx,cx                   ;digit counter
b2a1:           inc     cx                      ;Increment digit count
                xor     dx,dx                   ;Divide by 10
                div     bx
                push    dx                      ;Save remainder on stack
                or      ax,ax                   ;Loop until quotient is zero
                jnz     b2a1

                push    cx                      ;Output spaces to right-
                mov     bx,cx                   ;justify the output
                mov     cx,4
                sub     cx,bx
                jcxz    b2a3
b2a2:           mov     ah,02h
                mov     dl,20h
                int     21h
                loop    b2a2
b2a3:           pop     cx

b2a4:           pop     dx                      ;Retrieve a digit from stack
                add     dl,30h                  ;Convert it to ASCII
                mov     ah,2                    ;Display it
                int     21h
                loop    b2a4                    ;Loop until done
                call    newline                 ;Move cursor to next line
                ret
bin2asc         endp

;****************************************************************************
; BIN2HEX displays the 4-digit hex number in AX.
;****************************************************************************

bin2hex         proc    near
                mov     cx,4
b2h1:           push    cx
                mov     cx,4
                xor     dl,dl
b2h2:           shl     ax,1
                rcl     dl,1
                loop    b2h2
                add     dl,30h
                cmp     dl,39h
                jbe     b2h3
                add     dl,7
b2h3:           push    ax
                mov     ah,02h
                int     21h
                pop     ax
                pop     cx
                loop    b2h1
                ret
bin2hex         endp

;****************************************************************************
; NEWLINE moves the cursor to the next line.
;****************************************************************************

newline proc    near
                mov     ah,09h
                mov     dx,offset crlf
                int     21h
                ret
newline         endp

code            ends
                end     begin
