;****************************************************************************
; H2D displays a hexadecimal number in decimal format. Its syntax is:
;
;       H2D hex-value
;
; where "hex-value" is a hexadecimal value from 0 to FFFFFFFFh.
;****************************************************************************

code            segment
                assume  cs:code,ds:code
                org     100h
begin:          jmp     main

helpmsg         db      "Displays a hexadecimal number in decimal format."
                db      13,10,13,10
                db      "H2D hex-value",13,10,"$"

errmsg1         db      "Syntax: H2D hex-value",13,10,"$"
errmsg2         db      "Number too large (cannot exceed FFFFFFFF)",13,10,"$"
errmsg3         db      "Invalid digit"
crlf            db      13,10,"$"

loword          dw      0                       ;Accumulator (low word)
hiword          dw      0                       ;Accumulator (high word)

;****************************************************************************
; Procedure MAIN
;****************************************************************************

main            proc    near
                cld                             ;Clear direction flag
                mov     si,81h                  ;Point SI to the command line
                call    scanhelp                ;Scan for a "/?" switch
                jnc     main1                   ;Branch if not found

                mov     ah,09h                  ;Display help text
                mov     dx,offset helpmsg
                int     21h
                jmp     exit                    ;Exit

main1:          call    findchar                ;Find the start of the string
                jc      error1                  ;Error if there is no string
                xor     cx,cx                   ;Zero digit count in CX

main2:          lodsb                           ;Get the next digit
                cmp     al,20h                  ;Branch if it's a space,
                je      main4                   ;tab, or end-of-line
                cmp     al,09h                  ;character
                je      main4
                cmp     al,0Dh
                je      main4

                cmp     cx,8                    ;Error if this is the
                je      error2                  ;ninth digit
                inc     cx

                call    reduce                  ;ASCII -> binary (DX)
                jc      error3                  ;Error if it's invalid

                push    cx                      ;Mulitply the current value
                mov     bx,loword               ;by 16 and add the value
                mov     ax,hiword               ;of the digit just read
                mov     cx,4
main3:          shl     bx,1
                rcl     ax,1
                loop    main3
                add     bx,dx
                adc     ax,0
                mov     loword,bx
                mov     hiword,ax
                pop     cx
                jmp     main2

main4:          mov     bx,loword               ;Display the number
                mov     ax,hiword
                call    bin2dec

exit:           mov     ax,4C00h                ;Return to DOS
                int     21h
;
; Error handling routines.
;
error1:         mov     dx,offset errmsg1
                jmp     short error
error2:         mov     dx,offset errmsg2
                jmp     short error
error3:         mov     dx,offset errmsg3
error:          mov     ah,09h
                int     21h
                jmp     exit
main            endp

;****************************************************************************
; REDUCE converts the hex digit in AL to a binary value from 0 to 15 in
; DX. On return, carry set means the digit was not a valid hex character.
;****************************************************************************

reduce          proc    near
                cmp     al,"0"                  ;Convert "0" thru "9"
                jb      r_error
                cmp     al,"9"
                ja      r1
                mov     dl,al
                sub     dl,30h
r_exit:         xor     dh,dh
                clc
                ret

r1:             cmp     al,"A"                  ;Convert "A" thru "F"
                jb      r_error
                cmp     al,"F"
                ja      r2
                mov     dl,al
                sub     dl,55
                jmp     r_exit

r2:             cmp     al,"a"                  ;Convert "a" thru "f"
                jb      r_error
                cmp     al,"f"
                ja      r_error
                mov     dl,al
                sub     dl,87
                jmp     r_exit

r_error:        stc                             ;Set carry and exit
                ret
reduce          endp

;****************************************************************************
; BIN2DEC displays the number in AX:BX in decimal format.
;****************************************************************************

bin2dec         proc    near
                xor     cx,cx
                mov     di,10

b2d1:           xor     dx,dx
                div     di
                mov     si,ax
                mov     ax,bx
                div     di
                mov     bx,ax
                mov     ax,si
                inc     cx
                push    dx
                or      ax,ax
                jnz     b2d1
                or      bx,ax
                jnz     b2d1

b2d2:           mov     ah,02h
                pop     dx
                add     dl,30h
                int     21h
                loop    b2d2

                mov     ah,09h
                mov     dx,offset crlf
                int     21h
                ret
bin2dec         endp

;****************************************************************************
; FINDCHAR advances SI to the next non-white-space character. On return,
; carry set indicates EOL was encountered; carry clear indicates it was not.
;****************************************************************************

findchar        proc    near
                lodsb                           ;Get the next character
                cmp     al,09h                  ;Loop if tab
                je      findchar
                cmp     al,20h                  ;Loop if space
                je      findchar
                cmp     al,2Ch                  ;Loop if comma
                je      findchar
                dec     si                      ;Point SI to the character
                cmp     al,0Dh                  ;Exit with carry set if end
                je      eol                     ;of line is reached

                clc                             ;Clear carry and exit
                ret

eol:            stc                             ;Set carry and exit
                ret
findchar        endp

;****************************************************************************
; SCANHELP scans the command line for a /? switch. If the switch is found,
; carry returns set and SI contains the switch offset. If the switch is not
; found, carry returns clear.
;****************************************************************************

scanhelp        proc    near
                push    si                      ;Save SI
scanloop:       lodsb                           ;Get a character
                cmp     al,0Dh                  ;Exit if end of line
                je      scan_exit
                cmp     al,"?"                  ;Loop if not "?"
                jne     scanloop
                cmp     byte ptr [si-2],"/"     ;Loop if not "/"
                jne     scanloop

                add     sp,2                    ;Clear the stack
                sub     si,2                    ;Adjust SI
                stc                             ;Set carry and exit
                ret

scan_exit:      pop     si                      ;Restore SI
                clc                             ;Clear carry and exit
                ret
scanhelp        endp

code            ends
                end     begin
