
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pharlap.h>
#include "exc.h"


void main (int argc, char **argv)
{
  char ex;

  if ((argc != 2) || (strcmp(argv[1],"-?") == 0))
  {
    printf("Usage: DEMO_1 <exc number>\n"   \
           "\t 0  divide error\n");
#if defined(__BORLANDC__) || defined(__MSC__)
    printf("\t 3  break point\n"            \
           "\t 4  integer overflow\n"       \
           "\t 5  array bound\n"            \
           "\t 6  Illegal opcode\n");
#endif
    printf("\t11  segment not present\n" \
           "\t12  stack fault\n"         \
           "\t13  general protection\n"  \
           "\t14  page fault\n");
    exit(1);
  }

  InstallExcHandler (NO_EXC_USR_HOOK,   /* no application exception hook */
                     DO_EXC_REG_DUMP);  /* make regs/instr/callee dump   */

  ex = atoi(argv[1]);
  switch (ex)
  {
    UINT page;
    FARPTR fp;
    char buf[1];
    char *p;
    unsigned int limit[2] = {1,10};
    int a=0, b=3, c;

    case 0  : c = b/a;
              a += c;     /* BCC32 optimizes off c=b/a */
              break;

#if defined(__BORLANDC__) || defined(__MSC__)
    case 3  : _asm int 3
              break;
    case 4  : c = b * 0x7FFFFFFF;
              _asm into
              a += c;
              break;
    case 5  : _asm mov esi,11
              _asm bound esi,limit
              break;
    case 6  : _asm db 0C2h,34h,12h,0Fh,31h
              break;
#endif
    case 11 : FP_SET(fp,NULL,0x84);
              PeekFarByte(fp);
              break;
    case 12 : p = (char*)buf[0x10000];
              *p = 0;
              break;
    case 13 : p  = (char*) -1;
              *p = 1;
              break;
    case 14 : _dx_add_umapg(SS_DATA,1,&page);
              p = (char*)page;
              *p = 1;
              break;
    default : printf ("No action for exception %d defined",ex);
  }
}

