
PAGE 60,132
TITLE Exception handler for PharLap 386|DosX
NAME  EXC_0
.386


ExcStruc struc
     Number  dw  0
     Code    dw  0
     _DS     dw  0
     _ES     dw  0
     _FS     dw  0
     _GS     dw  0
     _SS     dw  0
     _CS     dw  0
     _EIP    dd  0
     _EAX    dd  0
     _EBX    dd  0
     _ECX    dd  0
     _EDX    dd  0
     _ESI    dd  0
     _EDI    dd  0
     _EFlags dd  0
     _ESP    dd  0
     _EBP    dd  0
ExcStruc ends


;****************************************************************

_DATA SEGMENT PUBLIC DWORD USE32 'DATA'

      excHookMain  dd        0          ; HLL hook to exceptions
      except       ExcStruc  <>

  ;                dd 256 dup (?)       ; exception handler stack
  ;   exc_TOS      label dword          ; stack start

      EXTRN  oldExcHandlers : dword     ; array[0..17] of far-pointers
      PUBLIC except, excHookMain
_DATA ENDS

_TEXT SEGMENT PUBLIC DWORD USE32 'CODE'
      ASSUME CS:_TEXT, DS:_DATA


comment ~

 A HLL interface for user installed exception handlers

 Stack layout:   ofs  38h   CR2       At time of orignal int
                      34h   INT #     Int/Exception number
                      30h   DosxFlag  For DosX umbrella handler
                      2Ch   GS        At time of orignal int
                      28h   FS        At time of orignal int
                      24h   DS        At time of orignal int
                      20h   ES        At time of orignal int
                      1Ch   SS        At time of orignal int
                      18h   ESP       At time of orignal int
                      14h   EFLAGS    At time of orignal int
                      10h   CS        At time of orignal int
                      0Ch   EIP       At time of orignal int
                      08h   EFLAGS    For DosX umbrella handler
                      04h   CS        For DosX umbrella handler
           SS:ESP->   00h   EIP       For DosX umbrella handler
           SS:ESP->  -04h   Code      Exception code for exc 8,10-14

        ~
_Rmode      equ 1                         ; int occurred in real mode
_LDSregs    equ 2                         ; load seg regs on return

;
; Stack layout refered to ss:[ebx]. EBX = entry ESP.
;
ex_CR2      equ (dword ptr ss:[ebx+38h])  ; CR2 at time of interrupt
ex_INUM     equ (dword ptr ss:[ebx+34h])  ; interrupt number
ex_FL       equ (dword ptr ss:[ebx+30h])  ; flag bits, value 0-3
ex_GS       equ (dword ptr ss:[ebx+2Ch])  ; GS at time of interrupt
ex_FS       equ (dword ptr ss:[ebx+28h])  ; FS at time of interrupt
ex_DS       equ (dword ptr ss:[ebx+24h])  ; DS at time of interrupt
ex_ES       equ (dword ptr ss:[ebx+20h])  ; ES at time of interrupt
ex_SS       equ (dword ptr ss:[ebx+1Ch])  ; SS:ESP at time of interrupt
ex_ESP      equ (dword ptr ss:[ebx+18h])  ;
ex_EFLAGS   equ (dword ptr ss:[ebx+14h])  ; EFLAGS at time of interrupt
ex_CS       equ (dword ptr ss:[ebx+10h])  ; CS:EIP at time of interrupt
ex_EIP      equ (dword ptr ss:[ebx+0Ch])  ;
ex_DOSX_EFL equ (dword ptr ss:[ebx+08h])  ; return stack frame in
ex_DOSX_CS  equ (dword ptr ss:[ebx+04h])  ; 386|DOS-Extender handler
ex_DOSX_EIP equ (dword ptr ss:[ebx+00h])  ; return address
ex_ICODE    equ (dword ptr ss:[ebx-04h])  ; exception error code


;---------------------------------------------------------------

align 4
PUBLIC ExcGlue_0                       ; ISR for exception 0-7,9,15-17
ExcGlue_0:
        push eax                       ; save registers used
        push ebx
        mov ebx,esp
        add ebx,8                      ; EBX -> DOSX_EIP
        mov except.Code,0              ; no exception code
        call ExcGlueMain               ; fill ExcStruc, patch return address
        pop ebx
        pop eax
        iretd                          ; IRET and continue at ExcCont below

align 4
PUBLIC ExcGlue_1                       ; ISR for exception 8, 10-14
ExcGlue_1:
        push eax                       ; save registers used
        push ebx
        mov ebx,esp
        add ebx,0Ch                    ; EBX -> DOSX_EIP
        mov eax,ex_ICODE               ; save exception code
        mov except.Code,ax
        call ExcGlueMain               ; fill ExcStruc, patch return address
        pop ebx
        pop eax
        add esp,4                      ; discard error code
        iretd                          ; IRET and continue at ExcCont

;-------------------------------------------------------------------
;
;  DosX umbrella handler tranfers control to this point
;

ExcCont:cmp excHookMain,0              ; HLL hook installed ?
        je ToDosx                      ; no, back to Dosx
        sti
        call [excHookMain]             ; yes, no HLL processing
        mov esp,except._ESP            ; get old ESP, EBP unchanged
        jmp [except._EIP]              ; return to EIP

ToDosx: push eax
        push ecx
        movzx eax,except.Number        ; get exception number
        mov cl,al
        imul eax,6                     ; far pointer is 6 bytes
        lea eax,oldExcHandlers[eax]
        push ds
        mov edx,[eax]
        mov ds,[eax+4]
        mov eax,2533h                  ; set exception vector
        int 21h
        pop ds
        mov eax,except._EIP            ; get EIP for exception
        mov [esp+8],eax                ; put on stack
        pop ecx
        pop eax
        ret                            ; return to cause of exception


;-------------------------------------------------------------------

ex_EBX   equ (dword ptr [esp+4])       ; EBX saved on stack
ex_EAX   equ (dword ptr [esp+8])       ; EAX on stack

align 4
ExcGlueMain:
        mov eax,ex_INUM                ; load exception number
        mov except.Number,ax           ; store it
        mov except._ECX,ecx
        mov except._EDX,edx
        mov except._EDI,edi            ; EDI register
        mov except._ESI,esi            ; ESI register
        mov except._EBP,ebp            ; EBP register

        mov eax,ex_EAX
        mov except._EAX,eax            ; EAX register
        mov eax,ex_EBX
        mov except._EBX,eax            ; EBX register
        mov eax,ex_EIP
        mov except._EIP,eax            ; EIP register
        mov eax,ex_CS
        mov except._CS,ax              ; CS register
        mov eax,ex_EFLAGS
        and eax,not 10000h             ; clear resume flag
        mov except._EFlags,eax         ; EFlag register
        mov eax,ex_ESP
        mov except._ESP,eax            ; ESP register
        mov eax,ex_SS
        mov except._SS,ax              ; SS register
        mov eax,ex_ES
        mov except._ES,ax              ; ES register
        mov eax,ex_DS
        mov except._DS,ax              ; DS register
        mov eax,ex_FS
        mov except._FS,ax              ; FS register
        mov eax,ex_GS
        mov except._GS,ax              ; GS register

        mov eax,offset cs:ExcCont
        mov ex_EIP,eax                 ; patch EIP resume location
        and ex_FL,not _LDSregs         ; don't reload segment registers
        mov ax,cs
        add ax,8
        mov ds,ax                      ; reload DS/ES incase <> SS_DATA
        mov es,ax
        ret

_TEXT ENDS
END

