/* FFTS.H                                                                    */
/* Basic definitions needed to set up protected-mode operation               */
/* These are defined for ordinary 16-bit real mode Borland C++ 3.1           */
/* For bit fields, the first field is the low-order bit...                   */
/*     structures, the first field is the low-order address                  */

/*--- Segment Attribute Byte                                                 */

struct SEG_ATTR {
   WORD SegLimitHigh : 4;              // Segment limit high nybble
   WORD Available : 1;                 // 4 "available" bit for OS use
   WORD Zerobit : 1;                   // 5 must be zero
   WORD DefOpSize : 1;                 // 6 operation size 0=16-bit 1=32-bit
   WORD Granularity  : 1;              // 7 segment granularity 0=byte 1=4K
};

typedef struct SEG_ATTR seg_attr;

/*--- these values appear in the Type field in System Segments               */

enum SYS_SEGTYPE {
   INVALID_0,                          // 0 = invalid
   TSS_AVAIL286,                       // 1 = 286 TSS, available
   LDT,                                // 2 = LDT segment descriptor
   TSS_BUSY286,                        // 3 = 286 TSS, busy
   CALL_GATE286,                       // 4 = 286 Call Gate
   TASK_GATE,                          // 5 = Task Gate
   INT_GATE286,                        // 6 = Interrupt Gate
   TRAP_GATE286,                       // 7 = 286 Trap Gate
   INVALID_8,                          // 8 = invalid
   TSS_AVAIL,                          // 9 = 386 TSS, available
   INVALID_A,                          // A = reserved
   TSS_BUSY,                           // B = 386 TSS, busy
   CALL_GATE,                          // C = 386 Call Gate
   INVALID_D,                          // D = reserved
   INT_GATE,                           // E = 386 Interrupt Gate
   TRAP_GATE                           // F = 386 Trap Gate
};

/*--- Segment Access Byte                                                    */

struct SEG_ACCESS {                    // for Code, Data, and Stack segments
   WORD Accessed : 1;                  // 0 0=unused 1=descriptor loaded
   WORD ReadWrite : 1;                 // 1 Code: 0=execute only, 1=readable
                                       //   Data: 0=read only, 1=writable
   WORD Conforming : 1;                // 2 Code: 0=nonconforming 1=conforming
                                       //   Stack: 0=expand up 1=exp down
   WORD Executable : 1;                // 3 0=data/stack 1=code
   WORD SegType : 1;                   // 4 0=system 1=code/data/stack
   WORD DPL : 2;                       // 5:6 descriptor privilege level
   WORD Present : 1;                   // 7 0=not in memory, 1=present
};

typedef struct SEG_ACCESS seg_access;

struct SYS_ACCESS {                    // for System segments
   WORD Type : 4;                      // 0:3 type of segment
   WORD SegType : 1;                   // 4 must be zero for system segment
   WORD DPL : 2;                       // 5:6 descriptor privilege level
   WORD Present : 1;                   // 7 0=not in memory, 1=present
};

typedef struct SYS_ACCESS sys_access;

/*---------------------------------------------------------------------------*/
/* Default Segment Descriptor structures                                     */

struct DESC_NORM {
   WORD SegLimit;                      // segment limit, bits 0:15
   WORD SegBaseLow;                    // segment base, bits 0:15
   BYTE SegBaseMid;                    //  ... bits 16:23
   seg_access Access;                  // access bits
   seg_attr Attributes;                // attribute bits & limit 16:19
   BYTE SegBaseHigh;                   // segment base 24:31
};

typedef struct DESC_NORM desc_norm;

struct DESC_SYS {
   WORD SegLimit;                      // segment limit, bits 0:15
   WORD SegBaseLow;                    // segment base, bits 0:15
   BYTE SegBaseMid;                    //  ... bits 16:23
   sys_access Access;                  // access bits
   seg_attr Attributes;                // attribute bits & limit 16:19
   BYTE SegBaseHigh;                   // segment base 24:31
};

typedef struct DESC_SYS desc_sys;

struct DESC_GATE {
   WORD OffsetLow;                     // routine offset address 0:15
   WORD CSSelector;                    // routine CS selector
   BYTE CopyCount;                     // stack entries to copy, 0..31
   sys_access Access;                  // access bits
   WORD OffsetHigh;                    // routine offset address 16:31
};

typedef struct DESC_GATE desc_gate;

/*---------------------------------------------------------------------------*/
/* Selector Register bit fields                                              */

struct SELECTOR {
   WORD RPL : 2;                       // Requestor Privilege Level
   WORD TI : 1;                        // Table Indicator 0=GDT 1=LDT
   WORD Index : 13;                    // Descriptor Index
};

typedef struct SELECTOR selector;

