; FFTS.INC
; Basic definitions for protected-mode operation

;--------------
; Segment descriptor bit fields

;--- Segment Attribute Bytes

              RECORD    SEG_ATTR {
              Granularity:1=0               ; seg granularity 0=byte 1=4K
              Opsize:1=1                    ; operation size 0=16-bit 1=32-bit
              Zerobit:1=0                   ; must be zero
              Available:1=0                 ; "available" bit for OS use
              SegLimitHigh:4                ; code/data seg: Limit high nybble
                                            ; sys seg: segment type
              }

; these values appear in the low nybble of the Segment Access Byte

              ENUM      SYS_SEGTYPE {
              INVALID_0                     ; 0 = invalid
              TSS_286_AVAIL                 ; 1 = 286 TSS, available
              LDT                           ; 2 = LDT segment descriptor
              TSS_BUSY_286                  ; 3 = 286 TSS, busy
              CALL_GATE286                  ; 4 = 286 Call Gate
              TASK_GATE                     ; 5 = Task Gate
              INT_GATE_286                  ; 6 = Interrupt Gate
              TRAP_GATE_286                 ; 7 = 286 Trap Gate
              INVALID_8                     ; 8 = invalid
              TSS_AVAIL                     ; 9 = 386 TSS, available
              INVALID_A                     ; A = reserved
              TSS_BUSY                      ; B = 386 TSS, busy
              CALL_GATE                     ; C = 386 Call Gate
              INVALID_D                     ; D = reserved
              INT_GATE                      ; E = 386 Interrupt Gate
              TRAP_GATE                     ; F = 386 Trap Gate
              }

;--- Segment Access Byte
;    the common part applies to all segments

              RECORD    SEG_ACC_COM {       ; common to all segments
              Present:1=1                   ; 0=not in memory, 1=mapped
              DPL:2=0                       ; descriptor privilege level
              SegType:1=1                   ; 0=system, 1=code/data/stack
              SAC_pad:4=0                   ; padding in low nybble
              }

              RECORD    SEG_ACC_CDS {       ; code, data, and stack segments
              Executable:1=0                ; 0=data 1=code
              Conforming:1=0                ; 0=nonconforming 1=conforming
              ReadWrite:1=1                 ; Code: 0=execute only, 1=readable
                                            ; Data: 0=read only, 1=writable
              Accessed:1=0                  ; 0=unused 1=descriptor loaded
              }

              RECORD    SEG_ACC_SYS {       ; system segments
              SegTypeID:4=0                 ; Seg Type ID, see above
              }

;--------------
; Default Segment Descriptor structures

              STRUC     DESC_NORM
SegLimit      DW        0                   ; segment limit, bits 0:15
SegBaseLow    DW        0                   ; segment base, bits 0:15
SegBaseMid    DB        0                   ;  ... bits 16:23
Access        DB        0                   ; access bits
Attributes    DB        0                   ; attribute bits & limit 16:19
SegBaseHigh   DB        0                   ; segment base 24:31
              ENDS      DESC_NORM

              STRUC     DESC_GATE
OffsetLow     DW        0                   ; routine offset address 0:15
CSSelector    DW        0                   ; routine CS selector
CopyCount     DB        0                   ; stack entries to copy, 0..31
Access        DB        0                   ; access bits
OffsetHigh    DW        0                   ; routine offset address 16:31
              ENDS      DESC_GATE

;--------------
; Selector Register bit fields

              RECORD    SELECTOR {
              Index:13                      ; Descriptor Index
              TI:1=1                        ; Table Indicator 0=GDT 1=LDT
              RPL:2=0                       ; Requestor Privilege Level
              }

;--------------
; Macros to open and close protected mode PROCs
; This handles all the statements we need to make it work...
;  you fill in any LOCALs, ARGs, or whatever immediately after the macro

              MACRO     PMProc ProcName,CSName
              IFB       <CSName>
              SEGMENT   _prottext
              ASSUME    CS:_prottext
              ELSE
              SEGMENT   CSName
              ASSUME    CS:CSName
              ENDIF
;;;;;         ASSUME    DS:_protdata,SS:_protstack
              ALIGN     4
              PUBLIC    ProcName
              PROC      ProcName
              ENDM

              MACRO     PMEndP ProcName
              ENDP      ProcName
              ENDS
              ENDM


;--------------
; Macros to synthesize far CALLs and JMPs for protected-mode routines
; The catch is that we need a =constant= segment selector...
;  the standard instruction formats expect a reference to a physical segment

              MACRO     PMCallFar Sel,Offs
              IF        NOT @32Bit
              DB        066h                ; force 32-bit operand size
              DB        067h                ; force 32-bit address size
              ENDIF
              DB        09Ah                ; CALL LARGE FAR (6-byte imm)
              DD        OFFSET Offs         ; 4-byte offset
              DW        Sel                 ; 2-byte selector
              ENDM


              MACRO     PMJmpFar Sel,Offs
              IF        NOT @32Bit
              DB        066h                ; force 32-bit operand size
              DB        067h                ; force 32-bit address size
              ENDIF
              DB        0EAh                ; JMP LARGE FAR (6-byte imm)
              DD        OFFSET Offs         ; 4-byte offset
              DW        Sel                 ; 2-byte selector
              ENDM

;--------------
; The obligatory delay after I/O operations
; This may not work well in cached 486 systems

              MACRO     Punt
              LOCAL     Next

              JMP       SHORT Next
Next:

              ENDM

