; FirmDev.INC
; Locations, sizes, and so forth for Firmware Development Board hardware

;-------------
; Fundamental addresses

BOARD_BASE    =         0300h               ; FDB base address

I8254_BASE    =         BOARD_BASE+0008h    ; timer base address
I8254_T0CLK   =         7190909             ; Timer 0 count rate

SYNC_ADDR     =         0378h               ; printer port for scope sync
SYNC_ADDR2    =         0278h               ; other printer port

;-------------
; Misc Control port output bits

CTLSDDR       =         BOARD_BASE+001Ch    ; control outputs

WATCHDOG      =         0100h               ; watchdog toggle output
NV_WENABLE    =         0200h               ; 1 = enable NV RAM writes
DS2400OUT     =         0400h               ; data to DS2400 serial number

LCD_E         =         1000h               ; char LCD E signal
LCD_RW        =         2000h               ;  ...     R/-W
LCD_RS        =         4000h               ;  ...     RS
LCD_NODRV     =         8000h               ;  ... 1 = disable data to LCD

;-------------
; Misc Status port inputs

STATDDR       =         BOARD_BASE+001Ch    ; status inputs

PWR_GOOD      =         0100h               ; 1 = power is OK
PUSHBUTTON    =         0200h               ; 0 = pushed
DS2400IN      =         0400h               ; data from DS2400 serial number

;-------------
; 2-digit LED display and switch inputs

LED_ADDR      =         BOARD_BASE+001Eh
SW_ADDR       =         BOARD_BASE+001Eh

;-------------
; Graphic LCD Interface

GLCD_SEGMENT  =         0D000h              ; segment address
GLCD_LENGTH   =         08000h              ; memory size

GLCD_CTLS     =         BOARD_BASE+001Ah

GLCD_ENCTR    =         0001h               ; enable addr counters
GLCD_DISMUX   =         0002h               ; 1 disabled output mux
GLCD_ENDISP   =         0004h               ; enable LCD if used
GLCD_DISBLINK =         0080h               ; 1 disables blinking

GLCD_BLSLOW   =         0050h               ; slowest blinking
GLCD_BLMED    =         0040h               ; moderate blinking
GLCD_BLFAST   =         0030h               ; fastest blinking
GLCD_BLZERO   =         0000h               ; output logic zero
GLCD_BLCLOCK  =         0060h               ; output LCD clock
GLCD_BLONE    =         0070h               ; output logic one

GLCD_OFF      =         GLCD_DISMUX OR GLCD_DISBLINK
GLCD_ON       =         GLCD_ENCTR OR GLCD_ENDISP

