/* Firmware Furnace #49 -- Ed Nisley                                         */
/* Copyright 1994 Computer Applications Journal                              */
/*                                                                           */
/* Second Step on the Journey into Protected Mode                            */
/* Compiled with Borland C++ 3.1, converted to binary with Paradigm's Locate */
/* Requires diskette boot sector loader to 1000:0000                         */
/*  ... and a comm program looking at COM1 with CTS & DSR held high          */

#include <dos.h>
#include <stdio.h>
#include <stdlib.h>

#include "..\386base.h"
#include "..\ffts.h"
#include "..\firmdev.h"

#include "h:\proj\firm386\paradigm\console.h"


/*---------------------------------------------------------------------------*/
/* Routines in the protected mode code module                                */

void far PMBadIntVector(void);                     // interrupt re-vectors
void PMEntry(WORD VectorA,WORD VectorB);           // BIOS PM transition

void far PMCodeBase(void);                         // 32-bit CS start
void far PMCodeLength(void);                       //  ... length

extern long far PMDataBase;                        // 32-bit DS start
extern long far PMDataLength;                      //  ... length

extern long far PMStackBase;                       // 32-bit SS start
extern long far PMStackLength;                     //  ... length

/*---------------------------------------------------------------------------*/
/* Default BIOS GDT selectors                                                */
/* The index field is in bits 3:15, so we need a left shift for alignment    */

#define GDT_NULL        (0 << 3)                   // NULL pointer
#define GDT_GDTALIAS    (1 << 3)                   // alias to access GDT
#define GDT_IDTALIAS    (2 << 3)                   // Interrupt Descriptors
#define GDT_DS          (3 << 3)                   // Data Segment
#define GDT_ES          (4 << 3)                   // Extra Segment
#define GDT_SS          (5 << 3)                   // Stack Segment
#define GDT_CS          (6 << 3)                   // Code Segment
#define GDT_BIOSCS      (7 << 3)                   // BIOS CS during setup
#define GDT_CS32        (8 << 3)                   // 32-bit code segment
#define GDT_DS32        (9 << 3)                   // 32-bit data segment
#define GDT_SS32        (10 << 3)                  // 32-bit stack segment

#define GDT_LENGTH      11                         // number of entries

/*---------------------------------------------------------------------------*/
/* Globals defined here                                                      */

desc_norm * pGDT;                      // pointer to Global Descriptor Table
desc_gate * pIDT;                      // pointer to Interrupt Descriptor Table

/*---------------------------------------------------------------------------*/
/* Convert a seg:off address into the corresponding linear address           */

LADDR MakeLinear(void far * fpVoid);

LADDR MakeLinear(void far * fpVoid) {

LADDR RetVal;

   return ((LADDR)FP_SEG(fpVoid) << 4) + (LADDR)FP_OFF(fpVoid);

}


/*---------------------------------------------------------------------------*/
/* Dump the contents of a descriptor                                         */

void DumpDescriptor(char *pString,desc_norm *pDesc);

void DumpDescriptor(char *pString,desc_norm *pDesc) {

   printf("%s %04X %04X %04X %04X\n",pString,
          *((WORD *)pDesc    ),*((WORD *)pDesc + 1),
          *((WORD *)pDesc + 2),*((WORD *)pDesc + 3));

}


/*---------------------------------------------------------------------------*/
/* Set a segment base address and limit into a descriptor                    */
/* A '386SX can use only 24 bits of base address, but we don't verify that   */
/* The segment size is one greater than the segment limit value              */
/* '286 addresses are limited to 24 bits, too...                             */
/*   and the limit must be less than 64K                                     */

void SetDescAddr(desc_norm *pDesc,LADDR SegBase,DWORD SegSize);

void SetDescAddr(desc_norm *pDesc,LADDR SegBase,DWORD SegSize) {

DWORD SegLimit;

   SegLimit = 0x000FFFFFL & (SegSize - 1L);        // convert length to limit

   pDesc->SegLimit                = (WORD)SegLimit;         // bits 0:15
   pDesc->Attributes.SegLimitHigh = (WORD)(SegLimit >> 16); // bits 16:19

   pDesc->SegBaseLow  = (WORD)SegBase;                      // bits 0:15
   pDesc->SegBaseMid  = (WORD)(BYTE)(SegBase >> 16);        // bits 16:23
   pDesc->SegBaseHigh = (WORD)(SegBase >> 24);              // bits 24:31

}

/*---------------------------------------------------------------------------*/
/* Create an Interrupt Descriptor Table for use in Protected Mode            */
/* For now, all entries are interrupt gates pointing to an error handler     */
/* 80286 call gates are restricted to 64 K segments & 16 bit offsets         */
/* We assume that the revector branches are spaced 8 bytes apart             */

#define IDT_LENGTH 256                 // number of entries in IDT

int BuildIDT(desc_gate ** ppIDT);

int BuildIDT(desc_gate ** ppIDT) {

desc_gate * pDesc;
int Index;
LADDR HandlerAddr;

   printf("Allocating IDT");

   *ppIDT = calloc(IDT_LENGTH,sizeof(desc_norm));

   if (NULL == *ppIDT) {
      puts("\nCannot allocate storage for IDT on near heap!");
      return 1;
   }

   HandlerAddr = FP_OFF(PMBadIntVector);
   printf(" at %Fp\n Re-vector table  %Fp\n",
          (void far *)*ppIDT,PMBadIntVector);

   pDesc = *ppIDT;
   for (Index=0; Index<IDT_LENGTH; ++Index) {
      pDesc->OffsetLow        = (WORD)HandlerAddr;
      pDesc->CSSelector       = GDT_CS;
      pDesc->Access.Present   = 1;
      pDesc->Access.Type      = INT_GATE286;
      ++pDesc;
      HandlerAddr += 8;
   }

   DumpDescriptor(" First IDT entry ",(desc_norm *)*ppIDT);

   return 0;

}


/*---------------------------------------------------------------------------*/
/* Create the BIOS-defined Global Descriptor Table                           */
/* Returns 0 if successful, 1 if a failure                                   */
/* GDT entries are defined in the table at the top of this code              */
/* The segments =must= match up with the real-mode segments...               */
/*  and must be 16-bit 80286 segments to allow the BIOS function to work     */

int BuildGDT(desc_norm ** ppGDT);

int BuildGDT(desc_norm ** ppGDT) {

desc_norm * pDesc;
int Index;
struct SREGS sregs;

/*--- allocate some storage                                                  */

   printf("Allocating GDT");

   *ppGDT = calloc(GDT_LENGTH,sizeof(desc_norm));

   if (NULL == *ppGDT) {
      printf("\nCannot allocate storage for GDT on near heap...\n");
      return 1;
   }

   printf(" at %Fp\n",(void far *)*ppGDT);

/*--- fill in the '286 mode entries                                          */

   segread(&sregs);                    // get current seg regs

   pDesc = *ppGDT;                     // aim at the GDT starting address

   ++pDesc;                            // step to the GDT alias
   pDesc->Access.SegType = 1;                      // code/data/stack
   pDesc->Access.Present = 1;                      // always present
   pDesc->Access.ReadWrite = 1;                    // must be writable
   SetDescAddr(pDesc,
               MakeLinear(*ppGDT),
               GDT_LENGTH * sizeof(desc_norm));


   ++pDesc;                            // step to the IDT alias
   pDesc->Access.SegType = 1;                      // code/data/stack
   pDesc->Access.Present = 1;                      // always present
   pDesc->Access.ReadWrite = 1;                    // must be writable
   SetDescAddr(pDesc,
               MakeLinear(pIDT),
               IDT_LENGTH * sizeof(desc_gate));

   ++pDesc;                            // step to the DS descriptor
   pDesc->Access.SegType = 1;                      // code/data/stack
   pDesc->Access.Present = 1;                      // always present
   pDesc->Access.ReadWrite = 1;                    // must be writable
   SetDescAddr(pDesc,
               ((LADDR)sregs.ds << 4) + (LADDR)(0L),
               (DWORD)(0x10000L));

   ++pDesc;                            // step to the ES descriptor
   pDesc->Access.SegType = 1;                      // code/data/stack
   pDesc->Access.Present = 1;                      // always present
   pDesc->Access.ReadWrite = 1;                    // must be writable
   SetDescAddr(pDesc,
               ((LADDR)sregs.es << 4) + (LADDR)(0L),
               (DWORD)(0x10000L));

   ++pDesc;                            // step to the SS descriptor
   pDesc->Access.SegType = 1;                      // code/data/stack
   pDesc->Access.Present = 1;                      // always present
   pDesc->Access.ReadWrite = 1;                    // must be writable
   SetDescAddr(pDesc,
               ((LADDR)sregs.ss << 4) + (LADDR)(0L),
               (DWORD)(0x10000L));

   ++pDesc;                            // step to the CS descriptor
   pDesc->Access.SegType = 1;                      // code/data/stack
   pDesc->Access.Present = 1;                      // always present
   pDesc->Access.Executable = 1;                   // code is executable
   pDesc->Access.ReadWrite = 1;                    //  ... and readable
   SetDescAddr(pDesc,
               ((LADDR)sregs.cs << 4) + (LADDR)(0L),
               (DWORD)(0x10000L));

   ++pDesc;                            // step over the BIOS CS entry

/*--- fill in the 32-bit segment entries                                     */

   ++pDesc;                            // step to 32-bit CS entry
   pDesc->Access.SegType = 1;                      // code/data/stack
   pDesc->Access.Present = 1;                      // always present
   pDesc->Access.Executable = 1;                   // code is executable
   pDesc->Access.ReadWrite = 1;                    //  ... and readable
   pDesc->Attributes.DefOpSize = 1;                // 32-bit ops
   SetDescAddr(pDesc,
               MakeLinear(PMCodeBase),
               (DWORD)&PMCodeLength);

   ++pDesc;                            // step to 32-bit DS entry
   pDesc->Access.SegType = 1;                      // code/data/stack
   pDesc->Access.Present = 1;                      // always present
   pDesc->Access.ReadWrite = 1;                    //  ... and readable
   pDesc->Attributes.DefOpSize = 1;                // this is ignored for data
   SetDescAddr(pDesc,
               MakeLinear(&PMDataBase),
               (DWORD)&PMDataLength);

   ++pDesc;                            // step to 32-bit SS entry
   pDesc->Access.SegType = 1;                      // code/data/stack
   pDesc->Access.Present = 1;                      // always present
   pDesc->Access.ReadWrite = 1;                    //  ... and readable
   pDesc->Attributes.DefOpSize = 1;                // 32-bit stack!
   SetDescAddr(pDesc,
               MakeLinear(&PMStackBase),
               (DWORD)&PMStackLength);

/*--- dump the descriptor table for eyeball verification                     */

   DumpDescriptor(" GDT NULL        ", *ppGDT   );
   DumpDescriptor(" GDT alias       ",(*ppGDT)+1);
   DumpDescriptor(" IDT alias       ",(*ppGDT)+2);
   DumpDescriptor(" DS              ",(*ppGDT)+3);
   DumpDescriptor(" ES              ",(*ppGDT)+4);
   DumpDescriptor(" SS              ",(*ppGDT)+5);
   DumpDescriptor(" CS              ",(*ppGDT)+6);
   DumpDescriptor(" BIOS CS         ",(*ppGDT)+7);

   DumpDescriptor(" 32-bit code     ",(*ppGDT)+8);
   DumpDescriptor("  ...   data     ",(*ppGDT)+9);
   DumpDescriptor("  ...  stack     ",(*ppGDT)+10);

   return 0;

}


/*---------------------------------------------------------------------------*/
/* The main event...                                                         */

void  main(void)
{
int Counter;
union REGS regs;
struct SREGS sregs;

   _putch(FORMFEED);
   puts("Firmware Furnace 49 -- Ed Nisley   "
        "(c)1994 Computer Applications Journal");
   puts("Journey to the Protected Land... Step 2\n");

/*--- display the linked pointers and values for manual verification         */

   puts("Linked pointers and values from the PM segments...");

   printf(" PM Code  %Fp = %08lX, length %08lX (",
          PMCodeBase,MakeLinear(PMCodeBase),
          (long)PMCodeLength);
   for (Counter=0; Counter<8; ++Counter) {
      printf("%02X ",*((BYTE far *)PMCodeBase + Counter));
   }
   puts(")");

   printf(" PM Data  %Fp = %08lX, length %08lX (%08lX %08lX)\n",
          &PMDataBase,MakeLinear(&PMDataBase),
          &PMDataLength,PMDataBase,*(&PMDataBase+1));

   printf(" PM Stack %Fp = %08lX, length %08lX (%08lX)\n",
          &PMStackBase,MakeLinear(&PMStackBase),
          &PMStackLength,PMStackBase);

/*--- create the descriptor tables needed for the BIOS function              */

   BuildIDT(&pIDT);
   BuildGDT(&pGDT);

/*--- execute the BIOS jump into protected mode                              */
/*    this does not return even if the transition fails                      */

   PMEntry(I8259A_VECTOR_PM,I8259B_VECTOR_PM);

}
