; ProtMode.ASM

;--------------
; Useful externals

              EXTRN     C pGDT:WORD

;--------------
; Set up assembly conditions and pull in useful definitions

              IDEAL                         ; use Borland Ideal syntax
              P386                          ; enable protected mode code
              LOCALS

              INCLUDE   "..\ffts.inc"
              INCLUDE   "..\firmdev.inc"

;------------------------
; Define GDT entries

GDT_CODE32    =         (8 SHL 3)           ; 32-bit code segment
GDT_DATA32    =         (9 SHL 3)           ;  ... data
GDT_STACK32   =         (10 SHL 3)          ;  ... stack

;------------------------
; Make the transition to protected mode
; This starts in real mode and ends up in 16-bit protected mode
;  GDT and IDT must be built by the caller... to match BIOS requirements!

              MODEL     SMALL,C             ; 16-bit C language calls

              CODESEG

              PROC      PMEntry
              ARG       VectorA:WORD,VectorB:WORD
              PUBLIC    PMEntry

              MOV       AL,001h             ; flag entry here
              MOV       DX,SYNC_ADDR
              OUT       DX,AL

              MOV       AX,NOT 0101h        ; preset the LED to dashes (--)
              MOV       DX,LED_ADDR
              OUT       DX,AX

;--- wait for diskette motor to stop spinning

              MOV       AX,0040h            ; aim at motor status
              MOV       ES,AX
              MOV       SI,003Fh            ;  at 0040:003F

@@Motors:
              MOV       AL,[ES:SI]
              TEST      AL,03h              ; drives A & B
              JNZ       @@Motors

;--- set up the registers for the BIOS function
;    this happens in plain old real mode

              MOV       AX,DS               ; set ES:SI to GDT base address
              MOV       ES,AX
              MOV       SI,[pGDT]
              MOV       BH,[BYTE PTR VectorA]         ; IRQ 0:7
              MOV       BL,[BYTE PTR VectorB]         ; IRQ 8:15

              MOV       AL,003h             ; mark start of BIOS function
              OUT       DX,AL

              MOV       AH,89h              ; BIOS function
              INT       15h                 ; make the transition

;--- protected mode?
;    if the GDT or any registers are invalid, we'll get a protection fault

              MOV       AL,080h             ; mark just after the function
              MOV       DX,SYNC_ADDR
              OUT       DX,AL

              JNC       SHORT @@PM          ; if we survive, C clear = OK

;--- still in real mode, so flag the failure

              XOR       CX,CX
              MOV       DX,SYNC_ADDR
@@Fail:
              IN        AL,DX               ; by blinking the whole port
              NOT       AL
              OUT       DX,AL

              MOV       BL,5
@@Fail1:      LOOP      @@Fail1             ; delay for a while
              DEC       BL
              JNZ       @@Fail1

              JMP       @@Fail

;--- definitely in protected mode!
;    this is running in a 16-bit 80286 code segment

@@PM:
              MOV       DX,LED_ADDR         ; show P2 for '286 protected mode
              MOV       AX,NOT 676Dh
              OUT       DX,AX

              MOV       DX,SYNC_ADDR        ; turn on parallel port bit 6
              IN        AL,DX
              XOR       AL,40h
              OUT       DX,AL

;--- do a jump into the 32-bit segment

              PMJmpFar  GDT_CODE32,PMEntry32

              ENDP      PMEntry


;------------------------
; Bad interrupt revectoring entry points
; Each IDT entry selects one of these vectors so we know how we got here
; They're padded to eight bytes

              CODESEG

              PROC      PMBadIntVector
              PUBLIC    PMBadIntVector

              NOWARN    ICG

@@ID          =         0
              REPT      256
              PUSH      LOW @@ID
              JMP       PMBadIntHandler
              NOP
              NOP
              NOP
@@ID          =         @@ID + 1
              ENDM

              WARN      ICG

              ENDP      PMBadIntVector

;------------------------
; Bad interrupt handler
; Some IDT entries must be task gates, but we ignore that for now...
;  all IDT entries are interrupt gates to ensure interrupts are disabled
; The response here is to show the interrupt ID and blink the decimals
;  we come from the revectoring jumps, so the DWORD on the stack is the ID

              CODESEG

              PROC      PMBadIntHandler
              PUBLIC    PMBadIntHandler

              POP       AX                  ; recover the interrupt ID
              NOT       AX                  ; flip it to make it readable
              MOV       DX,LED_ADDR         ; set up for the display

              XOR       CX,CX               ; set up initial count

@@Stall:
              OUT       DX,AX               ; display new data
              XOR       AX,08000h           ; flip the high decimal point
              MOV       BL,5
@@Punt:       LOOP      @@Punt              ; delay for a decent interval
              DEC       BL
              JNZ       @@Punt
              JMP       @@Stall

              ENDP      PMBadIntHandler

;------------------------
; From here on down we're in 32-bit mode...
; Define the Protected Mode segments
;  The linker can combine them with 16-bit segments just fine, oddly enough

              MODEL     USE32 FARSTACK SMALL,C

;--- code segment

              SEGMENT   _prottext PARA PUBLIC USE32 'CODE'

              LABEL     PMCodeBase PROC
              PUBLIC    PMCodeBase

              ENDS      _prottext

;--- data segment

              SEGMENT   _protdata PARA PUBLIC USE32 'DATA'

              LABEL     PMDataBase DWORD
              PUBLIC    PMDataBase
              DD        0babefaceh          ; flag the first location

              ENDS      _protdata

;--- stack segment

              SEGMENT   _protstack PARA PUBLIC USE32 'STACK'

              LABEL     PMStackBase DWORD
              PUBLIC    PMStackBase
              DD        1023 DUP (?)
              LABEL     PMStackTop
              DD        ?                   ; this is the stack top!

PMStackLength =         $-PMStackBase
              PUBLIC    PMStackLength

              ENDS      _protstack



;------------------------
; Entry point for 32-bit operations
; We must set up 32-bit data and stack segments, too
;  ... output a trace display step by step to catch protection errors
; On entry we do =not= have DS and SS set up correctly
;  ... so we can't use the PMProc macro to set up this procedure

              SEGMENT   _prottext

              PUBLIC    PMEntry32
              PROC      PMEntry32

              ASSUME    CS:_prottext

              MOV       EDX,SYNC_ADDR       ; show entry here
              IN        AL,DX
              OR        AL,20h
              OUT       DX,AL

              MOV       EAX,GDT_DATA32      ; set up data segment
              MOV       DS,AX

              MOV       EDX,LED_ADDR
              MOV       EAX,NOT 6779h       ; show P3 for '386 32-bit mode
              OUT       DX,AX

              MOV       EAX,GDT_STACK32     ; set up stack segment
              MOV       SS,AX
              MOV       ESP,OFFSET PMStackTop

              ASSUME    DS:_protdata
              ASSUME    SS:_protstack

;--- blink some LEDs to show success...
;    the CALL demonstrates that the stack is OK
;    the data in the function shows that DS is set correctly
;    check the switches to force a protection error if desired!

              MOV       [LoopCtr],0         ; clear the iteration counter

@@Stall:
              MOV       EDX,SYNC_ADDR       ; flip a parallel port LED
              IN        AL,DX
              XOR       AL,10h
              OUT       DX,AL

              MOV       EBX,80800000h       ; twiddle decimal points
              MOVZX     EAX,[BYTE PTR LoopCtr]        ; fetch low byte only
              TEST      AL,01h              ; alternate on each count
              JNZ       SHORT @@DotsOn
              XOR       EBX,EBX             ; points are off
@@DotsOn:
              OR        EAX,EBX             ; combine points and count
              CALL      PMByteToLEDs,EAX
              INC       [LoopCtr]

              MOV       ECX,2660000         ; roughly one second
@@Wait:       LOOP      @@Wait

              MOV       EDX,SW_ADDR         ; check switches to blow up
              IN        AX,DX
              NOT       AX                  ;  ... ON = 1
              MOV       ES,AX               ; GP fault = 13 decimal = 0D hex
                                            ;  if AX is not valid selector

              JMP       @@Stall

              PMEndP    PMEntry32

;--- define the counter and mark the initial value for real-mode display

              SEGMENT   _protdata

LoopCtr       DD        12345678h           ; mark the initial value

              ENDS      _protdata



;------------------------
; Convert byte to 7-segment display and write to the port
; The decimal points are controlled by bits 31 and 23 (high bits of high bytes)

              PMProc    PMByteToLEDs
              ARG       Value:DWORD
              USES      EAX,EBX,EDX

              LEA       EBX,[LEDSegs]       ; aim at table

              MOV       EAX,[Value]         ; fetch the byte
              AND       EAX,0Fh
              XLAT      [DS:EBX]
              MOV       DL,AL               ; save 'em

              MOV       EAX,[Value]         ; fetch byte again
              SHR       AL,4                ;  ... align high nybble
              XLAT      [DS:EBX]

              MOV       AH,DL               ; fetch low dots
              XCHG      AH,AL               ; rearrange

              MOV       EBX,[Value]         ; pick up the dot controls
              SHR       EBX,16
              AND       EBX,08080h
              OR        EAX,EBX             ; combine dots with segments

              NOT       EAX                 ; make '1' bits light the LEDs

              MOV       EDX,LED_ADDR        ; aim at display
              OUT       DX,AX               ; show the value

              RET

              PMEndP    PMByteToLEDs

;--- define the XLAT lookup table for segment data

              SEGMENT   _protdata

              LABEL     LEDSegs BYTE
              DB        07Eh,030h,06Dh,079h,033h,05Bh,05Fh,070h
              DB        07Fh,07Bh,077h,01Fh,04Eh,03Dh,04Fh,047h

              ENDS      _protdata


;------------------------
; Flag the end of the protected mode segments

;--- code segment

              SEGMENT   _prottext

PMCodeLength  =         $-PMCodeBase
              PUBLIC    PMCodeLength

              ENDS      _prottext

;--- data segment


              SEGMENT   _protdata

PMDataLength  =         $-PMDataBase
              PUBLIC    PMDataLength

              ENDS      _protdata
              END
