;-------------------------------------------------------------------------------
;                  Sinus Flag Tester
;-------------------------------------------------------------------------------
;              Copyright (C) 1994 The Corporation
;-------------------------------------------------------------------------------
;                        code: Gor
;-------------------------------------------------------------------------------
; email me at : gearyp@cs.man.ac.uk

BORDERS=1	                         ;set to 1 for visible border-timings

code 	SEGMENT para public 'CODE'
	ASSUME cs:code
	LOCALS
	.386

ORG	100h
start:
	jmp	main

; setborder 
;descr: debug/change border color
setborder MACRO col
	IF BORDERS
	push	ax
	push	dx
	mov	dx,3dah                  ;STATUS REGISTER-ONE
	in	al,dx                    ;set attribute reg. to address mode
	mov	dx,3c0h                  ;ATTRIBUTE CONTROL REGISTER
	mov	al,11h+32
	out	dx,al                    ;get Overscan colour register
	mov	al,col                   ;get col
	out	dx,al                    ;use col as border retrace colour
	pop	dx
	pop	ax
	ENDIF
	ENDM

; Intro Routines 

; timer 
inittimer PROC NEAR
	mov	eax,fs:[8*4]                    ;get old timer address
	mov	ds:oldint8,eax                  ;store it
	mov	ax,cs
	shl	eax,16
	mov	ax,OFFSET intti8                ;get my interrupt routine
	mov	dx,17000 ;70hz
	jmp	@@1
deinittimer:
	mov	eax,ds:oldint8                  ;get old interrupt
	xor	dx,dx
@@1:	cli                                     ;clear interrupts
	mov	fs:[8*4],eax                    ;patch in my interrupt
	mov	al,036h
	out	43h,al
	mov	al,dl
	out	40h,al
	mov	al,dh
	out	40h,al
	sti
	ret
inittimer ENDP

intti8	PROC FAR ;timer interrupt
	push	ax
	mov	al,20h
	out	20h,al
	inc	cs:framecounter
	pop	ax
	iret
intti8	ENDP

; load indexed palette 
setpal	PROC NEAR
	;ds:si=pointer to colorindices
	mov	dx,3c8h                         ;PEL address write mode
	xor	al,al                           ;clear al
	out	dx,al                           ;select data register zero
	inc	dx                              ;next data register
	mov	cx,8                            ;
@@1:	xor	bh,bh
	mov	bl,ds:[si]
	shr	bl,2
	call	setpl2                          ;write cols
	mov	bl,ds:[si]
	shl	bx,2
	call	setpl2                          ;write cols
	inc	si
	loop	@@1
	ret

setpl2:	and	bx,15*2                         ;limit offset
	mov	ax,word ptr ds:col0[bx]         ;get colour 1+2
	out	dx,al                           ;write col RED
	mov	al,ah                           ;get high-byte
	out	dx,al                           ;write col GREEN
	mov	al,ds:col0[bx+2]                ;get colour 3
	out	dx,al                           ;write col BLUE
	ret
setpal	ENDP

; clear & copy videobuffer to screen 
clearcopy PROC NEAR

	xor	edx,edx                         ;clear reg
	mov	si,OFFSET vbuf                  ;get vbuffer
	mov	bx,4                            ;4 bytes at a time!
	mov	cx,200                          ;loop counter
	mov	di,-4                           ;vram row-offest
@@1:	mov	bp,5
@@2:	REPT	2
	mov	eax,ds:[si]                     ;get 4 bytes from vbuffer
	add	di,bx
	mov	ds:[si],edx                     ;clear 4 bytes of vbuffer
	add	si,bx                           ;next 4 bytes to read
	mov	es:[di],eax                     ;copy buffer to vram
	ENDM                                    ;moved 8 bytes so far...
	dec	bp
	jnz	@@2                             ;move 40 bytes (1 scan line!)
	add	si,bx                           ;next scan-line
	dec	cx
	jnz	@@1                             ;all 200 scan-lines to copy...
	ret
clearcopy ENDP

; advance demo one frame (raw work) 

doit	PROC NEAR

;====== WAIT FOR VSYNC =========================================================

	setborder 0
	mov	dx,3dah                         ;get STATUS REGISTER ONE
@@w1:	in	al,dx
	test	al,8                            ;is screen in vertical retrace ?
	jnz	@@w1                            ;wait for non-retrace
@@w2:	in	al,dx
	test	al,8                            ;is screen at start of retrace ?
	jz	@@w2                            ;wait for beginning of retrace
	setborder 30

; NOTE: Why are there two wait loops ?
; The retrace status indicates only that the vertical retrace is in progress;
; it may be almost finished when you first check. To get around this you need
; to first wait for a display interval and then wait for the vertical retrace.


;====== SET NEW PALETTE ========================================================

	mov	si,ds:index                     ;get palette pointer
	push	si
	call	setpal                          ;set new palette
	pop	si
	add	si,9                            ;next palette
	cmp	si,OFFSET index4                ;check for end of palette list
	jbe	@@i2                            ;if less, no change
	mov	si,OFFSET index1                ;otherwise, reset pointer

;====== SET BITPLANE TO USE ====================================================

@@i2:	mov	ds:index,si                     ;and store
	mov	al,2                            ;index number of the Map Mask Register
	mov	ah,ds:[si+8]                    ;get bitplane to write in vblank
	mov	dx,3c4h                         ;SEQUENCER ADDRESS REGISTER
	out	dx,ax                           ;select bitplane to modify
	call	clearcopy                       ;copy buffer to vram

; NOTE: The Sequencer Address Register selects which register will appear at
; port 3c5h. The index number of the desired register is written to port 3c5h.

; The Map Mask Register enables or disables the specified bit planes during
; a memory write. Each bit set will allow that plane to be modified;, e.g.,
; setting bits 1 and 3 allows cpu to write data to bit planes 1 and 3.

; When using odd/even modes, bits 0 and 1, and 2 and 3 should have the same
; value. When using Chain 4 mode, all four maps should be set the same.

; This register affects all write modes; i.e., all data written to adapter
; memory.

; Bits:         0 = bitplane 0
;               1 = bitplane 1
;               2 = bitplane 2
;               3 = bitplane 3
;               4-7 not used

;====== DO TIMER STUFF =========================================================

	setborder 26                            ;is running correct
@@78:
        add     SinX,12                         ;increment sine-x
        sub     SinY,20                         ;increment sine-y
        and     SinX,2047                       ;limit to data-size
        and     SinY,2047                       ;limit to data-size
        mov     ax,SinX                         ;get sine-x
        mov     bx,SinY                         ;get sine-y
        mov     cx,216                          ;x-axis start-pos
        mov     dx,180                          ;y-axis start-pos
NxtPnt:
        push    cx                              ;store current x/y pos.
        push    dx

        add     cx,52
        add     dx,35
        and     ax,2047                         ;limit sine-offset-x
        and     bx,2047                         ;limit sine-offset-y

        mov     si,ax
        add     cx,ds:Sine[si]                  ;add x-axis offset
        add     dx,ds:Sine[bx]                  ;add y-axis offset

        mov     si,cx
        mov     di,dx

        cmp     si,319
        ja      Nxt
        cmp     di,199
        ja      Nxt

        add     si,si                           ;x2
        add     di,di                           ;x2

        mov     dx,ds:rows[di]
        add     dx,ds:cols[si]
        mov     di,dx

        push    ax
        mov     al,ds:colb[si]                  ;get pixel from table
        or      ds:[di],al                      ;plot pixel
        pop     ax
Nxt:
        add     ax,20
        add     bx,32

        pop     dx                              ;get current x/y pos.
        pop     cx

        sub     cx,8                            ;next pos (27 pixels)
        jnz     NxtPnt                          ;plot 1 line of pixels
        mov     cx,216                          ;reset x-axis
        sub     ax,500                          ;modify sine-offset-x
        sub     bx,1050                         ;modify sine-offset-y
        sub     dx,6                            ;next row of pixels (
        jnz     NxtPnt
	ret

doit	ENDP


; Main routine 
;stack @ cs:0fffeh

main	PROC NEAR
; Init Segs 
.8086
	push	cs
	push	cs
	pop	ds
	pop	es
	xor	ax,ax                           ;zero used later
	mov	dx,0a000h                       ;vram address
	mov	es,dx                           ;es now points to vram
;segments now set: DS=code/data ES=vram
; Check for 386 
	push	sp                              ;test order of write/decrement
	pop	dx                              ;by PUSH SP
	cmp	dx,sp                           ;if dx=sp, cpu not 80186/80188
	jz	@@o1
@@o2:	jmp	endansi                         ;80(1)86 found so exit
.286p
@@o1:	mov	bx,OFFSET rows
	sgdt	ds:[bx]
	cmp	byte ptr ds:[bx+5],0
	js	@@o2                            ;80(2)86 found so exit
; Check for VGA 
.386p
	mov	fs,ax                           ;ax was zero, fs=zeropage

;segments now set: DS=code/data ES=vram FS=zeropage

	mov	ax,1a00h                        ;Function:
	int	10h                             ;READ DISPLAY COMBINATION
	cmp	al,01ah                         ;1ah indicates vga connected
	jne	endansi                         ;otherwise - forget it..
	cmp	bl,7                            ;check 2nd display for vga
	jb	endansi                         ;any less and it's not

; Initialize - vga 

	mov	ax,0dh                          ;Function: vga 16 col 320x200
	int	10h                             ;SET VIDEO STATE

	;set up rows/cols/etc

	mov	si,-2                           ;buffer-offset
	mov	di,OFFSET vbuf-44               ;vram buffer-pointer
	mov	bl,128
	xor	bp,bp                           ;reset columns-offset
	jmp	@@b4
@@b1:	mov	ds:rows[si],di                  ;store row-offset
	mov	ds:colb[si],bl                  ;store pixel-gfx
	mov	ds:cols[si],bp                  ;store columns-offset
	ror	bl,1                            ;rotate pixel right
	jnc	@@b4                            ;shift 8 times
	inc	bp                              ;next column
@@b4:	add	di,44                           ;next row-offset
	add	si,2                            ;next pos in buffer
	cmp	si,(320)*2                      ;check for last column
	jle	@@b1                            ;jump if less-than..

	;set simplex palette order (16 color mode)

	mov	dx,3dah
	in	al,dx
	mov	dl,0c0h
	xor	ax,ax
	mov	cx,16
@@b2:	out	dx,al
	out	dx,al
	inc	al
	loop	@@b2
	mov	al,20h
	out	dx,al
; Initialize - others 
	call	inittimer
; Do the intro stuff 
again:	call	doit                            ;run main routines
	mov	ah,1
	int	16h                             ;read keystroke buffer
	jz	again                           ;if nothing there, keep looping
	mov	ah,0
	int	16h
; DeInitialize 
	call	deinittimer
; Display end ansi (only thing done if no 386 or vga) 
endansi:mov	ax,3h
	int	10h
	mov	si,OFFSET endtext
	push	0b800h	                        ;if the user has an MGA or HGC
	pop	es	                        ;it's not my problem :-)
	xor	di,di
	mov	ah,0eh
@@1:	lodsb
	IFDEF XORTEXTS
	xor	al,17h
	ENDIF
	cmp	al,31
	jae	@@2
	mov	ah,al
	jmp	@@1
@@2:	jz	@@3
	stosw
	jmp	@@1
@@3:	mov	ax,4c00h
	int	21h
main	ENDP

; Initialized (nonzero) data 

udforced LABEL DWORD

col0	db	 0, 0, 0 ,0	;background color
col1	db	 5,5,5 ,0	;delay color 3
col2	db	10,10,10 ,0	;delay color 2
col3	db	30,30,30 ,0	;delay color 1
col4	db	60,60,60 	;brightest color
	;1	. x . x . x . x . x . x . x . x
	;2	. . x x . . x x . . x x . . x x
	;4	. . . . x x x x . . . . x x x x
	;8	. . . . . . . . x x x x x x x x
;palette indices for 4 palettes. Last number is bitplane to write
;during the frame having this palette
index1	db	04h,34h,24h,34h,14h,34h,24h,34h	,1 ;1248
index2	db	03h,23h,13h,23h,44h,44h,44h,44h	,8 ;8124
index3	db	02h,12h,44h,44h,33h,33h,44h,44h	,4 ;4812
index4	db	01h,44h,33h,44h,22h,44h,33h,44h	,2 ;2481
index	dw	OFFSET index1                      ;offset to current index

;#########################################################
SinX    dw      0
SinY    dw      0
Sine	dw	00h,00h,00h,01h,01h
	dw	01h,01h,01h,02h,02h
	dw	02h,02h,02h,03h,03h
	dw	03h,03h,03h,04h,04h
	dw	04h,04h,04h,05h,05h
	dw	05h,05h,05h,05h,06h
	dw	06h,06h,06h,06h,07h
	dw	07h,07h,07h,07h,08h
	dw	08h,08h,08h,08h,09h
	dw	09h,09h,09h,09h,09h
	dw	0Ah,0Ah,0Ah,0Ah,0Ah
	dw	0Bh,0Bh,0Bh,0Bh,0Bh
	dw	0Ch,0Ch,0Ch,0Ch,0Ch
	dw	0Ch,0Dh,0Dh,0Dh,0Dh
	dw	0Dh,0Eh,0Eh,0Eh,0Eh
	dw	0Eh,0Eh,0Fh,0Fh,0Fh
	dw	0Fh,0Fh,0Fh,10h,10h
	dw	10h,10h,10h,10h,11h
	dw	11h,11h,11h,11h,11h
	dw	12h,12h,12h,12h,12h
	dw	12h,13h,13h,13h,13h
	dw	13h,13h,14h,14h,14h
	dw	14h,14h,14h,14h,15h
	dw	15h,15h,15h,15h,15h
	dw	15h,16h,16h,16h,16h
	dw	16h,16h,16h,17h,17h
	dw	17h,17h,17h,17h,17h
	dw	18h,18h,18h,18h,18h
	dw	18h,18h,18h,19h,19h
	dw	19h,19h,19h,19h,19h
	dw	19h,1Ah,1Ah,1Ah,1Ah
	dw	1Ah,1Ah,1Ah,1Ah,1Ah
	dw	1Bh,1Bh,1Bh,1Bh,1Bh
	dw	1Bh,1Bh,1Bh,1Bh,1Ch
	dw	1Ch,1Ch,1Ch,1Ch,1Ch
	dw	1Ch,1Ch,1Ch,1Ch,1Ch
	dw	1Dh,1Dh,1Dh,1Dh,1Dh
	dw	1Dh,1Dh,1Dh,1Dh,1Dh
	dw	1Dh,1Dh,1Eh,1Eh,1Eh
	dw	1Eh,1Eh,1Eh,1Eh,1Eh
	dw	1Eh,1Eh,1Eh,1Eh,1Eh
	dw	1Eh,1Fh,1Fh,1Fh,1Fh
	dw	1Fh,1Fh,1Fh,1Fh,1Fh
	dw	1Fh,1Fh,1Fh,1Fh,1Fh
	dw	1Fh,1Fh,1Fh,1Fh,1Fh
	dw	1Fh,1Fh,1Fh,20h,20h
	dw	20h,20h,20h,20h,20h
	dw	20h,20h,20h,20h,20h
	dw	20h,20h,20h,20h,20h
	dw	20h,20h,20h,20h,20h
	dw	20h,20h,20h,20h,20h
	dw	20h,20h,20h,20h,20h
	dw	20h,20h,20h,20h,20h
	dw	20h,20h,20h,20h,20h
	dw	20h,20h,20h,20h,20h
	dw	20h,20h,20h,20h,20h
	dw	20h,20h,20h,20h,20h
	dw	1Fh,1Fh,1Fh,1Fh,1Fh
	dw	1Fh,1Fh,1Fh,1Fh,1Fh
	dw	1Fh,1Fh,1Fh,1Fh,1Fh
	dw	1Fh,1Fh,1Fh,1Fh,1Fh
	dw	1Fh,1Fh,1Eh,1Eh,1Eh
	dw	1Eh,1Eh,1Eh,1Eh,1Eh
	dw	1Eh,1Eh,1Eh,1Eh,1Eh
	dw	1Eh,1Dh,1Dh,1Dh,1Dh
	dw	1Dh,1Dh,1Dh,1Dh,1Dh
	dw	1Dh,1Dh,1Dh,1Ch,1Ch
	dw	1Ch,1Ch,1Ch,1Ch,1Ch
	dw	1Ch,1Ch,1Ch,1Ch,1Bh
	dw	1Bh,1Bh,1Bh,1Bh,1Bh
	dw	1Bh,1Bh,1Bh,1Ah,1Ah
	dw	1Ah,1Ah,1Ah,1Ah,1Ah
	dw	1Ah,1Ah,19h,19h,19h
	dw	19h,19h,19h,19h,19h
	dw	18h,18h,18h,18h,18h
	dw	18h,18h,18h,17h,17h
	dw	17h,17h,17h,17h,17h
	dw	16h,16h,16h,16h,16h
	dw	16h,16h,15h,15h,15h
	dw	15h,15h,15h,15h,14h
	dw	14h,14h,14h,14h,14h
	dw	14h,13h,13h,13h,13h
	dw	13h,13h,12h,12h,12h
	dw	12h,12h,12h,11h,11h
	dw	11h,11h,11h,11h,10h
	dw	10h,10h,10h,10h,10h
	dw	0Fh,0Fh,0Fh,0Fh,0Fh
	dw	0Fh,0Eh,0Eh,0Eh,0Eh
	dw	0Eh,0Eh,0Dh,0Dh,0Dh
	dw	0Dh,0Dh,0Ch,0Ch,0Ch
	dw	0Ch,0Ch,0Ch,0Bh,0Bh
	dw	0Bh,0Bh,0Bh,0Ah,0Ah
	dw	0Ah,0Ah,0Ah,09h,09h
	dw	09h,09h,09h,09h,08h
	dw	08h,08h,08h,08h,07h
	dw	07h,07h,07h,07h,06h
	dw	06h,06h,06h,06h,05h
	dw	05h,05h,05h,05h,05h
	dw	04h,04h,04h,04h,04h
	dw	03h,03h,03h,03h,03h
	dw	02h,02h,02h,02h,02h
	dw	01h,01h,01h,01h,01h
	dw	00h,00h,00h,00h,00h
	dw	00h,00h,00h,0FFFFh,0FFFFh
	dw	0FFFFh,0FFFFh,0FFFFh,0FFFEh,0FFFEh
	dw	0FFFEh,0FFFEh,0FFFEh,0FFFDh,0FFFDh
	dw	0FFFDh,0FFFDh,0FFFDh,0FFFCh,0FFFCh
	dw	0FFFCh,0FFFCh,0FFFCh,0FFFBh,0FFFBh
	dw	0FFFBh,0FFFBh,0FFFBh,0FFFAh,0FFFAh
	dw	0FFFAh,0FFFAh,0FFFAh,0FFF9h,0FFF9h
	dw	0FFF9h,0FFF9h,0FFF9h,0FFF9h,0FFF8h
	dw	0FFF8h,0FFF8h,0FFF8h,0FFF8h,0FFF7h
	dw	0FFF7h,0FFF7h,0FFF7h,0FFF7h,0FFF6h
	dw	0FFF6h,0FFF6h,0FFF6h,0FFF6h,0FFF6h
	dw	0FFF5h,0FFF5h,0FFF5h,0FFF5h,0FFF5h
	dw	0FFF4h,0FFF4h,0FFF4h,0FFF4h,0FFF4h
	dw	0FFF4h,0FFF3h,0FFF3h,0FFF3h,0FFF3h
	dw	0FFF3h,0FFF2h,0FFF2h,0FFF2h,0FFF2h
	dw	0FFF2h,0FFF2h,0FFF1h,0FFF1h,0FFF1h
	dw	0FFF1h,0FFF1h,0FFF1h,0FFF0h,0FFF0h
	dw	0FFF0h,0FFF0h,0FFF0h,0FFF0h,0FFEFh
	dw	0FFEFh,0FFEFh,0FFEFh,0FFEFh,0FFEFh
	dw	0FFEEh,0FFEEh,0FFEEh,0FFEEh,0FFEEh
	dw	0FFEEh,0FFEDh,0FFEDh,0FFEDh,0FFEDh
	dw	0FFEDh,0FFEDh,0FFEDh,0FFECh,0FFECh
	dw	0FFECh,0FFECh,0FFECh,0FFECh,0FFEBh
	dw	0FFEBh,0FFEBh,0FFEBh,0FFEBh,0FFEBh
	dw	0FFEBh,0FFEAh,0FFEAh,0FFEAh,0FFEAh
	dw	0FFEAh,0FFEAh,0FFEAh,0FFE9h,0FFE9h
	dw	0FFE9h,0FFE9h,0FFE9h,0FFE9h,0FFE9h
	dw	0FFE9h,0FFE8h,0FFE8h,0FFE8h,0FFE8h
	dw	0FFE8h,0FFE8h,0FFE8h,0FFE8h,0FFE7h
	dw	0FFE7h,0FFE7h,0FFE7h,0FFE7h,0FFE7h
	dw	0FFE7h,0FFE7h,0FFE6h,0FFE6h,0FFE6h
	dw	0FFE6h,0FFE6h,0FFE6h,0FFE6h,0FFE6h
	dw	0FFE6h,0FFE5h,0FFE5h,0FFE5h,0FFE5h
	dw	0FFE5h,0FFE5h,0FFE5h,0FFE5h,0FFE5h
	dw	0FFE5h,0FFE4h,0FFE4h,0FFE4h,0FFE4h
	dw	0FFE4h,0FFE4h,0FFE4h,0FFE4h,0FFE4h
	dw	0FFE4h,0FFE4h,0FFE3h,0FFE3h,0FFE3h
	dw	0FFE3h,0FFE3h,0FFE3h,0FFE3h,0FFE3h
	dw	0FFE3h,0FFE3h,0FFE3h,0FFE3h,0FFE3h
	dw	0FFE3h,0FFE2h,0FFE2h,0FFE2h,0FFE2h
	dw	0FFE2h,0FFE2h,0FFE2h,0FFE2h,0FFE2h
	dw	0FFE2h,0FFE2h,0FFE2h,0FFE2h,0FFE2h
	dw	0FFE2h,0FFE2h,0FFE2h,0FFE1h,0FFE1h
	dw	0FFE1h,0FFE1h,0FFE1h,0FFE1h,0FFE1h
	dw	0FFE1h,0FFE1h,0FFE1h,0FFE1h,0FFE1h
	dw	0FFE1h,0FFE1h,0FFE1h,0FFE1h,0FFE1h
	dw	0FFE1h,0FFE1h,0FFE1h,0FFE1h,0FFE1h
	dw	0FFE1h,0FFE1h,0FFE1h,0FFE1h,0FFE1h
	dw	0FFE1h,0FFE1h,0FFE1h,0FFE1h,0FFE1h
	dw	0FFE1h,0FFE1h,0FFE1h,0FFE1h,0FFE1h
	dw	0FFE1h,0FFE1h,0FFE1h,0FFE0h,0FFE1h
	dw	0FFE1h,0FFE1h,0FFE1h,0FFE1h,0FFE1h
	dw	0FFE1h,0FFE1h,0FFE1h,0FFE1h,0FFE1h
	dw	0FFE1h,0FFE1h,0FFE1h,0FFE1h,0FFE1h
	dw	0FFE1h,0FFE1h,0FFE1h,0FFE1h,0FFE1h
	dw	0FFE1h,0FFE1h,0FFE1h,0FFE1h,0FFE1h
	dw	0FFE1h,0FFE1h,0FFE1h,0FFE1h,0FFE1h
	dw	0FFE1h,0FFE1h,0FFE1h,0FFE1h,0FFE1h
	dw	0FFE1h,0FFE1h,0FFE1h,0FFE1h,0FFE2h
	dw	0FFE2h,0FFE2h,0FFE2h,0FFE2h,0FFE2h
	dw	0FFE2h,0FFE2h,0FFE2h,0FFE2h,0FFE2h
	dw	0FFE2h,0FFE2h,0FFE2h,0FFE2h,0FFE2h
	dw	0FFE2h,0FFE3h,0FFE3h,0FFE3h,0FFE3h
	dw	0FFE3h,0FFE3h,0FFE3h,0FFE3h,0FFE3h
	dw	0FFE3h,0FFE3h,0FFE3h,0FFE3h,0FFE3h
	dw	0FFE4h,0FFE4h,0FFE4h,0FFE4h,0FFE4h
	dw	0FFE4h,0FFE4h,0FFE4h,0FFE4h,0FFE4h
	dw	0FFE4h,0FFE5h,0FFE5h,0FFE5h,0FFE5h
	dw	0FFE5h,0FFE5h,0FFE5h,0FFE5h,0FFE5h
	dw	0FFE5h,0FFE6h,0FFE6h,0FFE6h,0FFE6h
	dw	0FFE6h,0FFE6h,0FFE6h,0FFE6h,0FFE6h
	dw	0FFE7h,0FFE7h,0FFE7h,0FFE7h,0FFE7h
	dw	0FFE7h,0FFE7h,0FFE7h,0FFE8h,0FFE8h
	dw	0FFE8h,0FFE8h,0FFE8h,0FFE8h,0FFE8h
	dw	0FFE8h,0FFE9h,0FFE9h,0FFE9h,0FFE9h
	dw	0FFE9h,0FFE9h,0FFE9h,0FFE9h,0FFEAh
	dw	0FFEAh,0FFEAh,0FFEAh,0FFEAh,0FFEAh
	dw	0FFEAh,0FFEBh,0FFEBh,0FFEBh,0FFEBh
	dw	0FFEBh,0FFEBh,0FFEBh,0FFECh,0FFECh
	dw	0FFECh,0FFECh,0FFECh,0FFECh,0FFEDh
	dw	0FFEDh,0FFEDh,0FFEDh,0FFEDh,0FFEDh
	dw	0FFEDh,0FFEEh,0FFEEh,0FFEEh,0FFEEh
	dw	0FFEEh,0FFEEh,0FFEFh,0FFEFh,0FFEFh
	dw	0FFEFh,0FFEFh,0FFEFh,0FFF0h,0FFF0h
	dw	0FFF0h,0FFF0h,0FFF0h,0FFF0h,0FFF1h
	dw	0FFF1h,0FFF1h,0FFF1h,0FFF1h,0FFF1h
	dw	0FFF2h,0FFF2h,0FFF2h,0FFF2h,0FFF2h
	dw	0FFF2h,0FFF3h,0FFF3h,0FFF3h,0FFF3h
	dw	0FFF3h,0FFF4h,0FFF4h,0FFF4h,0FFF4h
	dw	0FFF4h,0FFF4h,0FFF5h,0FFF5h,0FFF5h
	dw	0FFF5h,0FFF5h,0FFF6h,0FFF6h,0FFF6h
	dw	0FFF6h,0FFF6h,0FFF6h,0FFF7h,0FFF7h
	dw	0FFF7h,0FFF7h,0FFF7h,0FFF8h,0FFF8h
	dw	0FFF8h,0FFF8h,0FFF8h,0FFF9h,0FFF9h
	dw	0FFF9h,0FFF9h,0FFF9h,0FFF9h,0FFFAh
	dw	0FFFAh,0FFFAh,0FFFAh,0FFFAh,0FFFBh
	dw	0FFFBh,0FFFBh,0FFFBh,0FFFBh,0FFFCh
	dw	0FFFCh,0FFFCh,0FFFCh,0FFFCh,0FFFDh
	dw	0FFFDh,0FFFDh,0FFFDh,0FFFDh,0FFFEh
	dw	0FFFEh,0FFFEh,0FFFEh,0FFFEh,0FFFFh
	dw	0FFFFh,0FFFFh,0FFFFh,0FFFFh,00h
	dw	00h,00h,00h,00h,00h


endtext	LABEL BYTE ;endansi... well... endansiline (numbers are colors)
	db	15
	db	'(c) Paul Geary (Gor)'
	db	3,'  ',11
	db	'The Flag - in 80386+ Assembler'
	db	3,'  ',15
	db	'1/2/94'
	db	31
endtext1 LABEL BYTE

db 0fch

; Uninitialized (zero) data 

zerobeg	LABEL WORD ;start zero clear from here

rows	dw	320 dup(0)	;offsets to screen rows
cols	dw	320 dup(0)	;offsets to screen cols
colb	db	320 dup(0,0)	;bitmasks for screen cols

ALIGN 4
vbuf	LABEL BYTE
	db	44*200 dup(0) ;video buffer

ALIGN 4
dots	LABEL WORD

scrollsubber dw	0
framecounter dw	0
oldint8	dd	0

zeroend	LABEL WORD ;end zero clear here

code 	ENDS
	END start
