//
//      This file is executed when a new VxD is loaded.
//      IDA considers LE format files as VxDs.
//
//

//-----------------------------------------------------------------------
static Describe(ddb,i) {
  auto next,x,y;

  x = ddb;
  MakeDword(x);
  MakeComm (x,form("Next_%ld",i));
  next = Dword(x);
  if ( next != 0 ) OpOffset(x,0);
  x = x + 4;

  MakeWord(x);
  MakeName(x,form("SDK_Version_%ld",i));
  OpNum   (x);
  x = x + 2;

  MakeWord(x);
  MakeName(x,form("Req_Device_Number_%ld",i));
  OpNum   (x);
  x = x + 2;

  MakeByte(x);
  MakeName(x,form("Dev_Major_Version_%ld",i));
  OpNum(x);
  MakeComm(x,"Major device number");
  x = x + 1;

  MakeByte(x);
  MakeName(x,form("Dev_Minor_Version_%ld",i));
  OpNum   (x);
  MakeComm(x,"Minor device number");
  x = x + 1;

  MakeWord(x);
  MakeName(x,form("Flags_%ld",i));
  OpNum   (x);
  MakeComm(x,"Flags for init calls complete");
  x = x + 2;

  MakeStr (x,8);
  MakeName(x,form("Name_%ld",i));
  MakeComm(x,"Device name");
  x = x + 8;

  MakeDword(x);
  MakeName(x,form("Init_Order_%ld",i));
  OpNum   (x);
  MakeComm(x,"Initialization Order");
  x = x + 4;

  MakeDword(x);
  MakeName(x,form("Control_Proc_%ld",i));
  OpOffset(x,0);
  MakeComm(x,"Offset of control procedure");
  MakeCode( Dword(x) );
  MakeName( Dword(x), form("Control_%ld",i) );
  x = x + 4;

  MakeDword(x);
  MakeName(x,form("V86_API_Proc_%ld",i));
  MakeComm(x,"Offset of API procedure (or 0)");
  y = Dword(x);
  if ( y != 0 ) {
    OpOffset(x,0);
    MakeCode( y );
    MakeName( y, form("V86_%ld",i) );
  }
  x = x + 4;

  MakeDword(x);
  MakeName(x,form("PM_API_Proc_%ld",i));
  MakeComm(x,"Offset of API procedure (or 0)");
  y = Dword(x);
  if ( y != 0 ) {
    OpOffset(x,0);
    MakeCode( y );
    MakeName( y, form("PM_%ld",i) );
  }
  x = x + 4;

  MakeDword(x);
  MakeName(x,form("V86_API_CSIP_%ld",i));
  MakeComm(x,"CS:IP of API entry point");
  x = x + 4;

  MakeDword(x);
  MakeName(x,form("PM_API_CSIP_%ld",i));
  MakeComm(x,"CS:IP of API entry point");
  x = x + 4;

  MakeDword(x);
  MakeName(x,form("Reference_Data_%ld",i));
  MakeComm(x,"Reference data from real mode");
  x = x + 4;

  MakeDword(x);
  MakeName(x,form("Service_Table_Ptr_%ld",i));
  MakeComm(x,"Pointer to service table");
  y = Dword(x);
  if ( y != 0 ) {
    OpOffset(x,0);
    MakeName( y, form("Service_Table_%ld",i) );
    MakeDword(y);
    MakeArray( y, Dword(x+4) );
  }
  x = x + 4;

  MakeDword(x);
  MakeName(x,form("Service_Size_%ld",i));
  MakeComm(x,"Number of services");
  x = x + 4;

  return next;
}

//-----------------------------------------------------------------------
static main() {
  auto ea;
  auto i;

  i  = 0;
  ea = ScreenEA();
  while ( GetFlags(ea) != 0 ) {	// While ea points to valid address
    ea = Describe(ea,i);
    if ( ea == 0 ) break;
    i = i + 1;
  }
}
