.model compact
bios    segment at 40h    ; segment for the shift status byte
        org     17h
kbflag  db      ?         ; address of shift flag
bios    ends
        
        .data
        public  _oldkb
_oldkb   dd      0        ; assigned a value by the calling routine

        .code
        public  _newkb
_newkb  proc    far
        push    ax
        push    ds
        mov     ax,DGROUP
        mov     ds,ax
        in      al,60h
        cmp     al,2eh  ; check for <Break> scan code
        jz      maybe  ; (still need to see if <Ctrl> is pressed)
do_old:
        pushf
        call    dword ptr [_oldkb]
bye:
        pop     ds
        pop     ax
        iret

maybe:
        push    ds
        assume  ds:bios
        mov     ax,bios
        mov     ds,ax
        mov     al,kbflag    ;set up for shift check
        assume  ds:DGROUP
        pop     ds
        test    al,4         ; test for the ctrl flag
        jz      do_old



        in      al,61h      ; reset ritual
        xchg    ah,al
        or      al,80h
        out     61h,al
        xchg    ah,al
        out     61h,al
        mov     al,20h
        out     20h,al
        jmp     bye
_newkb  endp
        end
