PAGE ,132
;
;
;         Thomas Nofsinger
;         cccc ASM  290
;         4/16/89
;
;
;                  PROGRAM LISTING FOR KEYCODES.EXE
;
;      THIS PROGRAM WILL DISPLAY THE SCAN CODE AND THE ALPHANUMERIC
; VALUE OF ANY DEPRESSED KEYBOARD KEY.  IT WILL EXIT AFTER DOING THREE
; DISPLAY CYCLES.
;
;
;
                                       ;PROCEDURES TO
	   EXTRN   NEWLINE:FAR         ;DISPLAY NEWLINE CHARACTER
           EXTRN   PUTDEC:FAR          ;DISPLAY 16-BIT DECIMAL INTEGER
	   EXTRN   PUTSTRNG:FAR        ;DISPLAY CHARACTER STRING
	   EXTRN   CLEAR:FAR           ;CLEAR SCREEN
;
;
; MACRO DEFINITIONS
INCLUDE PUSHPOP.MAC
;
;           
; S T A C K   S E G M E N T   D E F I N I T I O N
;
STACK      SEGMENT STACK
           DB      256 DUP(?)
STACK      ENDS
;
; D A T A   S E G M E N T   D E F I N I T I O N
;
DATA       SEGMENT
;
;  COPYRIGHT BOX
LINE       db      '          __________________________________________________________  '
SIDE       db      '         |                                                          | '
CPY_RT     db      '         |  Copyright 1989 Thomas I. Nofsinger; All Rights Reserved | '
B_LINE     db      '         |__________________________________________________________| '
;
PROMPT1    DB      '      This program returns the scan code and the alphanumeric value of     '
PROMPT2    DB      '      any depressed key.  This program will exit after displaying 15 codes.'
PROMPT3    DB      '      Due to non-compatibility between PC keyboards, If the key you press  '
PROMPT4    DB      '      is a non-printable character, look under your finger to see what key '
PROMPT5    DB      '      you pressed.  For quick exit, hit the same key twice.  Program on:   '
HEADING    DB      '   INS  CAP  NUM  SCR  ALT  CTRL  LSHFT  RSHFT  CHAR   CODE   NON-PRINTABLE'
XXX        DB      'xxxx'      ;  for marking out colm's
wipeout    DB      '                                                                              '
SYMBOL     DB      '*'
EVEN
ASCII      DB   0 ;INIT TO ZERO
FRAME_ROW  DB   0  ;INIT TO ZERO

;
EVEN               ;USE EVEN MEMORY ADDRESSES
SCAN       DW   0  ;INIT TO ZERO
SCAN1      DW   0  ;INIT TO ZERO
FLAG       DW   0  ;INIT TO ZERO
FLAG1      DW   1  ;INIT TO ONE
TEMP       DW   0  ;INIT TO ZERO
COUNT      DW  15  ;INIT TO 15
DATA       ENDS


;
; C O D E   S E G M E N T   D E F I N I T I O N
;
CODE       SEGMENT
           ASSUME  CS:CODE,SS:STACK,ES:DATA 
KEYCODES   PROC    FAR
           PUSH    DS                  ;PUSH RETURN SEG ADDR ON STACK
           SUB     AX,AX               ;PUSH RETURN OFFSET OF ZERO
           PUSH    AX                  ;ON STACK
           MOV     AX,SEG DATA         ;SET ES-REGISTER TO POINT
           MOV     ES,AX               ;TO DATA SEGMENT
;
; set up screen
	   MOV  AH,0            ;set video mode
	   mov  al,3            ;color text mode
	   INT  10H             ;clear screen

	   call    clear               ;clear screen
	   mov     dh,20               ;place cursor at row 18
	   mov     dl,0                ;                colm 0
	   mov     ah,2                ;   sub call for int 10h
	   int     10h                 ;Bios interrupt for cursor motion
 ;
	   lea     di,LINE             ; print copyright w/box, line
	   mov     cx,70               ;                      by line.
	   call    putstrng            ;
	   call    newline             ;
	   lea     di,SIDE             ;
	   mov     cx,70               ;
	   call    putstrng            ;
	   call    newline             ;
	   lea     di,CPY_RT           ;
	   mov     cx,70               ;
	   call    putstrng            ;
	   call    newline             ;
	   lea     di,B_LINE           ;
	   mov     cx,70               ;
	   call    putstrng            ;
	   call    newline             ;END BOX
;
	   mov     dh,10               ;place cursor at row 10
	   mov     dl,0                ;                colm 0
	   mov     ah,2                ;   sub call for int 10h
	   int     10h                 ;Bios interrupt for cursor motion
;
	   LEA     DI,PROMPT1          ;PROMPT FOR EXPLAINATION 1 OF 5
	   MOV     CX,75
	   CALL    PUTSTRNG
	   CALL    NEWLINE
	   LEA     DI,PROMPT2          ;PROMPT FOR EXPLAINATION 2 OF 5
	   MOV     CX,75
	   CALL    PUTSTRNG
	   CALL    NEWLINE
	   LEA     DI,PROMPT3          ;PROMPT FOR EXPLAINATION 3 OF 5
	   MOV     CX,75
	   CALL    PUTSTRNG
	   CALL    NEWLINE
	   LEA     DI,PROMPT4          ;PROMPT FOR EXPLAINATION 4 OF 5
	   MOV     CX,75
	   CALL    PUTSTRNG
	   CALL    NEWLINE
	   LEA     DI,PROMPT5          ;PROMPT FOR EXPLAINATION 5 OF 5
	   MOV     CX,75
	   CALL    PUTSTRNG
	   CALL    NEWLINE
;
	   mov     dh,4                ;place cursor at row 4
	   mov     dl,0                ;                colm 0
	   mov     ah,2                ;   sub call for int 10h
	   int     10h                 ;Bios interrupt for cursor motion
	   lea     di,heading          ; print heading
	   mov     cx,75
	   call    putstrng
	   call    newline
	   CALL    FRAME               ;DRAW FRAME



IN_KEY:

	MOV     AH,2            ;GET KEYBOARDS FLAG BYTES
	INT     16H             ;BIOS KEYBOARD CALL
	XOR     AH,AH           ;ZERO AH
        MOV     FLAG,AX         ;SAVE FLAGS WITH ZEROS IN HIGH BYTE
	CMP     AX,FLAG1        ;SAME FLAG AS BEFORE?
	JNE     N_FLAG          ;DIFFERENT FLAG, GO SHOW IT!

	MOV     AH,1            ;IS THERE A BYTE IN KEYBOARD BUFFER?
	INT     16H             ;BIOS KEYBOARD CALL
	JNZ     CODE_DISPLAY    ;ZF=0, BYTE WAITING, GO GET IT!

	JMP     SHORT IN_KEY    ;TAKE IT FROM THE TOP

N_FLAG:
	MOV     FLAG1,AX        ;Save the new flag for the next cycle
	CALL    CLEARLINE       ;SETUP FOR NEW DISPLAY
	CALL	NEWFLAG		;SHOW FLAG ROUTINE

	JMP     SHORT IN_KEY    ;DONE. TAKE IT FROM THE TOP

CODE_DISPLAY:
	CALL    CLEARLINE
	CALL    NEWFLAG

	MOV     AH,0            ;READ KEYBOARD BUFFER
	INT     16H             ;BIOS KEYBOARD CALL
	MOV     TEMP,AX         ;HOLD RESULTS FOR A SECOND
	XOR     AH,AH           ;ZERO HIGH BYTE TO JUST GET ASCII CODE
	MOV     ASCII,AL        ;SAVE ASCII CODE

	MOV	AX,TEMP         ;GET RESULTS

	XCHG    AH,AL           ;PLACE SCAN CODE INTO LOW BYTE
	XOR     AH,AH           ;ZERO HIGH BYTE
	MOV     SCAN,AX         ;SAVE SCAN CODE

	CMP     AX,SCAN1        ;SAME KEY AS LAST TIME?
	JE      STOP1           ;YES IT WAS, EXIT PROGRAM

	JMP     SHORT POTS1     ;YOUR BASIC SKIP CODE BLOCK
STOP1:
	JMP     LAST            ;  LONG JMP
POTS1:

	MOV     SCAN1,AX        ;PLACE SCAN INTO SCAN1 FOR NEXT CYCLE

	MOV     DH,5            ;PLACE CURSOR AT ROW 5
	MOV     DL,50           ;               COLM 50
	MOV     BH,0
	MOV     AH,2            ;PLACE CURSOR SUB FUNCTION
	INT     10H             ;BIOS SCREEN INTERRUPT

	LEA     DI,ASCII        ;GET CHAR
	MOV     CX,1            ;ONE CHAR
	CALL    PUTSTRNG        ;DISPLAY CHAR

	MOV     DH,5            ;    ROW 5
	MOV     DL,56           ;   COLM 56
	MOV     BH,0
	MOV     AH,2            ;PLACE CURSOR SUB FUNCTION
	INT     10H             ;BIOS SCREEN INTERRUPT
	MOV     AX,SCAN         ;GET SCAN CODE
	MOV     BX,0            ;RIGHT JUSTIFY DEC #
	CALL    PUTDEC          ;DISPLAY SCAN CODE AS NUMBER

	dec	count		; count=count-1
	mov	ax,count
	cmp	ax,0
	jz	last

	MOV     Al,ASCII        ;GET CHAR
	CMP     Al,0            ;CHECK FOR ZERO
	JZ      NON_PRT         ;PRINT NON_PRINTABLE COLM

	JMP     IN_KEY          ;DONE.  TAKE IT FROM THE TOP

NON_PRT:
	CALL    NONPRT
	JMP     IN_KEY

;
LAST:
	   mov     dh,24               ;place cursor at row 24
	   mov     dl,0                ;                colm 0
	   mov     bh,0
	   mov     ah,2                ;    sub call for int 10h
	   int     10h                 ;Bios interrupt for cursor motion
	   RET                         ;RETURN
KEYCODES   ENDP


;

CLEARLINE	PROC	NEAR
	mov     dh,5            ;  row 5
	mov     dl,1            ; colm 1
	mov     bh,0
	mov     ah,2            ;place cusor sub func
	int     10h             ;bios screen intr.
	lea     di,wipeout      ;clear out line
	mov     cx,78           ;middle 78 chars - ends left alone
	call    putstrng        ;
	RET
CLEARLINE	ENDP

;

NEWFLAG	PROC	NEAR
	PUSHA

	;TEST FLAG BIT TREE

L_INS:
	MOV     AX,FLAG         ;MOVE FLAGS INTO AX
	TEST    AX,10000000B    ;TEST FOR INSERT
	JNZ     STOP10          ;PRINT ROUTINE FOR INS

	JMP     SHORT POTS10    ;START SKIP BLOCK
STOP10:
	mov     dh,5            ;  row 5
	mov     dl,3            ; colm 3
	mov     bh,0
	mov     ah,2            ;place cusor sub func
	int     10h             ;bios screen intr.
	lea     di,XXX          ;mark out chars
	mov     cx,3            ;three of them
	call    putstrng        ;mark out the colm!

POTS10:
	NOP                     ;END SKIP BLOCK


L_CAPS:
	MOV     AX,FLAG         ;MOVE FLAGS INTO AX
	TEST    AX,01000000B    ;TEST FOR CAP LOCK
	JNZ     STOP9           ;PRINT ROUTINE FOR CAP LOCK

	JMP     SHORT POTS9     ;START SKIP BLOCK
STOP9:
	mov     dh,5            ;  row 5
	mov     dl,8            ; colm 8
	mov     bh,0
	mov     ah,2            ;place cusor sub func
	int     10h             ;bios screen intr.
	lea     di,XXX          ;mark out chars
	mov     cx,3            ;three of them
	call    putstrng        ;mark out the colm!

POTS9:
	NOP                     ;END SKIP BLOCK

L_NUM:
	MOV     AX,FLAG         ;MOVE FLAGS INTO AX
	TEST    AX,00100000B    ;TEST FOR NUM LOCK
	JNZ     STOP8           ;PRINT ROUTINE FOR NUM LOCK

	JMP     SHORT POTS8     ;START SKIP BLOCK
STOP8:
	mov     dh,5            ;  row 5
	mov     dl,13           ; colm 13
	mov     bh,0
	mov     ah,2            ;place cusor sub func
	int     10h             ;bios screen intr.
	lea     di,XXX          ;mark out chars
	mov     cx,3            ;three of them
	call    putstrng        ;mark out the colm!

POTS8:
	NOP                     ;END SKIP BLOCK

L_SCR:
	MOV     AX,FLAG         ;MOVE FLAGS INTO AX
	TEST    AX,00010000B    ;TEST FOR SCROLL LOCK
	JNZ     STOP7           ;PRINT ROUTINE FOR SCROLL LOCK

	JMP     SHORT POTS7     ;START SKIP BLOCK
STOP7:
	mov     dh,5            ;  row 5
	mov     dl,18           ; colm 18
	mov     bh,0
	mov     ah,2            ;place cusor sub func
	int     10h             ;bios screen intr.
	lea     di,XXX          ;mark out chars
	mov     cx,3            ;three of them
	call    putstrng        ;mark out the colm!

POTS7:
	NOP                     ;END SKIP BLOCK

L_ALT:
	MOV     AX,FLAG         ;MOVE FLAGS INTO AX
	TEST    AX,00001000B    ;TEST FOR ALT
	JNZ     STOP6           ;PRINT ROUTINE FOR ALT

	JMP     SHORT POTS6     ;START SKIP BLOCK
STOP6:
	mov     dh,5            ;  row 5
	mov     dl,23           ; colm 23
	mov     bh,0
	mov     ah,2            ;place cusor sub func
	int     10h             ;bios screen intr.
	lea     di,XXX          ;mark out chars
	mov     cx,3            ;three of them
	call    putstrng        ;mark out the colm!

POTS6:
	NOP                     ;END SKIP BLOCK

L_CTRL:
	MOV     AX,FLAG         ;MOVE FLAGS INTO AX
	TEST    AX,00000100B    ;TEST FOR CTRL
	JNZ     STOP3           ;PRINT ROUTINE FOR CTRL

	JMP     SHORT POTS3     ;START SKIP BLOCK
STOP3:
	mov     dh,5            ;  row 5
	mov     dl,28           ; colm 28
	mov     bh,0
	mov     ah,2            ;place cusor sub func
	int     10h             ;bios screen intr.
	lea     di,XXX          ;mark out chars
	mov     cx,3            ;three of them
	call    putstrng        ;mark out the colm!

POTS3:
	NOP                     ;END SKIP BLOCK

 L_L_SHFT:
	MOV     AX,FLAG         ;MOVE FLAGS INTO AX
	TEST    AX,00000010B    ;TEST FOR L_SHFT
	JNZ     STOP4           ;PRINT ROUTINE FOR LEFT SHIFT


	JMP     SHORT POTS4     ;START SKIP BLOCK
STOP4:
	mov     dh,5            ;  row 5
	mov     dl,34           ; colm 34
	mov     bh,0
	mov     ah,2            ;place cusor sub func
	int     10h             ;bios screen intr.
	lea     di,XXX          ;mark out chars
	mov     cx,4            ;four of them
	call    putstrng        ;mark out the colm!

POTS4:
	NOP                     ;END SKIP BLOCK


L_R_SHFT:
	MOV     AX,FLAG         ;MOVE FLAGS INTO AX
	TEST    AX,00000001B    ;TEST FOR R_SHFT
	JNZ     STOP5           ;PRINT ROUTINE FOR RIGHT SHIFT

	JMP     SHORT POTS5     ;START SKIP BLOCK
STOP5:
	mov     dh,5            ;  row 5
	mov     dl,41           ; colm 41
	mov     bh,0
	mov     ah,2            ;place cusor sub func
	int     10h             ;bios screen intr.
	lea     di,XXX          ;mark out chars
	mov     cx,4            ;four of them
	call    putstrng        ;mark out the colm!

POTS5:
	NOP                     ;END SKIP BLOCK

	POPA
	RET
NEWFLAG	ENDP

;

NONPRT  PROC    NEAR
	MOV     DH,5            ;  ROW 5
	MOV     DL,66           ; COLM 66
	mov     bh,0
	mov     ah,2            ;place cusor sub func
	int     10h             ;bios screen intr.
	lea     di,XXX          ;mark out chars
	mov     cx,4            ;four of them
	call    putstrng        ;mark out the colm!
	RET
NONPRT  ENDP

;

FRAME   PROC    NEAR
	MOV     DH,0            ;  ROW 0
	MOV     DL,0            ; COLM 0
	mov     bh,0
	mov     ah,2            ;place cusor sub func
	int     10h             ;bios screen intr.

	MOV     BH,0
	MOV     BL,46   ;GREEN BACKGROUND/YELLOW FOREGROUND
	MOV     AL,SYMBOL       ; "*"
	MOV     CX,79           ;print symbol 79 times
	MOV     AH,9
	INT     10H             ;SCREEN BIOS

	MOV     DH,24           ;  ROW 24
	MOV     DL,0            ; COLM 0
	mov     bh,0
	mov     ah,2            ;place cusor sub func
	int     10h             ;bios screen intr.

	MOV     BH,0
	MOV     BL,46   ;GREEN BACKGROUND/YELLOW FOREGROUND
	MOV     AL,SYMBOL       ; "*"
	MOV     CX,79           ;print symbol 79 times
	MOV     AH,9
	INT     10H             ;SCREEN BIOS

FR_loop:

	MOV     DH,frame_row    ;  ROW #
	MOV     DL,0            ; COLM 0
	mov     bh,0
	mov     ah,2            ;place cusor sub func
	int     10h             ;bios screen intr.

	MOV     BH,0
	MOV     BL,46   ;GREEN BACKGROUND/YELLOW FOREGROUND
	MOV     AL,SYMBOL       ; "*"
	MOV     CX,1            ;print symbol 1 time
	MOV     AH,9
	INT     10H             ;SCREEN BIOS

	MOV     DH,frame_row    ;  ROW #
	MOV     DL,79           ; COLM 79
	mov     bh,0
	mov     ah,2            ;place cusor sub func
	int     10h             ;bios screen intr.

	MOV     BH,0
	MOV     BL,46   ;GREEN BACKGROUND/YELLOW FOREGROUND
	MOV     AL,SYMBOL       ; "*"
	MOV     CX,1            ;print symbol 1 time
	MOV     AH,9
	INT     10H             ;SCREEN BIOS

	INC     FRAME_ROW
	MOV     AL,FRAME_ROW
	CMP     AL,25
	JNE     FR_LOOP


	RET
FRAME   ENDP

CODE       ENDS
	   END     KEYCODES
