;------------------------------------------------------------------------------
;MI33.ASM : 16-July-1993 : A PWB make-me-happy mouse driver wrapper	
;------------------------------------------------------------------------------
;Simple mouse INT33 wrapper for applications that like to leave the
;mouse cursor at center-screen after a hardware/software mouse reset
;functions 0 & 33. Object here is to trap these functions and position
;mouse cursor to upper-left. This doesn't prevent later mouse cursor
;positioning, but that's not the problem; the problem is apps that
;just do a reset and leave you to reposition the mouse cursor. One
;prime example is PWB. At startup, sure, it positions the mouse cursor
;to the last-at one, but on return from a compile, make, etc., the
;mouse cursor always goes to center-screen (my only "problem" with PWB).
;I was going to patch the mouse driver, but that would be version-specific,
;not to mention that it's a tangle web in there. Anyway, here we go. Simple,
;like I said. Written using MASM 6.1a, but I don't think I'll use any
;6.1a-specific stuff (should work with any MASM).
;------------------------------------------------------------------------------
;For any future changes, call my BBS. The BBS features all sorts of programmer
;toolkits such as:
; BULLET: super-fast dBASE file managers (BLTQ13.ZIP, BLTC13.ZIP)
; RUCKUS: multi-soundcard, MOD/VOC/WAV/MIDI/CMF/ROL-cnv (RUKQ10.ZIP, RUKC10.ZIP)
; and too many other programmer toolkits to mention here. BTW, the Qxx and
; Cxx in RUCKUS and BULLET are for QB,BASIC7,VBDOS, and DOS C compiler,
; respectively. xx is distribution number and will change.
;
;	BBS support telephone: 1(210)684-8065. V.32bis (1200-14.4k bps)
;Hours: Monday through Friday, 5pm to 9am next morning
;	Weekend hours are 1pm to 9am next morning.
;	All times USA Central Time, about UTCtime-5.
;
;This code is public domain, do what you will. Just never forget
;that it was written by:
; Cornel Huth (chuth@lonestar.utsa.edu) (Fidonet 1:387/822.8)
; 6402 Ingram Rd/San Antonio, TX 78238/U.S.A.
;------------------------------------------------------------------------------

_text SEGMENT 'code'	
		ORG 100h

BPTR EQU <BYTE PTR>
WPTR EQU <WORD PTR>

start:		jmp	install
		
		ORG 150h	;sure, filesize is 80 bytes larger, but
				;still takes as a cluster, anyway, plus
				;we save twice that resident-memory use

orgMouse33	DWORD 33494D2Dh
orgFuncNo	WORD 2D33h
		
		ORG 160h	;the resident code will be moved down
				;into the PSP at PSP:60h (para aligned entry)
								
		;INT33 comes here before MOUSE.COM/SYS/EXE code.
		;This saves func#, routes to original, then checks
		;if it's a reset func. If so, issues a SET MOUSE CURSOR
		;POSITION to 0,0 and returns to caller.

MI33:		mov	cs:orgFuncNo-100h,ax
		pushf			
		call	cs:[orgMouse33-100h]
		push	ax
		mov	ax,cs:orgFuncNo-100h
		or	ax,ax		;func 0
		jz	MI33work	;or
		cmp	ax,33		;func 33 (decimal)
		je	MI33work	;then work to do
MI33xit:	pop	ax		;ax from mouse driver
		iret			;and back

MI33work:	push	cx		;simple enough, if a mouse reset
		push	dx		;was called, move the mouse cursor
		sub	cx,cx		;to the upper-left of screen
		mov	dx,cx
		mov	ax,4
		int 33h
		pop	dx
		pop	cx
		jmp	MI33xit

		;-------------- end of resident code --------------
		;Install using as little resident space as possible
		;Nothing fancy here, expected to be loaded AFTER
		;MOUSE.COM/SYS/EXE and to remain in memory forever.
		;Also requires DOS 3+.

install:	mov	ah,30h
		int 21h
		cmp	al,3
		mov	dx,OFFSET Bomb0msg
		jb	StdOut
		
		mov	ax,3533h
		int 21h			
		cmp	BPTR es:[bx],0CFh ;es:bx->mouse entry code, IRET only?
		mov	dx,OFFSET Bomb1msg
		je	StdOut
		
		;checks out so install
		
		mov	WPTR cs:[orgMouse33],bx	;save mouse driver entry
		mov	WPTR cs:[orgMouse33+2],es
		
		;release environment
		
		mov	es,WPTR cs:[2Ch]	;PSP:2C=environ segment
		mov	ah,49h
		int 21h
		
		;transplant MI33 code -100h bytes relative (into PSP)
		;(saves significant number of bytes for a 30-byte program)
		
		push	cs
		push	cs
		pop	ds
		pop	es
		mov	si,OFFSET orgMouse33	;ds:si->cs:150 (150h)
		mov	di,50h			;es:di->PSP:50 ( 50h)
		mov	cx,OFFSET install-150h	;size in bytes
		rep movsb
		
		mov	dx,OFFSET MI33-100h	;ds:dx->MI33
		mov	ax,2533h		;set INT33 vector
		int 21h
		mov	dx,OFFSET Installmsg

StdOut:		push	cs
		pop	ds
		mov	ah,9
		int 21h
		cmp	dx,OFFSET Installmsg
		jne	BombOut
		mov	dx,OFFSET install-100h	;relative PSP:0
		int 27h		

BombOut:	mov	ax,4C01h
		int 21h

Bomb0msg	db "DOS 3+ needed",13,10,"$"
Bomb1msg	db "INT33->iret",13,10,"$"
Installmsg	db "MI33 installed",13,10,"$"

_text ENDS
		END start
