NAME	install_tsr
;
DGROUP	GROUP	DATA

PGROUP	GROUP	PROG

PROG	SEGMENT BYTE PUBLIC 'PROG'
	ASSUME	CS:PGROUP,DS:DGROUP,es:nothing

	PUBLIC	MAIN			;NOTE: ALTHOUGH C88 USES A TRAILING
					;UNDERSCORE ON PUBLICS, THESE ARE
					;DELETED IN .OBJ FORMAT.
	extrn foo:near,fee:near,last_data:near
MAIN	PROC	NEAR
	PUSH	DS			;SAVE OLD DS
	PUSH	CS
	POP	DS			;SET UP DS:DX TO
	MOV	DX,OFFSET pgroup:PROC_INT	;INITIALIZE FUNCTION CALL 
	MOV	AL,0E0H			;INTERRUPT E0H
	MOV	AH,25h			;USE DOS CALL 25H
	INT	21H
	;now we find the size of this program and data area
	;so it can be passed to the terminate and stay resident function
	pop	ds			;restore original ds
	mov	dx,ds			;put in dx for use later
	mov	cs:saveds,dx		;save ds where we can always find it
	mov	ax,offset dgroup:last_data	;get marker of end of data area
	mov	cl,4			;get cl ready for para. computation
	push	ax			;end of data marker
	and	ax,0fh			;check for additional paragraph
	jz	all_ok			;last digit zero, ok
	pop	ax			;last digit non zero,
	shr	ax,cl			;compute paragraph
	inc	ax			;add one
	jmp	get_out
all_ok:					;otherwise,stick with original end
	pop	ax
	shr	ax,cl
get_out:
	add	dx,ax			;now dx has end paragraph number
	;es has paragraph number of initial allocation block
	mov	ax,es
	sub	dx,ax			;difference between end paragraph # and
;					;# of initial alloc. block is pgm size
	mov	ah,31H			;this is passed to term and stay res.
	int	21H			;function
MAIN	ENDP
;
;
;This procedure is the software interrupt function handler
;
;
proc_int	proc	near
	push	ax			;save all regs
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	push	ds
	push	es
	mov	bx,cs:saveds		;restore original ds
	mov	ds,bx
	sti				;allow interrupts to happen
	xor	ah,ah			;calculate offset into vector table
	shl	al,1
	mov	si,ax
	;
	call	cs:[si+offset vec_tab]	;call the function
	;
	pop	es			;restore all regs
	pop	ds
	pop	bp
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	iret				
proc_int	endp
;
;
saveds	dw	?
VEC_TAB	DW	OFFSET pgroup:foo
	DW	OFFSET pgroup:fee
PROG	ENDS
;
DATA	SEGMENT	WORD PUBLIC 'DATA'
DATA	ENDS
	END
;
;
;
;
;
;
