; File......: AINT86.ASM
; Author....: Ted Means
; Date......: $Date:   20 Jun 1992 02:59:24  $
; Revision..: $Revision:   1.2  $
; Log file..: $Logfile:   C:/nanfor/src/aint86.asv  $
; 
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log:   C:/nanfor/src/aint86.asv  $
;  
;     Rev 1.2   20 Jun 1992 02:59:24   GLENN
;  Rodgers Moore [75730,2244] added mod to save and restore the stack
;  segment and stack pointer registers around the interrupt vector.  He
;  was trying to call INT 2E and apparently some versions of DOS trash
;  SS and SP.
;  
;     Rev 1.1   15 Aug 1991 23:07:24   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;  
;     Rev 1.0   27 May 1991 13:21:48   GLENN
;  Initial revision.
;


; This file is a part of the ft_int86() package.  For complete
; documentation, read cint86.c, available elsewhere in the 
; Nanforum Toolkit.
;
; This module should be compiled with TASM.


Public   __ftint86

Segment  _NanFor   Word      Public    "CODE"
         Assume    CS:_NanFor

Proc     __ftint86 Far

         Pop       CX                        ; Remove return address from
         Pop       DX                        ; stack

         Pop       [CS:RegOfs]               ; Get pointer to register
         Pop       [CS:RegSeg]               ; structure from stack

         Pop       AX                        ; Get desired interrupt

         Push      DX                        ; Put return address back onto
         Push      CX                        ; stack to prevent underflow

         Push      DS                        ; Save modified registers
         Push      SI
         Push      DI
         Push      BP

         Mov       AH,35h                    ; DOS service -- get vector
         Int       21h                       ; Call DOS
         Mov       [CS:HndSeg],ES            ; Store address of desired
         Mov       [CS:HndOfs],BX            ; interrupt handler

         LDS       BX,[CS:RegPtr]            ; Load pointer to register values
         Push      [Word Ptr BX + 16]        ; Put ES value on stack
         Push      [Word Ptr BX + 14]        ; Put DS value on stack
         Push      [Word Ptr BX + 12]        ; Put BP value on stack
         Push      [Word Ptr BX + 10]        ; Put DI value on stack
         Push      [Word Ptr BX + 8]         ; Put SI value on stack
         Push      [Word Ptr BX + 6]         ; Put DX value on stack
         Push      [Word Ptr BX + 4]         ; Put CX value on stack
         Push      [Word Ptr BX + 2]         ; Put BX value on stack
         Mov       AX,[Word Ptr BX + 0]      ; Get AX value
         Pop       BX                        ; Get BX value
         Pop       CX                        ; Get CX value
         Pop       DX                        ; Get DX value
         Pop       SI                        ; Get SI value
         Pop       DI                        ; Get DI value
         Pop       BP                        ; Get BP value
         Pop       DS                        ; Get DS value
         Pop       ES                        ; Get ES value

         Mov       [CS:SavSS],SS             ; Save Stack Segment
         Mov       [CS:SavSP],SP             ; and Stack Pointer Registers

         PushF                               ; Simulate INT instruction by
         CLI                                 ; using PushF and CLI
         Call      [CS:Handler]              ; Call the interrupt handler

         Mov       SS,[CS:SavSS]             ; Restore Stack Segment
         Mov       SP,[CS:SavSP]             ; and Stack Pointer Registers

         Push      AX                        ; Save all registers to preserve
         Push      BX                        ; the state of the CPU after
         Push      CX                        ; the interrupt executed
         Push      DX
         Push      SI
         Push      DI
         Push      BP
         Push      DS
         Push      ES
         PushF

         LDS       BX,[CS:RegPtr]            ; Load pointer to register values
         Pop       [Word Ptr BX + 18]        ; Get saved registers and load
         Pop       [Word Ptr BX + 16]        ; into data structure
         Pop       [Word Ptr BX + 14]
         Pop       [Word Ptr BX + 12]
         Pop       [Word Ptr BX + 10]
         Pop       [Word Ptr BX + 8]
         Pop       [Word Ptr BX + 6]
         Pop       [Word Ptr BX + 4]
         Pop       [Word Ptr BX + 2]
         Pop       [Word Ptr BX + 0]

         Pop       BP                        ; Restore registers
         Pop       DI
         Pop       SI
         Pop       DS
         Ret
Endp     __ftint86

SavSS    DW        0
SavSP    DW        0

Label    Handler   DWord
HndOfs   DW        ?
HndSeg   DW        ?

Label    RegPtr    DWord
RegOfs   DW        ?
RegSeg   DW        ?

Ends     _NanFor
End
