; File......: NWTTS2.ASM
; Author....: James R. Zack
; CIS ID....: 75410,1567
; Date......: $Date:   15 Aug 1991 23:07:52  $
; Revision..: $Revision:   1.2  $
; Log file..: $Logfile:   E:/nanfor/src/nwtts2.asv  $
; 
; This is an original work by James Zack and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log:   E:/nanfor/src/nwtts2.asv  $
;  
;     Rev 1.2   15 Aug 1991 23:07:52   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;  
;     Rev 1.1   11 Apr 1991 23:57:18   GLENN
;  Librarian error!  The ft_ extension was added to the function name 
;  after testing, by mistake, and I didn't realize that .ASM functions
;  _had_ to obey the 10-char limit, thus linkers couldn't find the 
;  proper symbol.  Changed this to ft_ttsabor().  Apologies to Mr. Zack.
;  
;     Rev 1.0   01 Apr 1991 01:03:40   GLENN
;  Nanforum Toolkit
;  

; $DOC$
; $FUNCNAME$
;     FT_TTSABORT()
; $CATEGORY$
;     NetWare
; $ONELINER$
;     Abort explicit and implicit NetWare TTS transactions
; $SYNTAX$
;     FT_TTSABORT() -> nResult
; $ARGUMENTS$
;     None
; $RETURNS$
;       0 - Abort Successful (backout completed)
;     253 - Transaction Tracking disabled (no backout performed)
;     254 - Transaction ended, records locked (No backout performed)
;     255 - No explicit transactions active
; $DESCRIPTION$
;    Consult your NetWare documentation for details on the NetWare 
;    Transaction Tracking System.
; $EXAMPLES$
;    nResult := FT_TTSABORT()
;    DO CASE
;       CASE nResult == 0
;          ? "TTS aborted"
;       CASE nResult == 253
;          ? "Transction tracking, no backout performed"
;       CASE nResult == 254
;          ? "Transaction ended, records locked, no backout performed"
;       CASE nResult == 255
;          ? "No transactions active"
;       OTHERWISE
;          ? "Unknown result"
;    ENDCASE
; $SEEALSO$
;    FT_TTSAVAIL() FT_TTSBEGIN() FT_TTSEND() FT_TTSSTAT()
; $END$
;
;


PUBLIC    FT_TTSABOR
EXTRN     __RETNI:FAR
extrn     __RET:FAR
_NanFor  SEGMENT 'CODE'
          ASSUME cs:_NanFor
FT_TTSABOR PROC    FAR
          push    bp
          mov     bp,sp
          push    ds
          push    es
          push    si
          push    di
          mov     ah,0c7h          ; Novell API function c7
          mov     al,03h           ; Subfunction 02
          int     21h              ; TTS Abort Transaction
          mov     ah,00h
          push    ax
          call    __RETNI
          add     sp,2
          pop     di
          pop     si
          pop     es
          pop     ds
          pop     bp
          call    __RET
          ret

FT_TTSABOR endp

_NanFor   ends

          end

