/****************************************************************************
*
*						  Protected Mode Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: memtest.c $
* Version:		$Revision: 1.1 $
*
* Language:		ANSI C
* Environment:	any
*
* Description:	Test program to determine just how much memory can be
*				allocated with the compiler in use. Compile and link
*				with the appropriate command line for your DOS extender.
*
*				Functions tested:	malloc()
*
* $Id: memtest.c 1.1 1995/02/06 12:43:43 kjb release $
*
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <math.h>
#include "pmode.h"

int main(void)
{
	char *p;
	unsigned long allocs;

    printf("Program running in ");
	switch (_PM_modeType) {
		case PM_realMode:
			printf("real mode.\n\n");
			break;
		case PM_286:
			printf("16 bit protected mode.\n\n");
			break;
		case PM_386:
			printf("32 bit protected mode.\n\n");
			break;
        }

	for (allocs = 0; ; allocs++) {
		if ((p = malloc(10*1024)) != 0) {	/* in 10k blocks 	*/
			memset(p, 0, 10*1024); /* touch every byte 			*/
			*p = 'x';           /* do something, anything with	*/
			p[1023] = 'y';      /* the allocated memory      	*/

			printf("Allocated %lu bytes\r", 10*(allocs << 10));
            }
		else {
			allocs--;
			break;
			}
		if (kbhit() && (getch() == 0x1B))
			break;
		}

	printf("\n\nAllocated total of %lu bytes\n", 10 * (allocs << 10));
	return 0;
}
