;****************************************************************************
;*
;*						  	  PM/Lite Library
;*
;*                  Copyright (C) 1994 SciTech Software
;*							All rights reserved.
;*
;* Filename:    $RCSfile: _pmlite.asm $
;* Version:     $Revision: 1.1 $
;*
;* Language:	80386 Assembler, TASM 4.0 or later
;* Environment:	IBM PC Real mode and 16/32 bit protected mode
;*
;* Description:	Low level assembly support.
;*
;* $Id: _pmlite.asm 1.1 1995/02/06 12:43:49 kjb release $
;*
;****************************************************************************

		IDEAL

INCLUDE "model.mac"				; Memory model macros

header      _pmlite             ; Set up memory model

begdataseg	_pmlite

if flatmodel
_PM_savedDS		dw	0			; Saved value of DS
				PUBLIC	_PM_savedDS
endif

enddataseg	_pmlite

begcodeseg  _pmlite				; Start of code segment

ifndef  DPMI16
ifndef  WINDPMI16
ife 	flatmodel

struc   rmregs_s
ax      dw	?
bx		dw	?
cx		dw	?
dx		dw	?
si		dw	?
di		dw	?
cflag	dw	?
flags	dw	?
ends	rmregs_s
RMREGS	= (rmregs_s PTR es:bx)

struc	rmsregs_s
es		dw	?
cs		dw	?
ss		dw	?
ds		dw	?
ends	rmsregs_s
RMSREGS	= (rmsregs_s PTR es:bx)

;----------------------------------------------------------------------------
; void PM_callRealMode(unsigned s,unsigned o, RMREGS *regs,
;	RMSREGS *sregs)
;----------------------------------------------------------------------------
; Calls a real mode procedure, loading the appropriate registers values
; from the passed in structures. Only the DS and ES register are loaded
; from the SREGS structure.
;----------------------------------------------------------------------------
procstart	_PM_callRealMode

		ARG     s:WORD, o:WORD, regs:DWORD, sregs:DWORD

		LOCAL	addr:DWORD, bxVal:WORD, esVal:WORD, flags:WORD = LocalSize

		enter_c	LocalSize
		push	ds
		push	es

		mov		ax,[o]				; Build the address to call in 'addr'
		mov		[WORD addr],ax
		mov		ax,[s]
		mov		[WORD addr+2],ax

		les		bx,[sregs]
		mov     ax,[RMSREGS.ds]
		mov     ds,ax				; DS := passed in value
		mov		ax,[RMSREGS.es]
		mov		[esVal],ax
		les		bx,[regs]
		mov		ax,[RMREGS.bx]
		mov		[bxVal],ax
		mov		ax,[RMREGS.ax]		; AX := passed in value
		mov		cx,[RMREGS.cx]		; CX := passed in value
		mov		dx,[RMREGS.dx]		; DX := passed in value
		mov		si,[RMREGS.si] 		; SI := passed in value
		mov		di,[RMREGS.di]		; DI := passed in value
		push	bp
		push	[esVal]
		pop		es					; ES := passed in value
		mov		bx,[bxVal]			; BX := passed in value

		call	[addr]				; Call the specified routine

		pushf						; Save flags for later
		pop		[flags]

		pop		bp
		push	es
		pop		[esVal]
		push	bx
		pop		[bxVal]
		les		bx,[sregs]
		push	ds
		pop		[RMSREGS.ds]		; Save value of DS
		push	[esVal]
		pop		[RMSREGS.es]		; Save value of ES
		les		bx,[regs]
		mov		[RMREGS.ax],ax		; Save value of AX
		mov		[RMREGS.cx],cx		; Save value of CX
		mov		[RMREGS.dx],dx		; Save value of DX
		mov		[RMREGS.si],si		; Save value of SI
		mov		[RMREGS.di],di		; Save value of DI
		mov		ax,[flags]			; Return flags
		mov     [RMREGS.flags],ax	; Save flags
		and		ax,1h				; Isolate carry flag
		mov		[RMREGS.cflag],ax	; Save carry flag status
		mov		ax,[bxVal]
		mov     [RMREGS.bx],ax		; Save value of BX

		pop		es
		pop		ds
		leave_c
		ret

procend		_PM_callRealMode

endif
endif
endif

if flatmodel

;----------------------------------------------------------------------------
; unsigned char PM_getByte(unsigned s, unsigned o)
;----------------------------------------------------------------------------
procstart	_PM_getByte

		ARG		s:UINT, o:UINT

		push	ebp
		mov		ebp,esp
		push    ds

		mov		ax,[WORD s]
		mov		ds,ax
		mov     eax,[o]
		mov		al,[eax]

		pop		ds
		pop		ebp
		ret

procend		_PM_getByte

;----------------------------------------------------------------------------
; unsigned short PM_getWord(unsigned s, unsigned o)
;----------------------------------------------------------------------------
procstart	_PM_getWord

		ARG		s:UINT, o:UINT

		push	ebp
		mov		ebp,esp
		push    ds

		mov		ax,[WORD s]
		mov		ds,ax
		mov     eax,[o]
		mov		ax,[eax]

		pop		ds
		pop		ebp
		ret

procend		_PM_getWord

;----------------------------------------------------------------------------
; unsigned long PM_getLong(unsigned s, unsigned o)
;----------------------------------------------------------------------------
procstart	_PM_getLong

		ARG		s:UINT, o:UINT

		push	ebp
		mov		ebp,esp
		push    ds

		mov		ax,[WORD s]
		mov		ds,ax
		mov     eax,[o]
		mov		eax,[eax]

		pop		ds
		pop		ebp
		ret

procend		_PM_getLong

;----------------------------------------------------------------------------
; void PM_setByte(unsigned s, unsigned o,unsigned char v)
;----------------------------------------------------------------------------
procstart	_PM_setByte

		ARG		s:UINT, o:UINT, v:UCHAR

		push	ebp
		mov		ebp,esp
		push    ds

		mov		ax,[WORD s]
		mov		ds,ax
		mov     edx,[o]
		mov		al,[v]
		mov		[edx],al

		pop		ds
		pop		ebp
		ret

procend		_PM_setByte

;----------------------------------------------------------------------------
; void PM_setWord(unsigned s, unsigned o,unsigned short v)
;----------------------------------------------------------------------------
procstart	_PM_setWord

		ARG		s:UINT, o:UINT, v:USHORT

		push	ebp
		mov		ebp,esp
		push    ds

		mov		ax,[WORD s]
		mov		ds,ax
		mov     edx,[o]
		mov		ax,[v]
		mov		[edx],ax

		pop		ds
		pop		ebp
		ret

procend		_PM_setWord

;----------------------------------------------------------------------------
; void PM_setLong(unsigned s, unsigned o,unsigned long v)
;----------------------------------------------------------------------------
procstart	_PM_setLong

		ARG		s:UINT, o:UINT, v:ULONG

		push	ebp
		mov		ebp,esp
		push    ds

		mov		ax,[WORD s]
		mov		ds,ax
		mov     edx,[o]
		mov		eax,[v]
		mov		[edx],eax

		pop		ds
		pop		ebp
		ret

procend		_PM_setLong

;----------------------------------------------------------------------------
; void PM_memcpynf(void *dst,unsigned src_s,unsigned src_o,unsigned n)
;----------------------------------------------------------------------------
; Copies a block of memory from a far memory block to a near memory block.
;----------------------------------------------------------------------------
procstart	_PM_memcpynf

		ARG		dst:DPTR, src_s:UINT, src_o:UINT, n:UINT

		enter_c	0
		push	ds

		force_es_eq_ds			; Force ES == DS
		mov		edi,[dst]		; ES:EDI -> destination memory block
		mov		ax,[WORD src_s]
		mov     ds,ax
		mov		esi,[src_o]		; DS:ESI -> source memory block
		mov		ecx,[n]

		shr		ecx,1
	rep	movsw
		adc		ecx,ecx
	rep	movsb

		pop		ds
        leave_c_nolocal
		ret

procend		_PM_memcpynf

;----------------------------------------------------------------------------
; void PM_memcpyfn(unsigned dst_s,unsigned dst_o,void *src,unsigned n)
;----------------------------------------------------------------------------
; Copies a block of memory from a near memory block to a far memory block.
;----------------------------------------------------------------------------
procstart	_PM_memcpyfn

		ARG		dst_s:UINT, dst_o:UINT, src:DPTR, n:UINT

		enter_c	0
		push	es

		mov		esi,[src]		; DS:ESI -> source memory block
		mov		ax,[WORD dst_s]
		mov     es,ax
		mov		edi,[dst_o]		; ES:EDI -> source memory block
		mov		ecx,[n]

		shr		ecx,1
	rep	movsw
		adc		ecx,ecx
	rep	movsb

		pop		es
        leave_c_nolocal
		ret

procend		_PM_memcpyfn

;----------------------------------------------------------------------------
; void PM_segread(PMSREGS *sregs)
;----------------------------------------------------------------------------
; Read the current value of all segment registers
;----------------------------------------------------------------------------
procstart	_PM_segread

		ARG		sregs:DPTR

		enter_c	0

		mov		eax,[sregs]
		mov		[eax],es
		mov		[eax+2],cs
		mov		[eax+4],ss
		mov		[eax+6],ds
		mov		[eax+8],fs
		mov		[eax+10],gs

		leave_c_nolocal
		ret

procend		_PM_segread

; Create a table of the 256 different interrupt calls that we can jump
; into

intno = 0

intTable:
		REPT    256
		db      0CDh
		db      intno
intno = intno + 1
		ret
		nop
		ENDM

PROC genInt near

		push	eax						; Save eax
		push	ebx                 	; Save ebx
		mov    	ebx,[DWORD esp+12]		; EBX := interrupt number
		mov     eax,offset intTable		; Point to interrupt generation table
		shl     ebx,2					; EBX := index into table
		add     eax,ebx					; EAX := pointer to interrupt code
		xchg	eax,[esp+4]				; Restore eax, and set for int
		pop		ebx						; restore ebx
		ret

ENDP genInt

;----------------------------------------------------------------------------
; int PM_int386x(int intno, PMREGS *in, PMREGS *out,PMSREGS *sregs)
;----------------------------------------------------------------------------
; Issues a software interrupt in protected mode. This routine has been
; written to allow user programs to load CS and DS with different values
; other than the default.
;----------------------------------------------------------------------------
procstart	_PM_int386x

		ARG		intno:UINT, inptr:DPTR, outptr:DPTR, sregs:DPTR

		LOCAL	flags:ULONG, sv_ds:UINT, sv_esi:ULONG = LocalSize

		enter_c	LocalSize
		push	es					; Save segment registers
		push	fs
		push	gs

		mov		eax,[sregs]			; Load segment registers
		mov		es,[eax]
		mov		bx,[eax+6]
		movzx	ebx,bx
		mov		[sv_ds],ebx			; Save value of user DS on stack
		mov		fs,[eax+8]
		mov		gs,[eax+10]

		mov		esi,[inptr]			; Load CPU registers
		mov     eax,[esi]
		mov		ebx,[esi+4]
		mov		ecx,[esi+8]
		mov		edx,[esi+12]
		mov     edi,[esi+20]
		mov		esi,[esi+16]

		push	ds					; Save value of DS
		push	ebp					; Some interrupts trash this!
		clc							; Generate the interrupt
		push	[intno]
		mov		ds,[WORD sv_ds]		; Set value of user's DS selector
		call	genInt
		pop		ebp					; Pop intno from stack (flags unchanged)
		pop		ebp					; Restore value of stack frame pointer
		pop		ds					; Restore value of DS

		pushf                       ; Save flags for later
		pop		[flags]
		push	esi					; Save ESI for later
		pop		[sv_esi]
		push	ds					; Save DS for later
		pop		[sv_ds]

		mov		esi,[outptr]		; Save CPU registers
		mov     [esi],eax
		mov		[esi+4],ebx
		mov		[esi+8],ecx
		mov		[esi+12],edx
		push	[sv_esi]
		pop		[DWORD esi+16]
		mov     [esi+20],edi

		mov		ebx,[flags]			; Return flags
		mov     [esi+28],ebx		; Save flags
		and		ebx,1h				; Isolate carry flag
		mov		[esi+24],ebx		; Save carry flag status

		mov		esi,[sregs]			; Save segment registers
		mov		[esi],es
		mov		ebx,[sv_ds]
		mov		[esi+6],bx			; Get returned DS from stack
		mov		[esi+8],fs
		mov		[esi+10],gs

		pop		gs					; Restore segment registers
		pop		fs
		pop		es
		leave_c
		ret

procend		_PM_int386x

ifdef	TNT

;----------------------------------------------------------------------------
; unsigned _PL_allocsel(void)
;----------------------------------------------------------------------------
; Allocate am empty segment selector with Phar Lap (there is no C based
; API for doing this in a compiler portable manner).
;----------------------------------------------------------------------------
procstart	__PL_allocsel

		mov		ah,48h			; Allocate memory service
		xor		ebx,ebx			; EBX := 0 pages to allocate
		int		21h
		jc		@@Fail
		and		eax,0FFFFh		; EAX := segment selector
		ret

@@Fail: xor		eax,eax
		ret

procend		__PL_allocsel

endif

endif

ife flatmodel
_PM_savedDS		dw	DGROUP			; Saved value of DS
endif

;----------------------------------------------------------------------------
; void PM_saveDS(void)
;----------------------------------------------------------------------------
; Save the value of DS into a section of the code segment, so that we can
; quickly load this value at a later date in the PM_loadDS() routine from
; inside interrupt handlers etc. The method to do this is different
; depending on the DOS extender being used.
;----------------------------------------------------------------------------
procstart	_PM_saveDS

if		flatmodel
		mov		[_PM_savedDS],ds	; Store away in data segment
endif
		ret

procend		_PM_saveDS

;----------------------------------------------------------------------------
; void PM_loadDS(void)
;----------------------------------------------------------------------------
; Routine to load the DS register with the default value for the current
; DOS extender. Only the DS register is loaded, not the ES register, so
; if you wish to call C code, you will need to also load the ES register
; in 32 bit protected mode.
;----------------------------------------------------------------------------
procstart	_PM_loadDS

		mov		ds,[cs:_PM_savedDS]	; We can access the proper DS through CS
		ret

procend		_PM_loadDS

endcodeseg  _pmlite

		END						; End of module
