                               PAGE    ,132
                                TITLE   Protected mode programming #2

                                .286P

MakeDescriptor  MACRO   Limit,BaseHword,BaseLbyte,Access
                Dw      Limit
                Dw      BaseHword
                Db      BaseLbyte
                Db      Access
                Dw      0
                ENDM

Descriptor      STRUC
Lim             Dw      ?               ; Limit
BaseW           Dw      ?               ; Base address high
BaseB           Db      ?               ; Base address low (byte)
Acc             Db      ?               ; Access bytes right
                Dw      0               ; Reserved
Descriptor      ENDS


; Access rights typical equates
CODE_SEGMENT    EQU     10011011b       ; Code Segmnet Access Byte
DATA_SEGMENT    EQU     10010011b       ; Data Segment Access byte
TRAP_GATE       EQU     10000111b       ; Trap gate
INT_GATE        EQU     10000110b       ; Interrupt gate access

Null_Selector           EQU     0h      ;
Gdt_Alias_Selector      EQU     8h      ;
Idt_Alias_Selector      EQU     10h     ;
Ds_Selector             EQU     18h     ;
Es_Selector             EQU     20h     ;
Ss_Selector             EQU     28h     ;
Main_Code_Selector      EQU     30h     ;
BiosCs_Selector         EQU     38h     ;
Int_Code_Selector       EQU     40h     ;

GDT             Segment
;=============================================================================;
; The GDT.                                                                    ;
;=============================================================================;
Gdt_Start       LABEL   BYTE
MakeDescriptor  0,0,0,0                     ; Null descriptor
MakeDescriptor  Gdt_End,0,0,DATA_SEGMENT    ; Gdt Alias
MakeDescriptor  Idt_End,0,0,DATA_SEGMENT    ; IDT Alias
MakeDescriptor  0,0,0,DATA_SEGMENT          ; Ds Descriptor
MakeDescriptor  4000h,8000h,0Bh,DATA_SEGMENT; Es (Color Screen)
MakeDescriptor  0,0,0,DATA_SEGMENT          ; Stack
MakeDescriptor  0,0,0,CODE_SEGMENT          ; Code to execute
MakeDescriptor  0,0,0,CODE_SEGMENT          ; Bios Temp
MakeDescriptor  0,0,0,CODE_SEGMENT          ; Ex/Int code seg
Gdt_End         LABEL   BYTE
GDT             Ends

IDT             Segment
;=============================================================================;
; The IDT.                                                                    ;
;=============================================================================;
Idt_Start       LABEL   BYTE
MakeDescriptor  I00,Int_Code_Selector,0,TRAP_GATE ; divide by 0
MakeDescriptor  I01,Int_Code_Selector,0,TRAP_GATE ; Single Step
MakeDescriptor  I02,Int_Code_Selector,0,INT_GATE  ; NMI
MakeDescriptor  I03,Int_Code_Selector,0,TRAP_GATE ; Breakpoint trap
MakeDescriptor  I04,Int_Code_Selector,0,TRAP_GATE ; INTO trap
MakeDescriptor  I05,Int_Code_Selector,0,TRAP_GATE ; BOUNDS trap
MakeDescriptor  I06,Int_Code_Selector,0,TRAP_GATE ; Invalid Opcode
MakeDescriptor  I07,Int_Code_Selector,0,TRAP_GATE ; Math Cp Not Avail
MakeDescriptor  I08,Int_Code_Selector,0,TRAP_GATE ; Double Fault
MakeDescriptor  I09,Int_Code_Selector,0,TRAP_GATE ; Cp operand past lim
MakeDescriptor  I0A,Int_Code_Selector,0,TRAP_GATE ; Invalid TSS
MakeDescriptor  I0B,Int_Code_Selector,0,TRAP_GATE ; Cs,Ds,Es Not Present
MakeDescriptor  I0C,Int_Code_Selector,0,TRAP_GATE ; Ss not present
MakeDescriptor  I0D,Int_Code_Selector,0,TRAP_GATE ; Gen Prot Violation
MakeDescriptor  0,0,0,0                           ; Reserved
MakeDescriptor  0,0,0,0                           ; Reserved
MakeDescriptor  I10,Int_Code_Selector,0,TRAP_GATE ; Calculation error x287
                Db  (32-17)*8 Dup(0)              ; 17-31 reserved/unused
MakeDescriptor  I20,Int_Code_Selector,0,INT_GATE  ; Int 20h
MakeDescriptor  I21,Int_Code_Selector,0,INT_GATE  ; Int 21h
MakeDescriptor  I22,Int_Code_Selector,0,INT_GATE  ; Int 22h
MakeDescriptor  I23,Int_Code_Selector,0,INT_GATE  ; Int 23h
MakeDescriptor  I24,Int_Code_Selector,0,INT_GATE  ; Int 24h
MakeDescriptor  I24,Int_Code_Selector,0,INT_GATE  ; Int 25h
MakeDescriptor  I26,Int_Code_Selector,0,INT_GATE  ; Int 26h
MakeDescriptor  I27,Int_Code_Selector,0,INT_GATE  ; Int 27h
                Db  (64-40)*8 Dup(0)              ;
Idt_End         LABEL   BYTE
IDT             Ends


Int_Seg         Segment
;=============================================================================;
; This is where all the interruptts go to!!                                   ;
;=============================================================================;
                Assume  Cs:Int_Seg

I00:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'0'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I01:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'1'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I02:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'2'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I03:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'3'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I04:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'4'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I05:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'5'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I06:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'6'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I07:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'7'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I08:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'8'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I09:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'9'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I0A:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'A'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I0B:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'B'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I0C:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'C'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I0D:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'D'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I10:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'Q'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I20:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'R'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I21:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'S'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I22:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'T'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I23:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'V'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I24:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'W'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I25:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'X'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I26:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'Y'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

I27:
                Mov     Ax,Es_Selector          ;
                Mov     Es,Ax                   ; Make the screen acessable
                Mov     Al,'Z'                  ; Int  number calling
                Mov     Ah,7                    ;
                Mov     Di,0                    ;
                Cld                             ;
                Stosw                           ;
                Iret                            ; Back!!

End_Of_Ints     EQU $
Int_Seg         Ends


Run_Code        Segment PARA    PUBLIC  'EXEC'
;=============================================================================;
; This is where control is transfered to in Prot. Mode.                       ;
;=============================================================================;
                    Assume  Cs:Run_Code

Msg1        db      'Have entered protected mode',0

Initialize:         Mov     Ax,GDT              ; Get segment of GDT table
                    Mov     Es,Ax               ; ES Contains the GDT
                    Mov     Ds,Ax               ;
                    Call    Make_24bit          ; Do it
                    Mov     Di,Gdt_Alias_Selector      ; Get the selector
                    Mov     BaseW[Di],Dx        ; Base segmemnt of GDT
                    Mov     BaseB[Di],Al        ;
                    Mov     Ax,IDT              ; The IDT setup
                    Call    Make_24bit          ;
                    Mov     Di,Idt_Alias_Selector       ; Get it
                    Mov     BaseW[Di],Dx        ;
                    Mov     BaseB[Di],Al        ;
                    Mov     Ax,Cs               ; Get the Thing here
                    Call    Make_24bit          ;
                    Mov     Di,Main_Code_Selector       ; Get this
                    Mov     BaseW[Di],Dx        ;
                    Mov     BaseB[Di],Al        ;
                    Lea     Si,Main_Code_End    ;
                    Mov     Lim[Di],Si          ; Limit on main code
                    Mov     Di,Es_Selector      ;
                    Mov     BaseW[Di],Dx        ;
                    Mov     BaseB[Di],Al        ;
                    Mov     Lim[Di],Si          ;
                    Mov     Di,Ds_Selector      ;
                    Mov     BaseW[Di],Dx        ;
                    Mov     BaseB[Di],Al        ;
                    Mov     Lim[Di],Si          ;
                    Mov     Ax,StackSeg         ;
                    Call    Make_24bit          ;
                    Mov     Di,Ss_Selector      ;
                    Mov     BaseW[Di],Dx        ;
                    Mov     BaseB[Di],Al        ;
                    Lea     Si,TOS              ;
                    Mov     Lim[Di],Si          ;
                    Mov     Ax,Int_Seg          ; Get the interrupt segment
                    Call    Make_24bit          ; Do it
                    Mov     Di,Int_Code_Selector        ;
                    Mov     BaseW[Di],Dx        ;
                    Mov     BaseB[Di],Al        ;
                    Lea     Si,End_Of_Ints      ;
                    Mov     Lim[Di],Si          ;
                                                ;
                    Mov     Ah,89h              ; Call to do it
                    Mov     Al,0                ;
                    Mov     Bx,40h              ;
                    Xor     Si,Si               ;
                    Int     15h                 ; By By!!

Main_Program:       Sti                         ;
                    Mov     Di,0                ;
                    Lea     Si,Msg1             ;
                    Cld                         ;
                    Mov     Ah,07h              ;
Tl1:                Lodsb                       ;
                    Cmp     Al,0                ;
                    Je      Done                ;
                    Stosw                       ;
                    Jmp     Tl1                 ;
Done:                                           ;
                                                ;
Forever:            Jmp     Forever             ; Loop Forever


Make_24bit          PROC    near
;-----------------------------------------------------------------------------;
; Makes a 24 bit address retrned in DX (The word) and Al (The byte)           ;
; Receives a 16 bit num,ber in AX to convert!.                                ;
;-----------------------------------------------------------------------------;
                    Push    Bx                  ;
                    Push    Cx                  ;
                    Mov     Dx,Ax               ;
                    Mov     Bx,0F000h           ; The Mask
                    Mov     Cl,4                ; The shift
                    And     Ax,Bx               ; The upper 4 bits here
                    Not     Bx                  ; Flip
                    And     Dx,Bx               ; The lower here
                    Rol     Ax,Cl               ; Rotate (Upper byte)
                    Shl     Dx,Cl               ; This (Lower word)
                    Pop     Cx                  ;
                    Pop     Bx                  ;
                    Ret
Make_24bit          Endp


InitialEntry:       Jmp     Initialize          ; Go initialize things
Main_Code_End       EQU     $
Run_Code            Ends



StackSeg            Segment PARA    STACK   'STACK'
                    Db  1024    DUP(0)
TOS EQU $
StackSeg            ENDS


                End     InitialEntry
