                            PAGE  ,132
                            Title Protected Mode Programming for the PC-AT
                            subttl Version 3.0 ( or 1.3 )
                            .286P

; DATA STRUCTURE DEFINITIONS

DESCRIP     STRUC             ; Standard Descriptor
  limit           Dw    ?     ; Limit of Segment
  phys_addr_lo    Dw    ?     ; Physical 24bit address (LO WORD)
  phys_addr_hi    Db    ?     ; Physical 24bit address (HI BYTE)
  access          Db    ?     ; Access Rights Byte
                  Dw    0     ; Reserved 0 for compatability between 286-386
DESCRIP     ENDS

TSS_BLOCK   STRUC             ; Task State Segment Descriptor
  back_link       Dw    ?     ; Link To Previous active TSS
  rSP0            Dw    ?     ; Level 0 Stack
  rSS0            Dw    ?     ;
  rSP1            Dw    ?     ; Level 1 Stack
  rSS1            Dw    ?     ;
  rSP2            Dw    ?     ; Level 2 Stack
  rSS2            Dw    ?     ;
  rIP             Dw    ?     ; Instruction Pointer
  FLAGS           Dw    ?     ;
  rAX             Dw    ?     ;
  rCX             Dw    ?     ;
  rDX             Dw    ?     ;
  rBX             Dw    ?     ;
  rSP             Dw    ?     ;
  rBP             Dw    ?     ;
  rSI             Dw    ?     ;
  rDI             Dw    ?     ;
  rES             Dw    ?     ;
  rCS             Dw    ?     ;
  rSS             Dw    ?     ; Active Stack Seg Sel
  rDS             Dw    ?     ;
  task_LDT        Dw    ?     ; LDT Selector
TSS_BLOCK   ENDS


TSS         EQU   1           ; Gate Types
LDT         EQU   2
TSS_BUSY    EQU   3
CALL_GATE   EQU   4
TASK_GATE   EQU   5
INT_GATE    EQU   6
TRAP_GATE   EQU   7
RDONLY      EQU   0           ; Segment Types
RD_WR       EQU   1           ; Read/Write
RD_WR_XD    EQU   3           ; Read/Write Expand Down
EXONLY      EQU   4           ; Exec Only
EX_RD       EQU   5           ; Execute/Readable
EXONLY_CF   EQU   6           ; Execute Only -- Conforming
EX_RD_CF    EQU   7           ; Exec/Readable -- Conforming
TSS_LIMIT   EQU   43          ; Just a num


MSEG        MACRO     name, type, priv, combine   ;; Start a MEM Segment
name        SEGMENT   PARA  combine               ;; Directive
zero = $                                          ;; For ALIGN
&name&_start = $                                  ;; Origin
&name&_ar = 90h OR (priv SHL 5) OR (type SHL 1)   ;; Access rights Byte
            ENDM

SSEG        MACRO     name, type, priv            ;; Start a SYS Segment
name        SEGMENT   PARA                        ;; Directive
zero = $                                          ;; For ALIGN
&name&_start = $                                  ;; Origin
&name&_ar = 80h OR (priv SHL 5) OR type           ;; Access rights Byte

ENDSEG      MACRO     name                        ;; Terminate a segment
&name&_limit = $ - &name&_start - 1               ;; Create VAR for Seg Limit
name        ENDS                                  ;; End it
            ENDM
 
; Descriptor Building Macros

DSCRP       MACRO     export,name                 ;; Build descript for a seg
            IFDIF     <export>,<>                 ;; Check for export name
export      LABEL     WORD
            ENDIF
            Dw        &name&_limit                ;; Segment Limit
            Dw        name                        ;; 16 bit seg address
            Db        0                           ;; Hi address
            Db        &name&_ar                   ;; Access rights
            Dw        0                           ;; Reserved
            ENDM


GATE        MACRO     export,offset,select,ex,type,priv   ;; Build descr.
            IFDIF     export,<>                   ;; Check export name
export      LABEL     WORD                        ;;
            ENDIF
            Dw        offset                      ;; Offset
            Dw        Select                      ;; Segment Selector
            Db        wc                          ;; Word Count
            Db        80h OR (priv SHL 5) + type  ;; Access rights
            Dw        0                           ;; Reserved
            ENDM


; Selector creating macros for Task segments
GDT_SEL     MACRO     sel,priv                    ;;
            Dw        sel + priv                  ;; Assume sel=index*8
            ENDM

LDT_SEL     MACRO     sel,priv
            Dw        sel + 4 + priv              ;; Like GDT but TI bit set
            ENDM

; Utility macros
CALL_EX     MACRO     sel,rpl                     ;; Call Exported Item
            Db        9Ah                         ;; FAR CALL
            Dw        0                           ;; No Offset
            Dw        sel + rpl                   ;; Selector with required pr
            ENDM

            PAGE
; This Segment contains the Global Descriptor Table
            MSEG      GDT,RD_WR,0

; Required by INT 15h
DESCRIP     <0,0,0,0>                       ; GDT(0) -- Always Blank
DSCRP       int15_gdt_dat,GDT               ; Data -> GDT
DSCRP       int15_idt_dat,IDT               ; DATA -> IDT
DSCRP       ,DSC                            ; Data -> Ds
DSCRP       ,DSC                            ; Data -> Es
DSCRP       ,DSC                            ; Stack -> SS
DESCRIP     <0,0,0,0>                       ; CODE -> BIOS (int 15 res.)
DSCRP       setup_tss,INIT_TSS              ; TSS initial stack
; mini BIOS
DSCRP       bio_dat,MBDAT                   ; DATA -> Mini BIOS
DSCRP       bios_seg,BIOS                   ; CODE -> Mini BIOS
DSCRP       disp_mono,MONO_RAM              ; DATA -> Monochrome Display
DSCRP       disp_color,COLOR_RAM            ; DATA -> Color Display
; Fault Handlers
DSCRP       task_df,FTASK8                  ; TSS -> Double Fault
xtra8       DESCRIP <ftask8_limit,FTASK8,0,92h> ; Writable Data Alias for TSS
DSCRP       task_tf,FTASK10                 ; TSS -> Task Fault



