program protected_mode_and_back;
{$u-,k-}

{ Beeps once (low tone) }

CONST
  gdt_size = 8;  { Max number of desc. m 1 }
  idt_size = 13;
  code_desc = 48;

  data_seg : INTEGER = 0;
  stack_seg: INTEGER = 0;
  extra_seg: INTEGER = 0;

TYPE
  descriptor = RECORD
    seg_limit       : INTEGER;
    base_lo_word    : INTEGER;
    base_hi_byte    : BYTE;
    data_acc_rights : BYTE;
    data_reserved   : INTEGER;
  END;

  string80 = string[80];

VAR
  gdt  :  array[0..gdt_size] of descriptor;
  idt  :  array[0..idt_size] of descriptor;
  result : RECORD
    ax, bx, cx, dx, bp, si, di, ds, es, flags : INTEGER;
  END;
  mask1_8259, mask2_8259 : BYTE;
  screen : array[0..$2000] of byte absolute $40:0;


PROCEDURE setup_error;
  Begin                      { setup_error };
    Writeln;
    Writeln('There has been an error during setup of descriptor tables.');
    Halt;
  End                        { setup_error };


PROCEDURE Set_Gdt_Desc(num, seg_lim, base_lo : INTEGER;
                       base_hi, acc_rights : BYTE);
  Begin            { set_gdt_desc }
    If (num >= 0) AND (num <= gdt_size)
      Then
        begin
          with gdt[num] do
            begin
              seg_limit := seg_lim;
              base_lo_word := base_lo;
              base_hi_byte := base_hi;
              data_acc_rights := acc_rights;
              data_reserved := 0;
            end;  { with }
        end { then }
      Else setup_error;
  End;            { set_gdt_desc }


PROCEDURE Set_Idt_Desc(num, seg_lin, base_lo : INTEGER;
                       base_hi, acc_rights : BYTE);
{ This Procedure set up seg num in IDT }
  Begin
    If (num >= 0) AND (num <= idt_size)
      Then
        begin
          with idt[num] do
            begin
              seg_limit := seg_lim;
              base_lo_word := base_lo;
              base_hi_byte := base_hi;
              data_acc_rights := acc_rights;
              data_reserved := 0;
            end;  { with }
        end { then }
      Else setup_error;
  End;            { set_idt_desc }


PROCEDURE Beep;
  Begin
    Sound(300);
    Delay(400);
    NoSound;
    Delay(400);
  End;

PROCEDURE ErrBeep;
  Begin
    Sound(2000);
    Delay(400);
    NoSound;
    Delay(400);
  End;

PROCEDURE Fault; { Entered if a processor fault occurs while in PM }
  Begin
    ErrBeep; ErrBeep;
    { Pop The 4 words on the stack where the fault occured }
    Inline($5B/$5B/$5B/$5B);
    Port[$64] := $FE; { Return to real mode }
    Inline($F4); { Simply halt the system }
  End;


PROCEDURE Setup_Idt; { Load IDT with appropriate values }
  Var
    X : INTEGER;
  Begin
    Set_Idt_Desc(0,Ofs(Fault)+7,Code_Desc,0,$86);
    Set_Idt_Desc(1,Ofs(Fault)+7,Code_Desc,0,$86);
    Set_Idt_Desc(2,Ofs(Fault)+7,Code_Desc,0,$86);
    Set_Idt_Desc(3,Ofs(Fault)+7,Code_Desc,0,$86);
    Set_Idt_Desc(4,Ofs(Fault)+7,Code_Desc,0,$86);
    Set_Idt_Desc(5,Ofs(Fault)+7,Code_Desc,0,$86);
    Set_Idt_Desc(6,Ofs(Fault)+7,Code_Desc,0,$86);
    Set_Idt_Desc(7,Ofs(Fault)+7,Code_Desc,0,$86);
    Set_Idt_Desc(8,Ofs(Fault)+7,Code_Desc,0,$86);
    Set_Idt_Desc(9,Ofs(Fault)+7,Code_Desc,0,$86);
    Set_Idt_Desc(10,Ofs(Fault)+7,Code_Desc,0,$86);
    Set_Idt_Desc(11,Ofs(Fault)+7,Code_Desc,0,$86);
    Set_Idt_Desc(12,Ofs(Fault)+7,Code_Desc,0,$86);
    Set_Idt_Desc(13,Ofs(Fault)+7,Code_Desc,0,$86);
  End;

PROCEDURE Addr24(Segment, Offset:INTEGER;
                 Var A24w:INTEGER; Var A24b:BYTE); { 20 bit to 24bit conv }
  Var
    X : INTEGER;
    Y : BYTE;
  Begin
    Inline(
           $8B/$86/Segment/               { Mov  Ax,Segment[Bp]            }
           $BA/$10/$00/                   { Mov  Dx,16            (4 bits) }
           $F7/$E2/                       { Mul  Dx                        }
           $03/$86/Offset/                { Add  Ax,Offset[Bp]             }
           $83/$D2/$00/                   { Adc  Dl,0                      }
           $88/$96/Y/                     { Mov  Y[Bp],Dl                  }
           $89/$86/X);                    { Mov  X[Bp],Ax                  }
    A24w := X;
    A24b := Y;
  End;



