;       Author:
;               Josiah Standing
;
;       Purpose:
;       Illustrates how some of the Return and Call functions
;       work.
;
        .MODEL  small           ;For MASM Compatibility
                                ;(I prefer TASM's TINY Model)
        .CODE
        org     100h            ;Starting point for .COM files

start:                          ;Program entry point

                                ;Simulate calls by pushing the values
                                ;ourself.
        push    offset finish   ;Push our last address to process
                                ;on the Stack. (Function 4)
        pushf
        push    cs              ;Save 3-words for the IRET function
        push    offset get_key  ;(Function 3)
                                ;Equiv: Int ?

        push    offset print_msg2 ;Save offset address
                                  ;(Function 2)
                                ;Equiv: Call print_msg2

        push    cs
        push    offset print_msg1 ;Save 2-words for the RETF function
                                  ;(Function 1)
        retf                    ;Pop two addresses off the Stack (CS:IP)
                                ;Equiv: Call far print_msg1

get_key:                        ;(Function 3)
        lea     dx,msg3         ;Load DX with memory offset for msg3
        call    print_string    ;Display msg3

        xor     ah,ah
        int     16h             ;ROM BIOS Get Keypress function
        ret

print_msg1:                     ;(Function 1)
        lea     dx,msg1         ;Load DX with memory offset for msg1
        call    print_string    ;Display msg1
        ret                     ;Pop next address off the Stack
                                ;(IP)

print_msg2:                     ;(Function 2)
        lea     dx,msg2         ;Load DX with memory offset for msg2
        call    print_string    ;Display msg2
        iret                    ;Pop next addresses off the stack
                                ;(CS:IP,FLAGS)

finish:                         ;(Function 4)
        int     20h             ;Old DOS Terminate Program function

print_string:
        mov     ah,9            ;DOS Print string function (DX=offset of
                                ;string terminated by a dollar sign)
        int     21h
        ret                     ;Pop next address off the Stack

msg1    db      'This is a test.'
        db      0ah, 0dh, 0ah, '$'

msg2    db      'This is only a test.'
        db      0ah, 0dh, 0ah, '$'

msg3    db      'Press any key to exit:'
        db      0ah, 0dh, '$'
        end     start
