;This ASM file when assembled and linked will make SELECT.EXE which you invoke
;in a batch file as follows: SELECT abcdefg   
;where the chars that follow SELECT (the command tail) can be any combination 
;of LOWER-CASE letters. Select then waits for you to type one of the letters on ;its command tail. If the key you press is not on SELECT's command tail, it
;beeps. If the key you press is on it's command tail, select returns the
;alphabetical position of your letter  ( 'a' = 1 ). You can then use the IF
;ERRORLEVEL commands to check which letter was pressed. This is ideal for
;implementing menus in autoexec.bat or some other batch file. Don't run select
;without a command tail!

;NOTE: ALL TEXT ON A LINE IN THIS ASM FILE FOLLOWING A SEMICOLON IS A COMMENT.
;MASM WILL IGNORE ALL COMMENTS AND THEY ARE THERE TO PROVIDE EXPLANATIONS TO
;THE CODE. YOU CAN ASSEMBLE FILE AS IS.

	name select          
	page 55,78          
	title SELECT.EXE: Allows user to choose from alphabetical menu

;The above section (name, page, and title) is only useful if you want to create
;a listing file (SELECT.LST) of the program (to create a listing file type the
;name of the program when MASM prompts you: [NUL.lst]).

cr	equ	0dh      ;calling 13 'cr' (carriage return is ASCII 13 or 0Dh)
lf	equ	0ah      ;calling 10 'lf' (line feed is ASCII 10 or 0Ah [hex])
alert	equ	07h      ;calling 7 'alert' (displaying ASCII 7 sounds a beep)

_TEXT	segment word public 'CODE'  ;Defines the following as code segment.
                                     ;for now you don't need to know what 
                                     ;'word' and 'public' mean but include them

	assume	cs:_TEXT,ds:_DATA,ss:_STACK

			;The assume directive 
			;simply tells MASM where the segment registers 
  			;should be pointing. We don't plan to use ES so 
			;no need to specify it in an assume directive

select	proc	near       ;select defined as a 'near' procedure

	mov	ax,_DATA   ;initialize the ds register
	mov	ds,ax      ;you can't load ds directly with _DATA so we use ax

	mov	di,0080h   ;0080h is the location of the 'command tail' i.e.
			   ;the other info you type on the DOS line after
			   ;the name of the program. eg. in 'DEL *.com', DEL
			   ;is the name of the program and '*.com' is the tail
	mov	cl,[di]    ;move the first item of the command tail (which is
			   ;the length) into cl so you know how many chars to
			   ;read.
	mov	bx,0081h   ;now bx gets the start of the actual characters
			   ;of the command tail.


;The following loop (lab1) keeps checking the command tail until it reaches
;the 1st valid char, i.e. it skips superfluous initial spaces.
 
lab1:	mov	al,[bx]    ;al gets the next command tail character
	cmp	al,'a'     ;validate the char (see if ASCII is less than 'a')
	jnc	lab2       ;if valid escape this loop and go to lab2
	dec	cl         ;decrease count
	inc	bx         ;point to next char
	jmp	lab1       ;go back (till you find a lowercase char)

lab2:	mov	valid,bx   ;record where valid command tail starts in bx
	mov	lenval,cl  ;record the length of the valid comm. tail in cl

	mov	ah,9       ;DOS function 09h = write string to stdout
	mov	dx,offset prompt  ;dx holds offset of string (see data seg)
	int	21h        ;transfer to MS-DOS

lab3:	mov	ah,8       ;DOS function 09h = read 1 character from console
	int	21h        ;transfer to MS-DOS
	or	al,01000000b  ;if the input was upper-case, turn to lower
	mov	ch,00      
	mov	cl,lenval  ;cx contains the number of valid chars 
	mov	bx,valid   ;bx points to the start of list of valid chars

lab4:	cmp	al,[bx]    ;check the input against this valid char
	jz	found      ;if the same, exit this loop
	inc	bx         ;if not point to the next valid char
	loop	lab4       ;and try again... 

	mov	dl,alert   ;all valid chars checked but input is neither
	   		   ;so ascii for "beep speaker" placed in dl
	mov	ah,2       ;DOS function 02h = send character to console
	int	21h        ;transfer to DOS (beep signals user of wrong input)
	jmp	lab3       ;go back, get new input, and check it again

found:	mov	dl,al      ;place the entered character in dl
	push	ax         ;save the ax reg for later
	mov	ah,2       ;DOS function 02h = send character to console
	int	21h        ;transfer to MS-DOS
	mov	dl,cr      ;
	mov	ah,2       ;
	int	21h        ;now send a carriage return...
	mov	dl,lf      ;
	mov	ah,2       ;
	int	21h        ;now send a line feed...   and we're dond
	pop	ax         ;restore the ax register
	sub	al,60h     ;96 decimal= 'a'-1. This reduces the char to it's
			   ;alphabetical position.
	mov	ah,4ch     ;DOS function 4Ch = end process and return the 
			   ;errorlevel in al
	int	21h        ;transfer to MS-DOS  (this time for good!  :D   )

select	endp		   ;end of "select" procedure (which the only one)

_TEXT	ends		   ;end of "_TEXT" segment

_DATA	segment word public 'DATA'     ;this is the data segment

prompt	db	'Choose an option please: ','$'   ;this is the prompt string
					          ;that's printed in procedure
					          ;select (see)
lenval	db	0	;this memory location stores the commad tail length
valid	dw	0       ;this mem loc stores the start of the command tail

			;both locations initialised to 0

_DATA	ends		;that's all for the data segment!

_STACK	segment para stack 'STACK'      ;the important stack segment...

	db 128 dup (?)  ;just reserve 128 bytes of memory (though select needs
			;hardly more than 64 bytes for the DOS calls.
			;the question mark prevents select from initialising
			;all the stack memory to 0 or some other number that
                         ;would otherwise go in the parenthesis.

_STACK	ends		;stack segment finished!

	end	select  ;that's all folks. Start execution at procedure select

