$EVENT OFF
SCREEN 0 : CLS

'MEMSET ENDMEM-131072

DEFINT A-Z
DIM PO(255),IO(255),RI(255),AA(255),FF(255),PC$(63),Offset(22)

DEF SEG = &H8000

FOR a = 0 TO 12000
  POKE a,0
NEXT a

BLOAD "rules.bin",0

FOR a=6000 TO 12000
  IF PEEK(a) = 0 THEN
     IF PEEK(a+1)=0 AND PEEK(a+2)=0 AND PEEK(a+3)=0 AND PEEK(a+4)=0 THEN
        EXIT FOR
     END IF
  END IF
NEXT a

SaveFlag = %False
TableLength = a		'Length of Rule Table

Left = 1 : Right = 4 : LRFlag = 0 : qq=0
CrLf$ = CHR$(&H0D)+CHR$(&H0A)
%AX = 1
%BX = 2
%CX = 3
%DX = 4

'Ŀ

PA = 0   :  E = 1    :  E1 = 2   :  Y = 3    :  Y1 = 4  :  AY = 5
IE = 6   :  I = 7    :  A = 8    :  A1 = 9   :  EH = 10 :  EH1 = 11
AE = 12  :  AE1 = 13 :  AH = 14  :  AH1 = 15 :  AW = 16 :  O = 17
OU = 18  :  OO = 19  :  IU = 20  :  IU1 = 21 :  U = 22  :  U1 = 23
UH = 24  :  UH1 = 25 :  UH2 = 26 :  UH3 = 27 :  ER = 28 :  R = 29
R1 = 30  :  R2 = 31  :  L = 32   :  L1 = 33  :  LF = 34 :  W = 35
B = 36   :  D = 37   :  KV = 38  :  P = 39   :  T = 40  :  K = 41
HV = 42  :  HVC = 43 :  HF = 44  :  HFC = 45 :  HN = 46 :  Z = 47
S = 48   :  J = 49   :  SCH = 50 :  V = 51   :  F = 52  :  THV = 53
TH = 54  :  M = 55   :  N = 56   :  NG = 57  :  A2 = 58 :  OH = 59
U2 = 60  :  UH4 = 61 :  E2 = 62  :  LB = 63

FOR a=0 TO 63
READ PC$(a)
NEXT a

DATA "PA","E","E1","Y","Y1","AY","IE","I","A","A1","EH","EH1"
DATA "AE","AE1","AH","AH1","AW","O","OU","OO","IU","IU1","U"
DATA "U1","UH","UH1","UH2","UH3","ER","R","R1","R2","L","L1"
DATA "LF","W","B","D","KV","P","T","K","HV","HVC","HF","HFC"
DATA "HN","Z","S","J","SCH","V","F","THV","TH","M","N","NG"
DATA "A2","OH","U2","UH4","E2","LB"

'Ŀ
CALL MainMenu
RulePtr& = (ASC("A")-65) * 3
RulePtr& = (PEEK(RulePtr&+2)*256)+PEEK(RulePtr&+1)
RuleChar = 65
FirstRulePtr& = RulePtr&
ScrnLine = 0

CALL DispRule
CALL HighLight(0)

ReportKey:
CALL ReadKBD(Ch$)
CALL IBMCh(Ch$)
IF (asc(Ch$)<>0) OR LEN(Ch$)<>2 THEN GOTO ReportKey
  SELECT CASE asc(MID$(Ch$,2,1))
    CASE 5	'Up Arrow
      IF ScrnLine > 0 THEN
         CALL UnHighLight(ScrnLine)
         DECR ScrnLine
         CALL HighLight(ScrnLine)
      END IF
    CASE 24	'Down Arrow
      IF ScrnLine < 19 THEN
         CALL UnHighLight(ScrnLine)
         INCR ScrnLine
         CALL HighLight(ScrnLine)
      END IF
    CASE 73	'PgUp
      RulePtr& = FirstRulePtr&
      CALL DispRule
    CASE 81	'PgDn
      IF PEEK(RulePtr&) <> ASC("[") THEN
         CALL DispRule
      END IF

    CASE 60	'F2 - Select SubTable
      LOCATE 13,50,1
      INPUT "SubTable : ",ST$
      ST$ = UCASE$(ST$)
      IF ST$ = "" OR ST$ = "BLANK" THEN RulePtr& = 26 * 3 : GOTO CalcIt
      RuleChar = ASC(ST$)
      RulePtr& = (ASC(ST$)-65) * 3
    CalcIt:
      RulePtr& = (PEEK(RulePtr&+2)*256)+PEEK(RulePtr&+1)
      FirstRulePtr& = RulePtr&
      ScrnLine = 0
      CALL DispRule
      CALL HighLight(0)

    CASE 82	'Ins - Insert Rule
      SaveFlag = %True
      NewRule$ = CHR$(RuleChar)+"<!>!="
      NewPC$(0)  = "PA"
      NewPC(0)   =  0
      NewDur(0)  =  0
      NewFF(0)   =  231
      NewArt(0)  =  7
      NewAmp(0)  =  5
      NewRate(0) =  10
      NewInfl(0) =  2880
      FOR nn = TableLength TO Offset(ScrnLine) STEP-1
        POKE nn+12,PEEK(nn)
      NEXT nn
      aa=0
      FOR nn = 1 TO LEN(NewRule$)
        POKE Offset(ScrnLine)+aa,asc(MID$(NewRule$,nn,1))
        INCR aa
      NEXT nn
      POKE Offset(ScrnLine)+6,NewPC(0) + (NewDur(0)*64)
      POKE Offset(ScrnLine)+7,NewFF(0)
      POKE Offset(ScrnLine)+8,NewAmp(0) + (NewArt(0)*16)
      IF NewInfl(0) => 2048 THEN MInfl = 8 ELSE MInfl = 0
      POKE Offset(ScrnLine)+9,((NewRate(0)*16)+MInfl+(NewInfl(0) AND 7))
      POKE Offset(ScrnLine)+10,(NewInfl(0) AND 2040)\8
      POKE Offset(ScrnLine)+11,asc("@")
      INCR RuleChar
      CALL AddDisp(12)
      DECR RuleChar
      RulePtr& = (RuleChar-65) * 3
      RulePtr& = (PEEK(RulePtr&+2)*256)+PEEK(RulePtr&+1)
      CALL DispRule

    CASE 83	'DEL - Delete Rule
      SaveFlag = %True
      Diff = Offset(ScrnLine+1) - Offset(ScrnLine)
      FOR nn = Offset(ScrnLine) TO TableLength
        POKE nn,PEEK(nn+Diff)
      NEXT nn
      INCR RuleChar
      CALL SubDisp(Diff)
      DECR RuleChar
      RulePtr& = (RuleChar-65) * 3
      RulePtr& = (PEEK(RulePtr&+2)*256)+PEEK(RulePtr&+1)
      CALL DispRule

    CASE 64	'F6 - Text Mode
      GetTextAgain:
      CLS : COLOR 4,0
      GOSUB GetText
      PRINT : PRINT "Press Any Key...."
      INPUT ,Answer$
'      IF Answer$ <> CHR$(27) THEN GOTO GetTextAgain
      CALL MainMenu
      Tmp = ScrnLine
      RulePtr& = Offset(0)
      CALL DispRule
      CALL UnHighLight(0)
      CALL HighLight(Tmp)
      ScrnLine = Tmp

    CASE 65	'F7 - Save Rule Table
      IF SaveFlag = %True THEN SaveFlag = %False
      BSAVE "RULES.BIN",0,TableLength

    CASE 113	'Alt-F10 - Exit to DOS
      IF SaveFlag = %True THEN
         CLS
         LOCATE 10,15
         PRINT "Rule Table has been modified and has NOT been SAVED"
         LOCATE 12,25
         INPUT "Save Modified Rule Table (y/n) ";An$
         IF UCASE$(AN$) = "Y" THEN BSAVE "RULES.BIN",0,TableLength
      END IF
         ON ERROR GOTO DumpError
         CLS
         LOCATE 10,15
         INPUT "Create Assembly Language Rule Table File (y/n) ";An$
         IF UCASE$(AN$) = "N" THEN END
            KILL "TURB_RL2.ASM"
            OPEN "TURB_RL2.ASM" FOR BINARY AS #1
            SEEK 1,0
            Start$ = ";*************"+CrLf$
            PUT$ 1,";"+CrLf$
            PUT$ 1,Start$
            PUT$ 1,"; RULE TABLE"+CrLf$
            PUT$ 1,Start$
            FOR A=65 TO 90
              IF A = 69 OR A = 79 THEN
                 PreFix$ = CHR$(A)+"0"+CHR$(9)+"="+CHR$(9)+"$-CHTBLE"+CrLf$
              ELSE
                 PreFix$ = CHR$(A)+"R"+CHR$(9)+"="+CHR$(9)+"$-CHTBLE"+CrLf$
              END IF
              PUT$ 1,PreFix$

              RulePtr& = (A-65) * 3
              RulePtr& = (PEEK(RulePtr&+2)*256)+PEEK(RulePtr&+1)

              WHILE PEEK(RulePtr&) <> ASC("[")
                Rule$ = CHR$(9)+"DB"+CHR$(9)+"'"
                WHILE PEEK(RulePtr&) <> ASC("=")
                  Rule$ = Rule$ + CHR$(PEEK(RulePtr&))
                  INCR RulePtr&
                WEND
                  Rule$ = Rule$ + "='"+CHR$(9)+";"+CrLf$
                  PUT$ 1,Rule$
                  INCR RulePtr&

                WHILE PEEK(RulePtr&+5) <> ASC("@")
                  Phon$ = CHR$(9)+"DB"+CHR$(9)
                  PCode$ = CHR$(9)+"DD"+CHR$(9)
                  PH$ = (PC$(PEEK(RulePtr&) AND 63))
                  IF PH$ = "AH" THEN PH$ = "AH0"
                  Phon$ = Phon$ + PH$ + CrLf$
                  PUT$ 1,Phon$
                  INCR RulePtr&
                  FOR B=3 TO 0 STEP-1
                    PC$ = HEX$(PEEK(RulePtr&+B))
                    IF PC$ = "0" THEN PC$ = "00"
                    PCode$ = PCode$ + PC$
                  NEXT B
                  INCR RulePtr&,4
                  PUT$ 1,PCode$+"H"+CrLf$
                WEND
                  INCR RulePtr&
                  Phon$ = CHR$(9)+"DB"+CHR$(9)
                  PCode$ = CHR$(9)+"DD"+CHR$(9)
                  PH$ = (PC$(PEEK(RulePtr&-1) AND 63))
                  IF PH$ = "AH" THEN PH$ = "AH0"
                  Phon$ = Phon$ + PH$ + CrLf$
                  PUT$ 1,Phon$
                  INCR RulePtr&
                  FOR B=3 TO 0 STEP-1
                    PC$ = HEX$(PEEK(RulePtr&-1+B))
                    IF PC$ = "0" THEN PC$ = "00"
                    PCode$ = PCode$ + PC$
                  NEXT B
                  INCR RulePtr&,4
                  PUT$ 1,PCode$+"H"+CrLf$
                  PUT$ 1,CHR$(9)+"DB"+CHR$(9)+"'@'"+CrLf$
              WEND
             PUT$ 1,CHR$(9)+"DB"+CHR$(9)+"'['"+CrLf$
            NEXT A
              PUT$ 1,"BLANK"+CHR$(9)+"="+CHR$(9)+"$-CHTBLE"+CrLf$
              PUT$ 1, CHR$(9)+"DB"+CHR$(9)+"' ='"+CHR$(9)+";"+CrLf$
              PUT$ 1, CHR$(9)+"DB"+CHR$(9)+"PA"+CHR$(9)+";"+CrLf$
              PUT$ 1, CHR$(9)+"DD"+CHR$(9)+"68A874E7H"+CrLf$
              PUT$ 1, CHR$(9)+"DB"+CHR$(9)+"'@'"+CrLf$
              PUT$ 1, CHR$(9)+"DB"+CHR$(9)+"'['"+CrLf$
              PUT$ 1,"LAST"+CHR$(9)+"="+CHR$(9)+"$"+CrLf$
              PUT$ 1,";"+CrLf$
              CLOSE #1
            END

            DumpError:
              CLOSE #1
              PRINT "Error = ";ERR
              RESUME NEXT

    CASE 59	'F1 - Edit Rule
      xpos = 17 : ypos = 8
      CALL GetRulePhonParam
      CALL MakeWindow(4,1,18,80,1,14)
      COLOR 14,1
      LOCATE 4,33 : PRINT " EDIT RULE ";
      LOCATE 15,2 : PRINT "";STRING$(76,"");"";
      LOCATE 16,6 : PRINT CHR$(24);" ";CHR$(25);" ";CHR$(27);" ";CHR$(26);
      LOCATE 16,25 : PRINT "PgUp -"
      LOCATE 16,39 : PRINT "Ins -"
      LOCATE 17,25 : PRINT "PgDn -"
      LOCATE 17,39 : PRINT "Del -"
      LOCATE 17,62 : PRINT "Alt S -"
      LOCATE 16,63 : PRINT "End  -"

      COLOR 15,1
      LOCATE 16,15 : PRINT "Select"
      LOCATE 16,32 : PRINT "INCR"
      LOCATE 16,45 : PRINT "Insert Phoneme"
      LOCATE 17,32 : PRINT "DECR"
      LOCATE 17,45 : PRINT "Delete Phoneme"
      LOCATE 17,70 : PRINT "Saves"
      LOCATE 16,70 : PRINT "Abort"

    UpdateEditScreen:
      CALL MakeWindow(6,17,13,78,1,1)
      COLOR 15,1 : LOCATE 6,6 : PRINT NewRule$;
      LOCATE 6,18
      FOR a = 0 TO NewNumPhon
        PRINT USING "\    \";NewPC$(a);
      NEXT a

      LOCATE 8,4 : PRINT "Inflection";
      LOCATE 9,4 : PRINT "Duration";
      LOCATE 10,4 : PRINT "Rate";
      LOCATE 11,4 : PRINT "Articulation";
      LOCATE 12,4 : PRINT "Amplitude";
      LOCATE 13,4 : PRINT "Frequency";

        xpos=17
      FOR a = 0 TO NewNumPhon
      LOCATE 8,xpos
        PRINT NewInfl(a);
      LOCATE 9,xpos
        PRINT NewDur(a);
      LOCATE 10,xpos
        PRINT NewRate(a);
      LOCATE 11,xpos
        PRINT NewArt(a);
      LOCATE 12,xpos
        PRINT NewAmp(a);
      LOCATE 13,xpos
        PRINT NewFF(a);
      INCR xpos,6
      NEXT a

IF KeepPos > 0 THEN xpos = KeepPos : KeepPos = 0 : GOTO KeepPos
xpos = 5 : ypos = 6 : RuleMax=9
KeepPos:
xmax = ((NewNumPhon+1) * 6) + 17
CALL HLight(ypos,xpos,RuleMax)

EditCursor:
CALL ReadKBD(Ch$)
CALL IBMCh(Ch$)
IF LEN(Ch$) = 1 THEN GOTO Modify
IF (asc(Ch$)<>0) OR LEN(Ch$)<>2 THEN GOTO EditCursor
  SELECT CASE asc(MID$(Ch$,2,1))

    CASE 79	'End - Aborts Edit
      CALL Redraw
      GOTO ReportKey

    CASE 5	'Up Arrow
      IF ypos = 6 AND xpos <> 5 THEN
         CALL UnHLight(ypos,xpos,5)
         ypos = 13
         CALL HLight(ypos,xpos,5)
         EXIT SELECT
      END IF
      IF ypos = 8 THEN
         CALL UnHLight(ypos,xpos,5)
         ypos = 6
         CALL HLight(ypos,xpos,5)
         EXIT SELECT
      END IF
      IF xpos <> 5 THEN
         CALL UnHLight(ypos,xpos,5)
         DECR ypos
         CALL HLight(ypos,xpos,5)
      END IF

    CASE 24	'Down Arrow
      IF ypos = 13 THEN
         CALL UnHLight(ypos,xpos,5)
         ypos = 6
         CALL HLight(ypos,xpos,5)
         EXIT SELECT
      END IF
      IF ypos = 6 AND xpos <> 5 THEN
         CALL UnHLight(ypos,xpos,5)
         ypos = 8
         CALL HLight(ypos,xpos,5)
         EXIT SELECT
      END IF
      IF xpos <> 5 THEN
         CALL UnHLight(ypos,xpos,5)
         INCR ypos
         CALL HLight(ypos,xpos,5)
         EXIT SELECT
      END IF

    CASE 4	'Right Arrow
      IF xpos = 5 THEN
         CALL UnHLight(ypos,xpos,RuleMax)
         INCR xpos,12
         CALL HLight(ypos,xpos,5)
         EXIT SELECT
      END IF
      IF xpos = xmax AND ypos = 6 THEN
         CALL UnHLight(ypos,xpos,5)
         xpos = 5
         CALL HLight(ypos,xpos,RuleMax)
         EXIT SELECT
      END IF
      IF xpos = xmax THEN
         CALL UnHLight(ypos,xpos,5)
         xpos = 17
         CALL HLight(ypos,xpos,5)
         EXIT SELECT
      END IF
         CALL UnHLight(ypos,xpos,5)
         INCR xpos,6
         CALL HLight(ypos,xpos,5)

    CASE 19	'Left Arrow
      IF xpos = 5 THEN
         CALL UnHLight(ypos,xpos,RuleMax)
         xpos = xmax
         CALL HLight(ypos,xpos,5)
         EXIT SELECT
      END IF
      IF xpos = 17 AND ypos = 6 THEN
         CALL UnHLight(ypos,xpos,5)
         xpos = 5
         CALL HLight(ypos,xpos,RuleMax)
         EXIT SELECT
      END IF
      IF xpos = 17 THEN
         CALL UnHLight(ypos,xpos,5)
         xpos = xmax
         CALL HLight(ypos,xpos,5)
         EXIT SELECT
      END IF
         CALL UnHLight(ypos,xpos,5)
         DECR xpos,6
         CALL HLight(ypos,xpos,5)

    CASE 73	'PgUp - Increment Parameter
      SaveFlag = %True
      IF ypos = 8 THEN		'Line 13 is Inflections
         INCR NewInfl((xpos-17)\6),16
         IF NewInfl((xpos-17)\6) > 4096 THEN NewInfl((xpos-17)\6) = 0
         COLOR 0,7 : LOCATE ypos,xpos : PRINT SPACE$(6);
         LOCATE ypos,xpos : PRINT NewInfl((xpos-17)\6)
      END IF

      IF ypos = 9 THEN		'Line 9 is Durations
         IF NewPC$((xpos-17)\6) = "PA" AND NewDur((xpos-17)\6)=0 THEN INCR NewDur((xpos-17)\6)
         INCR NewDur((xpos-17)\6)
         IF NewDur((xpos-17)\6) > 3 THEN NewDur((xpos-17)\6) = 0
         COLOR 0,7 : LOCATE ypos,xpos : PRINT NewDur((xpos-17)\6)
      END IF

      IF ypos = 10 THEN		'Line 10 is Rates
         INCR NewRate((xpos-17)\6)
         IF NewRate((xpos-17)\6) > 15 THEN NewRate((xpos-17)\6) = 0
         COLOR 0,7 : LOCATE ypos,xpos : PRINT SPACE$(4);
         LOCATE ypos,xpos : PRINT NewRate((xpos-17)\6)
      END IF

      IF ypos = 11 THEN		'Line 11 is Articulations
         INCR NewArt((xpos-17)\6)
         IF NewArt((xpos-17)\6) > 7 THEN NewArt((xpos-17)\6) = 0
         COLOR 0,7 : LOCATE ypos,xpos : PRINT NewArt((xpos-17)\6)
      END IF

      IF ypos = 12 THEN		'Line 12 is Amplitudes
         INCR NewAmp((xpos-17)\6)
         IF NewAmp((xpos-17)\6) > 15 THEN NewAmp((xpos-17)\6) = 0
         COLOR 0,7 : LOCATE ypos,xpos : PRINT NewAmp((xpos-17)\6)
      END IF

      IF ypos = 13 THEN		'Line 13 is Frequency
         INCR NewFF((xpos-17)\6)
         IF NewFF((xpos-17)\6) > 255 THEN NewFF((xpos-17)\6) = 0
         COLOR 0,7 : LOCATE ypos,xpos : PRINT SPACE$(5);
         LOCATE ypos,xpos : PRINT NewFF((xpos-17)\6)
      END IF

    CASE 81	'PgDn - Increment Parameter
      SaveFlag = %True
      IF ypos = 8 THEN		'Line 13 is Inflections
         DECR NewInfl((xpos-17)\6),16
         IF NewInfl((xpos-17)\6) < 0 THEN NewInfl((xpos-17)\6) = 4096
         COLOR 0,7 : LOCATE ypos,xpos : PRINT SPACE$(6);
         LOCATE ypos,xpos : PRINT NewInfl((xpos-17)\6)
      END IF

      IF ypos = 9 THEN		'Line 9 is Durations
         IF NewPC$(NewNumPhon) = "PA" AND NewDur((xpos-17)\6)=2 THEN DECR NewDur((xpos-17)\6)
         DECR NewDur((xpos-17)\6)
         IF NewDur((xpos-17)\6) < 0 THEN NewDur((xpos-17)\6) = 3
         COLOR 0,7 : LOCATE ypos,xpos : PRINT NewDur((xpos-17)\6)
      END IF

      IF ypos = 10 THEN		'Line 10 is Rates
         DECR NewRate((xpos-17)\6)
         IF NewRate((xpos-17)\6) < 0 THEN NewRate((xpos-17)\6) = 15
         COLOR 0,7 : LOCATE ypos,xpos : PRINT SPACE$(4);
         LOCATE ypos,xpos : PRINT NewRate((xpos-17)\6)
      END IF

      IF ypos = 11 THEN		'Line 11 is Articulations
         DECR NewArt((xpos-17)\6)
         IF NewArt((xpos-17)\6) < 0 THEN NewArt((xpos-17)\6) = 7
         COLOR 0,7 : LOCATE ypos,xpos : PRINT NewArt((xpos-17)\6)
      END IF

      IF ypos = 12 THEN		'Line 12 is Amplitudes
         DECR NewAmp((xpos-17)\6)
         IF NewAmp((xpos-17)\6) < 0 THEN NewAmp((xpos-17)\6) = 15
         COLOR 0,7 : LOCATE ypos,xpos : PRINT NewAmp((xpos-17)\6)
      END IF

      IF ypos = 13 THEN		'Line 13 is Frequency
         DECR NewFF((xpos-17)\6)
         IF NewFF((xpos-17)\6) < 0 THEN NewFF((xpos-17)\6) = 255
         COLOR 0,7 : LOCATE ypos,xpos : PRINT SPACE$(5);
         LOCATE ypos,xpos : PRINT NewFF((xpos-17)\6)
      END IF

    CASE 82	'Ins - Insert Phoneme
      SaveFlag = %True
      IF xpos = 5 THEN EXIT SELECT
      KeepPos = xpos
      InsertPos = (xpos-17)\6
      IF InsertPos > NewNumPhon THEN
         NewPC$(NewNumPhon+1)  = "PA"
         NewPC(NewNumPhon+1)   = 0
         NewDur(NewNumPhon+1)  = 0
         NewFF(NewNumPhon+1)   = 231
         NewArt(NewNumPhon+1)  = 7
         NewAmp(NewNumPhon+1)  = 4
         NewRate(NewNumPhon+1) = 10
         NewInfl(NewNumPhon+1) = 2880
         GOTO InsDone
      END IF

      IF InsertPos <= NewNumPhon THEN
         FOR nn = NewNumPhon TO InsertPos STEP-1
           NewPC$(nn+1) = NewPC$(nn)
           NewPC(nn+1)  = NewPC(nn)
           NewDur(nn+1) = NewDur(nn)
           NewFF(nn+1)  = NewFF(nn)
           NewArt(nn+1) = NewArt(nn)
           NewAmp(nn+1) = NewAmp(nn)
           NewRate(nn+1) = NewRate(nn)
           NewInfl(nn+1) = NewInfl(nn)
         NEXT nn
      END IF

        NewPC$(InsertPos)  = "PA"
        NewPC(InsertPos)   =  0
        NewDur(InsertPos)  =  0
        NewFF(InsertPos)   =  231
        NewArt(InsertPos)  =  7
        NewAmp(InsertPos)  =  4
        NewRate(InsertPos) =  10
        NewInfl(InsertPos) =  2880

    InsDone:
      INCR NewNumPhon
      RuleMax% = 5
      GOTO UpdateEditScreen

    CASE 83	'Del - Deletes Phoneme
      SaveFlag = %True
      InsertPos = (xpos-17)\6
      IF xpos = 5 THEN EXIT SELECT
      KeepPos = xpos
      IF NewFF(InsertPos) = 0 THEN EXIT SELECT
      FOR nn = InsertPos TO NewNumPhon
        NewPC$(nn)= NewPC$(nn+1)
        NewPC(nn)  = NewPC(nn+1)
        NewDur(nn) = NewDur(nn+1)
        NewFF(nn)  = NewFF(nn+1)
        NewArt(nn) = NewArt(nn+1)
        NewAmp(nn) = NewAmp(nn+1)
        NewRate(nn) = NewRate(nn+1)
        NewInfl(nn) = NewInfl(nn+1)
      NEXT nn

        nn = NewNumPhon
        NewPC$(nn)  = ""
        NewPC(nn)   = 0
        NewDur(nn)  = 0
        NewFF(nn)   = 0
        NewArt(nn)  = 0
        NewAmp(nn)  = 0
        NewRate(nn) = 0
        NewInfl(nn) = 0

      DECR NewNumPhon
      CALL MakeWindow(6,3,14,78,1,1)
      RuleMax% = 5
      GOTO UpdateEditScreen

    CASE 31	'Alt S - Saves changes
      CALL SaveRule
      CALL Redraw
      GOTO ReportKey
  END SELECT

Modify:
  Ch$ = UCASE$(Ch$)
  IF (asc(Ch$) <> 32) OR LEN(Ch$) <> 1 THEN GOTO EditCursor
  SaveFlag = %True
  IF ypos = 6 THEN
     IF xpos = 5 THEN
     BRule:
        COLOR 0,7 : LOCATE 6,6 : PRINT SPACE$(LEN(OldRule$));
        LOCATE 6,6 : INPUT ,NewRule$
        CALL ParseRule
        IF BadCode = 1 THEN GOTO BRule ELSE GOTO EditCursor
     END IF

   IF xpos <> 5 THEN
   BPhon:
     COLOR 0,7 : LOCATE 6,xpos+1 : PRINT "   ";
     LOCATE 6,xpos+1 : INPUT ,NewPC$((xpos-17)\6)
     CALL ParsePhonemes
     IF BadCode = 1 THEN GOTO BPhon ELSE GOTO EditCursor
  END IF
END IF
GOTO EditCursor
END SELECT

GOTO ReportKey

END

'Ŀ
SUB SaveRule
 SHARED NewRule$, OldRule$, RuleChar, TableLength, ScrnLine, PhonAdd, Offset()
 SHARED NewPC$(), NewPC(), NewFF(), NewArt(), NewAmp(), NewRate(), NewInfl()
 SHARED NewDur(), NewNumPhon, NumPhon, SaveFlag, LastOffset&
 LOCAL aa, bb, nn, Diff, TmpPtr

Diff = (LEN(NewRule$) - LEN(OldRule$)) + ((NewNumPhon - NumPhon)* 5)
INCR RuleChar

IF SGN(Diff) = 1 THEN
   IF PEEK(LastOffset&) = RuleChar-1 AND Offset(ScrnLine+1) = 0 THEN
      FOR nn = TableLength TO LastOffset&-2 STEP-1
          POKE nn+Diff,PEEK(nn)
      NEXT nn
   ELSEIF Offset(ScrnLine+1) = 0 THEN
      TmpPtr = (RuleChar-65) * 3
      TmpPtr = (PEEK(TmpPtr+2)*256)+PEEK(TmpPtr+1)
      FOR nn = TableLength TO TmpPtr-2 STEP-1
          POKE nn+Diff,PEEK(nn)
      NEXT nn
   ELSEIF Offset(ScrnLine+1) <> 0 THEN
      FOR nn = TableLength TO Offset(ScrnLine+1)-1 STEP-1
          POKE nn+Diff,PEEK(nn)
      NEXT nn
   END IF
CALL AddDisp(Diff)
SaveFlag = %True
END IF

IF SGN(Diff) = -1 THEN
   IF PEEK(LastOffset&) = RuleChar-1 AND Offset(ScrnLine+1) = 0 THEN
      FOR nn = LastOffset&-2 TO TableLength
          POKE nn+Diff,PEEK(nn)
      NEXT nn
   ELSEIF Offset(ScrnLine+1) = 0 THEN
      TmpPtr = (RuleChar-65) * 3
      TmpPtr = (PEEK(TmpPtr+2)*256)+PEEK(TmpPtr+1)
      FOR nn = TmpPtr-2 TO TableLength
          POKE nn+Diff,PEEK(nn)
      NEXT nn
   ELSEIF Offset(ScrnLine+1) <> 0 THEN
      FOR nn = Offset(ScrnLine+1)-1 TO TableLength
          POKE nn+Diff,PEEK(nn)
      NEXT nn
   END IF
CALL SubDisp(ABS(Diff))
SaveFlag = %True
END IF

aa=0
FOR nn = 1 TO LEN(NewRule$)
  POKE Offset(ScrnLine)+aa,asc(MID$(NewRule$,nn,1))
  INCR aa
NEXT nn

aa = aa + Offset(ScrnLine)
bb=0
FOR nn = aa TO (aa+(NewNumPhon * 5)) STEP 5
  POKE nn,NewPC(bb) + (NewDur(bb)*64)
  POKE nn+1,NewFF(bb)
  POKE nn+2,NewAmp(bb) + (NewArt(bb)*16)
  IF NewInfl(bb) => 2048 THEN MInfl = 8 ELSE MInfl = 0
  POKE nn+3,((NewRate(bb)*16)+MInfl+(NewInfl(bb) AND 7))
  POKE nn+4,(NewInfl(bb) AND 2040)\8
  INCR bb
NEXT nn

IF OldRule$ <> NewRule$ THEN SaveFlag = %True

FOR aa = 0 TO NewNumPhon
    IF NewPC(aa)   <> OldPC(aa)   THEN SaveFlag = %True
    IF NewDur(aa)  <> OldDur(aa)  THEN SaveFlag = %True
    IF NewFF(aa)   <> OldFF(aa)   THEN SaveFlag = %True
    IF NewAmp(aa)  <> OldAmp(aa)  THEN SaveFlag = %True
    IF NewArt(aa)  <> OldArt(aa)  THEN SaveFlag = %True
    IF NewInfl(aa) <> OldInfl(aa) THEN SaveFlag = %True
    IF NewRate(aa) <> OldRate(aa) THEN SaveFlag = %True
NEXT aa

DECR RuleChar

END SUB

'Ŀ
'Adjusts Rule Table Pointer Addresses for extra rule or phoneme characters
'that have been inserted

SUB AddDisp(Disp)
 SHARED RuleChar,TableLength
 LOCAL a,MSB,LSB

FOR a=((RuleChar-65) * 3) TO 26*3 STEP 3
  Address& = (PEEK(a+2)*256)+PEEK(a+1)+Disp
  MSB = CINT(Address& \ 256)
  LSB = CINT(Address& - (MSB*256))
  POKE a+2,MSB
  POKE a+1,LSB
NEXT a

INCR TableLength,Disp

END SUB

'Ŀ
'Adjusts Rule Table Pointer Addresses for extra rule or phoneme characters
'that have been deleted

SUB SubDisp(Disp)
 SHARED RuleChar,TableLength
 LOCAL a,MSB,LSB

FOR a=((RuleChar-65) * 3) TO 26*3 STEP 3
  Address& = (PEEK(a+2)*256)+PEEK(a+1)-Disp
  MSB = CINT(Address& \ 256)
  LSB = CINT(Address& - (MSB*256))
  POKE a+2,MSB
  POKE a+1,LSB
NEXT a

DECR TableLength,Disp

FOR a = TableLength+1 TO TableLength+Disp+1
  POKE a,0
NEXT a

END SUB

'Ŀ
SUB Redraw
 SHARED ScrnLine, RulePtr&, Offset()

    Tmp = ScrnLine
    RulePtr& = Offset(0)
    CALL DispRule
    CALL UnHighLight(0)
    CALL HighLight(Tmp)
    ScrnLine = Tmp

END SUB

'Ŀ
SUB GetRulePhonParam
  SHARED PC$(), Offset(), ScrnLine, Disp, PhonAdd, NumPhon
  SHARED OldRule$, OldPC$(), OldFF(), OldAmp(), OldArt(), OldRate(), OldInfl()
  SHARED OldDur()
  SHARED NewRule$, NewPC$(), NewFF(), NewAmp(), NewArt(), NewRate(), NewInfl()
  SHARED NewDur(), NewNumPhon, NewPC()
  LOCAL OldRuleChar$, MsbInfl, LsThree, MidInfl

      ERASE OldPC$, OldAmp, OldArt, OldRate, OldInfl, OldDur, OldFF
      ERASE NewPC$, NewPC, NewAmp, NewArt, NewRate, NewInfl, NewDur, NewFF

      DIM OldPC$(20), OldAmp(20), OldArt(20), OldRate(20), OldInfl(20)
      DIM OldDur(20), OldFF(20)

      DIM NewPC$(20), NewPC(20), NewAmp(20), NewArt(20),NewRate(20),NewInfl(20)
      DIM NewDur(20), NewFF(20)

      Disp = 0 : OldRule$ = "" : NewRule$ = "" : NumPhon = 0 : NewNumPhon = 0
      WHILE PEEK(Offset(ScrnLine)+Disp) <> ASC("=")
        OldRuleChar$ = CHR$(PEEK(Offset(ScrnLine)+Disp))
        OldRule$ = OldRule$ + OldRuleChar$
        INCR Disp
      WEND
        INCR Disp
        OldRule$ = OldRule$ + "=" : NewRule$ = OldRule$
        PhonAdd = Offset(ScrnLine)+Disp

      IF PEEK(Offset(ScrnLine)+Disp) = ASC("@") THEN
         OldPC$(0) = "None" : NewPC$(0) = "None" :INCR Disp
      END IF

      IF PEEK(Offset(ScrnLine)+Disp) = ASC("[") THEN INCR Disp

      IF OldPC$(0) = "None" THEN EXIT SUB

      WHILE PEEK(Offset(ScrnLine)+Disp) <> ASC("@")
        GOSUB GetData
      WEND
      DECR NumPhon : DECR NewNumPhon
      EXIT SUB

    GetData:
      OldPC$(NumPhon) = PC$(PEEK(Offset(ScrnLine)+Disp)AND 63)
        NewPC$(NumPhon) = OldPC$(NumPhon)
        CALL PreParsePhon
      OldDur(NumPhon) = (PEEK(Offset(ScrnLine)+Disp)AND 192)\64
        NewDur(NumPhon) = OldDur(NumPhon)
      INCR Disp
      OldFF(NumPhon) = PEEK(Offset(ScrnLine)+Disp)
        NewFF(NumPhon) = OldFF(NumPhon)
      INCR Disp
      OldAmp(NumPhon) = PEEK(Offset(ScrnLine)+Disp) AND 15
        NewAmp(NumPhon) = OldAmp(NumPhon)
      OldArt(NumPhon) = (PEEK(Offset(ScrnLine)+Disp) AND 112)\16
        NewArt(NumPhon) = OldArt(NumPhon)
      INCR Disp
      OldRate(NumPhon) = (PEEK(Offset(ScrnLine)+Disp) AND 240)\16
        NewRate(NumPhon) = OldRate(NumPhon)
      MsbInfl = ((PEEK(Offset(ScrnLine)+Disp) AND 8)\8)*2048
      LsThree = PEEK(Offset(ScrnLine)+Disp) AND 7
      INCR Disp
      MidInfl = PEEK(Offset(ScrnLine)+Disp)*8
      OldInfl(NumPhon) = MsbInfl + LsThree + MidInfl
        NewInfl(NumPhon) = OldInfl(NumPhon)
      INCR Disp
      INCR NumPhon : INCR NewNumPhon
    RETURN

END SUB

'Ŀ
'Highlights one line of rules

SUB HLight(y,x,z)

DEF SEG = &HB800
FOR b = (y-1)*160+1+((x-1)*2) TO (y-1)*160+1+((x-1)*2)+(z*2) STEP 2
  POKE b,&H70
NEXT b

DEF SEG = &H8000

LOCATE y,x+1,0

END SUB

'Ŀ
'Highlights one line of rules

SUB UnHLight(y,x,z)

DEF SEG = &HB800
FOR b = (y-1)*160+1+((x-1)*2) TO (y-1)*160+1+((x-1)*2)+(z*2) STEP 2
  POKE b,31
NEXT b

DEF SEG = &H8000

END SUB


'Ŀ
SUB MainMenu

CALL MakeWindow(24,1,25,80,1,1)

COLOR 14,1
LOCATE 24,4  : PRINT "F1-";
LOCATE 24,26 : PRINT "Ins-";
LOCATE 24,45 : PRINT "F5-";
LOCATE 24,62 : PRINT "F7-";

COLOR 15,1
LOCATE 24,7  : PRINT "Edit Rule";
LOCATE 24,30 : PRINT "Insert Rule";
LOCATE 24,48 : PRINT "Test Rule";
LOCATE 24,65 : PRINT "Save Rules";

COLOR 14,1
LOCATE 25,4  : PRINT "F2-";
LOCATE 25,26 : PRINT "Del-";
LOCATE 25,45 : PRINT "F6-";
LOCATE 25,61 : PRINT "AF10-";

COLOR 15,1
LOCATE 25,7  : PRINT "Select SubTable";
LOCATE 25,30 : PRINT "Delete Rule";
LOCATE 25,48 : PRINT "Text Mode";
LOCATE 25,66 : PRINT "Exit to DOS";

END SUB

'Ŀ
SUB ParsePhonemes
 SHARED PC$(), OldPC$(), NewPC$(), NewPC(), xpos, ypos, BadCode, NewNumPhon

 BadCode = 0

 FOR a=0 TO 63
   IF UCASE$(NewPC$((xpos-17)\6)) = PC$(a) THEN
      NewPC((xpos-17)\6) = a
      EXIT SUB
   END IF
 NEXT a

 COLOR 14,1 : LOCATE ypos-1,xpos : PRINT "Bad Phoneme!!" : DELAY 2
 COLOR 15,1 : LOCATE ypos-1,xpos : PRINT SPACE$(13);
 COLOR 0,7 : LOCATE ypos,xpos+1 : PRINT OldPC$((xpos-17)\6)
 BadCode = 1

END SUB

'Ŀ
SUB PreParsePhon
 SHARED PC$(), NewPC$(), NewPC(), NumPhon

 FOR a=0 TO 63
   IF UCASE$(NewPC$(NumPhon)) = PC$(a) THEN
      NewPC(NumPhon) = a
      EXIT SUB
   END IF
 NEXT a

END SUB

'Ŀ
SUB ParseRule
 SHARED NewRule$, OldRule$, xpos, ypos, RuleMax, BadCode
 LOCAL a,b

BadCode=0 : b=0
NewRule$ = UCASE$(NewRule$)
FOR a=1 TO LEN(NewRule$)
SELECT CASE asc(MID$(NewRule$,a,1))
  CASE 65 TO 90,33 TO 38,43,46,58,60 TO 62
    INCR b
END SELECT
NEXT a

DECR a
IF b <> a THEN
  BadCode=1
  COLOR 14,1 : LOCATE 5,5
  PRINT "Bad Rule!!" : DELAY 2
  COLOR 15,1 : LOCATE 5,5 : PRINT SPACE$(10);
  COLOR 0,7 : LOCATE 6,6 : PRINT OldRule$ : CALL HLight(ypos,xpos,RuleMax)
END IF

IF RIGHT$(NewRule$,1) <> "=" THEN
   NewRule$=NewRule$+"="
   COLOR 0,7 : LOCATE 6,6 : PRINT NewRule$
END IF

END SUB

'Ŀ
'Display 20 lines of any Rule Subtable
SUB DispRule
 SHARED RulePtr&, PC$(), Offset(), ScrnLine, LastOffset&

CALL ClearOffset
CALL MakeWindow(1,1,21,80,0,0)
LOCATE 1,1 : COLOR 4,0
ScrnLine = 0

WHILE PEEK(RulePtr&) <> ASC("[")
  Offset(ScrnLine) = RulePtr&
  WHILE PEEK(RulePtr&) <> ASC("=")
    PRINT CHR$(PEEK(RulePtr&));
    INCR RulePtr&
  WEND
    PRINT "= ";
    INCR RulePtr&

  IF PEEK(RulePtr&) = ASC("@") THEN PRINT "PA" : INCR RulePtr& : GOTO SkipIt

  WHILE PEEK(RulePtr&+5) <> ASC("@")
    PRINT (PC$(PEEK(RulePtr&) AND 63));" ";
    INCR RulePtr&,5
  WEND

    PRINT (PC$(PEEK(RulePtr&) AND 63))
    INCR RulePtr&,6

  SkipIt:
    INCR ScrnLine : IF ScrnLine => 20 THEN EXIT LOOP
WEND

LastOffset& = RulePtr&

CALL HighLight(0)
ScrnLine = 0
END SUB

END

'Ŀ
SUB ClearOffset
 SHARED Offset()

FOR a% = 0 TO 22
  Offset(a%) = 0
NEXT a%

END SUB

'Ŀ
SUB ReadKBD(RetChar$)
  DO
   RetChar$ = INKEY$
  LOOP UNTIL RetChar$<>""
END SUB

'Ŀ
SUB IBMCh(Ch$)
  IF (ASC(Ch$)=0) THEN
    SELECT CASE ASC(MID$(Ch$,2,1))
      CASE 72		'Up Arrow
        MID$(Ch$,2)=CHR$(5)
      CASE 80		'Down Arrow
        MID$(Ch$,2)=CHR$(24)
      CASE 77		'Right Arrow
        MID$(Ch$,2)=CHR$(4)
      CASE 75		'Left Arrow
        MID$(Ch$,2)=CHR$(19)
    END SELECT
  END IF
END SUB

'Ŀ
'Highlights one line of rules

SUB HighLight(a)

DEF SEG = &HB800
FOR b = a*160+1 TO (a*160)+160 STEP 2
  POKE b,&H40
NEXT b

DEF SEG = &H8000

END SUB

'Ŀ
'Highlights one line of rules

SUB UnHighLight(a)

DEF SEG = &HB800
FOR b = a*160+1 TO (a*160)+160 STEP 2
  POKE b,4
NEXT b

DEF SEG = &H8000

END SUB

'Ŀ
SUB MakeWindow(uly,ulx,lry,lrx,WindowColor,BorderColor)

 REG %AX,&H0600
 REG %BX,(WindowColor * 4096)
 REG %CX,((uly-1)*256)+ulx-1
 REG %DX,((lry-1)*256)+lrx-1
 CALL INTERRUPT &H10

 IF WindowColor = BorderColor THEN EXIT SUB

  COLOR BorderColor%,WindowColor%
  LOCATE uly,ulx+1 : PRINT "";STRING$(lrx-ulx-3,"");"";

  FOR y=uly+1 to lry-1:LOCATE y,ulx+1
    PRINT ""; : LOCATE y,lrx-1 : PRINT "";
  NEXT y

  LOCATE lry,ulx+1 : PRINT "";STRING$(lrx-ulx-3,"");"";

END SUB

'Ŀ
GetText:
INPUT "Enter Word(s): ";Phrase$
IF RIGHT$(Phrase$,1)<>" " THEN Phrase$=Phrase$+" "
YPos = CSRLIN
IF Phrase$ = "" THEN END
Phrase$ = " "+UCASE$(Phrase$)+" "
Length = LEN(Phrase$)
InpBufPtr = 2		'= IX
IxPtr = InpBufPtr
DePtr = InpBufPtr

'Ŀ
ChType:
SaveIx = InpBufPtr

InpChr$ = MID$(Phrase$,InpBufPtr,1)

SELECT CASE ASC(InpChr$)
  CASE 65 TO 90
    RulePtr& = (ASC(MID$(Phrase$,InpBufPtr,1))-65) * 3
    RulePtr& = (PEEK(RulePtr&+2)*256)+PEEK(RulePtr&+1)
    GOTO RuleScan
  CASE 32
    RulePtr& = 78
    RulePtr& = (PEEK(RulePtr&+2)*256)+PEEK(RulePtr&+1)
    GOTO RuleScan
END SELECT

END

'Ŀ
RuleScan:
DePtr = InpBufPtr
RuleScanLoop:
IF InpChr$ <> CHR$(PEEK(RulePtr&)) THEN GOTO NextRule
INCR RulePtr&
SELECT CASE CHR$(PEEK(RulePtr&))
  CASE "<"
    GOTO LeftScan
  CASE ">"
    GOTO RightScan
  CASE "="
    GOTO Transfer
END SELECT
INCR InpBufPtr
InpChr$ = MID$(Phrase$,InpBufPtr,1)
GOTO RuleScanLoop

'Ŀ
LeftScan:
INCR RulePtr&
LRflag = Left
SELECT CASE CHR$(PEEK(RulePtr&))
  CASE "!"
    GOTO NoAlph
  CASE "#"
    GOTO Vowel
  CASE ":"
    GOTO Consts
  CASE "+"
    GOTO FrntVl
  CASE CHR$(34)  ' = "
    GOTO Consnt
  CASE "."
    GOTO VCnsnt
  CASE "&"
    GOTO Siblnt
  CASE "$"
    GOTO InfCon
  CASE "%"
    GOTO Suffix
  CASE ">"
    GOTO RightScan
  CASE "="
    GOTO Transfer
  CASE ELSE
    GOTO AscChk
END SELECT

'Ŀ
RightScan:
INCR RulePtr&
IF LRFlag = Right THEN GOTO RPass
IxPtr = InpBufPtr
RPass:
LRFlag = Right
SELECT CASE CHR$(PEEK(RulePtr&))
  CASE "!"
    GOTO NoAlph
  CASE "#"
    GOTO Vowel
  CASE ":"
    GOTO Consts
  CASE CHR$(34)
    GOTO Consnt
  CASE "+"
    GOTO FrntVl
  CASE "."
    GOTO VCnsnt
  CASE "%"
    GOTO Suffix
  CASE "="
    GOTO Transfer
  CASE ELSE
    GOTO AscChk
END SELECT

'Ŀ
'Match Non-Alpha Characters = !

NoAlph:

IF LRflag = Left THEN
   DECR DePtr
   IF DePtr < 1 THEN INCR DePtr : EXIT IF
   Tmp$ = MID$(Phrase$,DePtr,1)
   IF Tmp$ <> " " THEN GOTO NextRule
END IF

IF LRflag = Right THEN
   INCR InpBufPtr
   IF InpBufPtr > Length THEN EXIT IF
   Tmp$ = MID$(Phrase$,InpBufPtr,1)
   IF Tmp$ <> " " THEN GOTO NextRule
END IF

NonAlph:
IF LRFlag = Right THEN GOTO RightScan ELSE GOTO LeftScan

'Ŀ
'Match one or more Vowels = #

Vowel:

Tmp$ = ""
IF LRflag = Left THEN
   DECR DePtr
   IF DePtr < 1 THEN INCR DePtr : EXIT IF
   Tmp$ = MID$(Phrase$,DePtr,1)
END IF

IF LRflag = Right THEN
   INCR InpBufPtr
   IF InpBufPtr > Length THEN EXIT IF
   Tmp$ = MID$(Phrase$,InpBufPtr,1)
END IF

   SELECT CASE Tmp$
     CASE "A","E","I","O","U","Y"
       IF LRFlag = Right THEN GOTO RightScan ELSE GOTO LeftScan
     CASE ELSE
       GOTO NextRule
   END SELECT

'Ŀ
'Match zero or more consonants = :

Consts:
Tmp$ = ""
IF LRflag = Left THEN
   DECR DePtr
   IF DePtr < 1 THEN INCR DePtr : EXIT IF
   Tmp$ = MID$(Phrase$,DePtr,1)
END IF

IF LRflag = Right THEN
   INCR InpBufPtr
   IF InpBufPtr > Length THEN EXIT IF
   Tmp$ = MID$(Phrase$,InpBufPtr,1)
END IF

   SELECT CASE Tmp$
     CASE "B","C","D","F","G","H","J","K","L","M","N","P","Q","R","S","T","V","W","X","Z"
       GOTO Consts
   END SELECT

INCR DePtr
IF LRFlag = Left THEN GOTO LeftScan ELSE GOTO RightScan

'Ŀ
'Match one Consonant = "
Consnt:

Tmp$ = ""
IF LRflag = Left THEN
   DECR DePtr
   IF DePtr < 1 THEN INCR DePtr : EXIT IF
   Tmp$ = MID$(Phrase$,DePtr,1)
END IF

IF LRflag = Right THEN
   INCR InpBufPtr
   IF InpBufPtr > Length THEN EXIT IF
   Tmp$ = MID$(Phrase$,InpBufPtr,1)
END IF

   SELECT CASE Tmp$
     CASE "B","C","D","F","G","H","J","K","L","M","N","P","Q","R","S","T","V","W","X","Z"
       IF LRFlag = Right THEN GOTO RightScan ELSE GOTO LeftScan
     CASE ELSE
       GOTO NextRule
   END SELECT

'Ŀ
'Match a Voiced Consonant = .

VCnsnt:
Tmp$ = ""
IF LRflag = Left THEN
   DECR DePtr
   IF DePtr < 1 THEN INCR DePtr : EXIT IF
   Tmp$ = MID$(Phrase$,DePtr,1)
END IF

IF LRflag = Right THEN
   INCR InpBufPtr
   IF InpBufPtr > Length THEN EXIT IF
   Tmp$ = MID$(Phrase$,InpBufPtr,1)
END IF

   SELECT CASE Tmp$
     CASE "B","D","G","J","L","M","N","R","V","W","Z"
       IF LRFlag = Right THEN GOTO RightScan ELSE GOTO LeftScan
     CASE ELSE
       GOTO NextRule
   END SELECT

'Ŀ
'Match Frontal Vowel = +

FrntVl:
Tmp$=""
IF LRflag = Left THEN
   DECR DePtr
   IF DePtr < 1 THEN INCR DePtr : EXIT IF
   Tmp$ = MID$(Phrase$,DePtr,1)
END IF

IF LRflag = Right THEN
   INCR InpBufPtr
   IF InpBufPtr > Length THEN EXIT IF
   Tmp$ = MID$(Phrase$,InpBufPtr,1)
END IF

   SELECT CASE Tmp$
     CASE "E","I","Y"
       IF LRFlag = Right THEN GOTO RightScan ELSE GOTO LeftScan
     CASE ELSE
       GOTO NextRule
   END SELECT

'Ŀ
'Match Suffix's = %

Suffix:

Tmp$ = ""
INCR InpBufPtr

SELECT CASE MID$(Phrase$,InpBufPtr,2)
  CASE "ED","ER","ES"
    INCR InpBufPtr,2
    INCR RulePtr&
    GOTO RightScan
END SELECT

SELECT CASE MID$(Phrase$,InpBufPtr,3)
  CASE "ING","ELY"
    INCR InpBufPtr,3
    INCR RulePtr&
    GOTO RightScan
END SELECT

GOTO NextRule

'Ŀ
'Match Sibilants

Siblnt:

Tmp$ = ""
DECR DePtr
TmpDePtr = DePtr

SELECT CASE MID$(Phrase$,DePtr,1)
  CASE "S","C","G","Z","X","J"
    GOTO LeftScan
END SELECT

SELECT CASE MID$(Phrase$,DePtr,2)
  CASE "HC","HS"
    DECR DePtr
    GOTO LeftScan
END SELECT

DePtr = TmpDePtr

GOTO NextRule

'Ŀ
'Match Influencing Consonants

InfCon:

Tmp$ = ""
DECR DePtr
TmpDePtr = DePtr

SELECT CASE MID$(Phrase$,DePtr,1)
  CASE "T","S","R","D","L","Z","N","J"
    GOTO LeftScan
END SELECT

SELECT CASE MID$(Phrase$,DePtr,2)
  CASE "HT","HC","HS"
    DECR DePtr
    GOTO LeftScan
END SELECT

DePtr = TmpDePtr

GOTO NextRule

'Ŀ
'Match ASCII Characters on right or left

AscChk:

IF LRFlag = Left THEN
   DECR DePtr
   IF DePtr < 1 THEN INCR DePtr : EXIT IF
   IF PEEK(RulePtr&) <> ASC(MID$(Phrase$,DePtr,1)) THEN GOTO NextRule
END IF

IF LRFlag = Right THEN
   INCR InpBufPtr
   IF InpBufPtr > Length THEN EXIT IF
   IF PEEK(RulePtr&) <> ASC(MID$(Phrase$,InpBufPtr,1)) THEN GOTO NextRule
END IF

ExitAscChk:
  IF LRFlag = Left THEN GOTO LeftScan ELSE GOTO RightScan

'Ŀ
'Scan for next rule

NextRule:
InpChr$ = CHR$(PEEK(RulePtr&))
IF InpChr$ = "@" THEN GOTO FoundNext
INCR RulePtr&
GOTO NextRule

FoundNext:
  LRFlag = 0
  InpBufPtr = SaveIx
  InpChr$ = MID$(Phrase$,InpBufPtr,1)
  INCR RulePtr&
  Tmp& = RulePtr&
  IF YPos > 25 THEN
     CLS
     YPos=1
  END IF
  LOCATE YPos,1
  WHILE CHR$(PEEK(Tmp&)) <> "="
    PRINT CHR$(PEEK(Tmp&));
    INCR Tmp&
  WEND
  PRINT "=               ";

  GOTO RuleScan

'Ŀ
Transfer:
IF CHR$(PEEK(RulePtr&-1)) = "@" THEN GOTO SkipTxfr
INCR YPos : IF YPos => 25 THEN PRINT ELSE LOCATE YPos,1
INCR RulePtr&
rr = 0
FOR zz = 0 TO 100 STEP 5

  PO(qq+rr)=PEEK(RulePtr&+zz)
  FF(qq+rr)=PEEK(RulePtr&+1+zz)
  AA(qq+rr)=PEEK(RulePtr&+2+zz)
  RI(qq+rr)=PEEK(RulePtr&+3+zz)
  IO(qq+rr)=PEEK(RulePtr&+4+zz)
  INCR rr
  IF CHR$(PEEK(RulePtr&+5+zz)) = "@" THEN EXIT FOR
NEXT zz

qq=qq+rr

SkipTxfr:
IF LRFlag = Right THEN InpBufPtr = IxPtr
INCR InpBufPtr
IF InpBufPtr => Length THEN GOTO Speak
LRFlag = 0
GOTO ChType

'Ŀ
'SPEAK ROUTINE HERE
Speak:

  OUT 643,&H80
  OUT 640,&HC0
  OUT 643,&H70

FOR ss = 0 TO qq
  OUT 644,FF(ss)
  OUT 643,AA(ss)
  OUT 642,RI(ss)
  OUT 641,IO(ss)
  OUT 640,PO(ss)
  WHILE (INP(640) AND 128) <> 128
  WEND
NEXT ss

  OUT 644,0
  OUT 643,&H70
  OUT 642,0
  OUT 641,0
  OUT 640,0

  qq = 0

FOR a = 0 TO 100
  PO(a) = 0
  FF(a) = 0
  AA(a) = 0
  RI(a) = 0
  IO(a) = 0
NEXT a

RETURN