;
;
;********************
; PROGRAM VARIABLES
;********************
IXTMP	DW	00
LRFLAG	DB	0
SAVEIX	DW	00
IXPTR	DW	00

;******************
; VOWEL CONSTANTS
;******************
VMESS	DB	'AEIOUY'
VMLEN	DB	$-VMESS

;********************
; CONSONANT STORAGE
;********************
CONMES	DB	'BCDFGHJKLMNPQRSTVWXZ'
CONLEN	DB	$-CONMES

;***************************
; VOICED CONSONANT STORAGE
;***************************
VMESSL	DB	'BDGJLMNRVWZ'
VCONLE	DB	$-VMESSL

;*****************
; SUFFIX STORAGE
;*****************
SMESS	DB	'ER,ES,ED,ING,ELY,'
SMESSL	DB	$-SMESS

;*******************
; SIBILANT STORAGE
;*******************
SIBMES	DB	'S,C,G,Z,X,J,HC,HS,'
SIBLEN	DB	$-SIBMES

;********************************
; INFLUENCING CONSONANT STORAGE
;********************************
CONSM	DB	'T,S,R,D,L,Z,N,J,HT,HC,HS,'
CONSLN	DB	$-CONSM

;****************
; ERROR MESSAGE
;****************
ERRMSG	DW	2BH
	DW	3EH,3AH
	DW	3FH,3EH

;***************
; TALK BUFFERS
;***************
;
CHRLEN	DB 	'B'
INPBUF	DB	0,255 DUP(?)
INLAST	DB	0
OUTBUF	DB	0,255 DUP(?)
OUTLST	DB	0
FFBUF	DB	0,255 DUP(?)
AABUF	DB	0,255 DUP(?)
RIBUF	DB	0,255 DUP(?)
IOBUF	DB	0,255 DUP(?)
DURPHM	RECORD	DUR:2=0, PHM:6=0
DPBUFF	DURPHM	255 DUP(<0,0>)

	.CODE
	ASSUME	DS:@FARDATA,ES:@FARDATA
BEGN	PROC	FAR
; Input String Routine Goes Here
; Convert to Upper Case
	PUSH	DS				;SAVE DATA SEGMENT FOR RETURN
	MOV	AX,0				;ZERO OUT AX
	PUSH	AX				;  AND SAVE FOR RETURN TO DOS
	MOV	AX,@FARDATA		;LOAD CURRENT DATA SEGMENT
	MOV	ES,AX
	MOV	DS,AX			;POINT TO THIS PROGRAM
	LEA	DX,CHRLEN			;POINT DX TO KEY BUFFER
	MOV	AH,0AH			;SET UP FOR KBD READ
	INT	21H				;READ KBD
	MOV	CH,0				;ZERO OUT CH
	MOV	CL,INPBUF			;LOAD CL WITH LENGTH OF INPUT
	ADD	DX,2				;DX POINTS TO START OF INPUT
	MOV	BX,DX			;MAKE BX POINT TO START OF INPUT
;
;CONVERT INPUT STRING TO UPPERCASE
;
	PUSH	CX			;SAVE LENGTH OF INPUT POINTER
UPPER1:	MOV	AL,BYTE PTR [BX]	;GET THE CHARACTER
	CMP	AL,'a'			;BELOW THE LOWER CASE CHARACTERS?
	JB	UPPER2			;SKIP IF SO
	CMP	AL,'z'			;ABOVE THE LOWER CASE CHARACTERS?
	JA	UPPER2			;SKIP IF SO
	AND	AL,5FH			;MASK OUT BIT 5
UPPER2:	MOV	[BX],AL			;PUT THE CHARACTER BACK
	INC	BX			;POINT TO NEXT CHARACTER
	LOOP	UPPER1
	POP	CX
;
	MOV	DI,CX			;LOAD DI WITH LENGTH OF INPUT
	MOV	AL,0			;ZERO OUT AX
	MOV	BYTE PTR INPBUF+1[DI],AL  ;ERASE CR AT END OF INPUT
	MOV	AL,32			;SET AL = TO ASCII SPACE
	MOV	BYTE PTR INPBUF,AL	;PUT SPACE IN 1ST BYTE OF INPBUF
	MOV	DI,0			;SET UP INPUT BUFFER POINTER
	MOV	SI,0			;SET UP OUTPUT BUFFER POINTER
;
;***************************
; CHARACTER LOOKUP ROUTINE
;***************************
CHTYPE:	MOV	BX,OFFSET CHTBLE	;GET START OF RULE TABLE
	MOV	AL,ENDTBL		;GET LENGTH OF TABLE
	ADD	AL,-3			;CORRECT LENGTH
	MOV	CH,0			;CLEAR CH
	MOV	CL,AL			;LOAD LOOP COUNTER
	MOV	AL,BYTE PTR INPBUF[DI]	;GET INPUT CHARACTER
	INC	BX			;INCREMENT TABLE POINTER
CHLOOP:	INC	BX			;INC TWICE PAST WORD
	INC	BX			;   LOCATION OF RULE
;
	CMP	AL,BYTE PTR [BX]	;COMPARE RULE TO INPBUF
	LAHF				;SAVE FLAGS TO AH
	INC	BX			;NO, INCR BX
	OR	AH,4			;SET AUX CARRY FLAG
	DEC	CX			;DECREMENT LOOP COUNTER
	JNZ	SKIPIT			;IF CX = 0 NO NEED TO CLEAR AUX CARRY
	AND	AH,251			;CX <> 0 SO CLEAR AUX CARRY FLAG
SKIPIT:	SAHF				;RESTORE FLAGS
;
	JZ	MATCH			;HAVE A MATCH?
	DEC	CL			;DECR LOOP COUNTER
	DEC	CL			;  ONCE MORE
	JNZ	CHLOOP			;SCAN AGAIN
	JMP	ERROR			;OTHERWISE GOTO ERROR ROUTINE
;
MATCH:	MOV	DX,[BX]			;GET ADDRESS OF RULE
	INC	BX			;BUMP UP RULE POINTER
	PUSH	SI			;SAVE SI
	MOV	SI,OFFSET SAVEIX	;SI = ADDRESS OF DI TMP LOCATION
	MOV	[SI],DI			;SAVE DI AT LOCATION SAVEIX
	POP	SI			;RESTORE SI
	XCHG	BX,DX			;PUT START OF RULE IN BX
	JMP	SHORT RULSCN		;GO SCAN RULE TABLE
;
;********************
; RULE SCAN ROUTINE
;********************
;
RULSCN:	MOV	DX,DI			;MAKE DX POINT TO INPUT BUFFER
RULSN1:	CMP	AL,BYTE PTR [BX]	;DOUBLE CHECK MATCH
	JZ	OK			;OK?
	JMP	NEXTRL			;NO, GET NEXT RULE
OK:	INC	BX			;YES, INC RULE POINTER
	MOV	AL,BYTE PTR [BX]	;GET NEXT RULE CHARACTER
	CMP	AL,'<'			;CHECK FOR LEFT SCAN
	JZ	LEFT			;GOTO LEFT SCAN ROUTINE
	CMP	AL,'>'			;CHECK FOR RIGHT SCAN
	JZ	RIGHT			;GOTO RIGHT SCAN ROUTINE
	CMP	AL,'='			;CHECK FOR MATCH
	JNZ	RULSN2			;IF NO MATCH GET NEXT RULE
	JMP	TXFR			;MATCH, TRANSFER PHONEMES
RULSN2:	INC	DI			;INC INPUT STRING POINTER
	MOV	AL,BYTE PTR INPBUF [DI]	;GET INPUT CHARACTER
	JMP	SHORT RULSN1		;SCAN AGAIN
;
;********************
; LEFT SCAN ROUTINE
;********************
;
LEFT:	INC	BX			;SET FOR NEXT CHR IN RULE
	PUSH	BX			;SAVE BX
	MOV	BX,OFFSET LRFLAG	;GET RIGHT/LEFT FLAG
	OR	BYTE PTR [BX],1		;SET FOR LEFT SCAN
	POP	BX			;RESTORE BX
	MOV	AL,BYTE PTR [BX]	;GET NEXT CHR OF RULE
	CMP	AL,'!'
	JNZ	LEFT0			;GOTO BLANK ROUTINE
	JMP	NOALPH
LEFT0:	CMP	AL,'#'
	JNZ	LEFT1
	JMP	VOWEL			;GO CHECK VOWELS
LEFT1:	CMP	AL,':'
	JNZ	LEFT2
	JMP	CONSTS			;GO CHECK 0 OR MORE CONSONANTS
LEFT2:	CMP	AL,'+'
	JNZ	LEFT3
	JMP	FRNTVL			;GO CHECK FRONTAL VOWELS
LEFT3:	CMP	AL,'"'
	JNZ	LEFT4
	JMP	CONSNT			;GO MATCH 1 CONSONANT
LEFT4:	CMP	AL,'.'
	JNZ	LEFT5
	JMP	VCNSNT			;MATCH VOICED CONSONANTS
LEFT5:	CMP	AL,'&'
	JNZ	LEFT6
	JMP	SIBLNT			;CHECK FOR SILIBANTS
LEFT6:	CMP	AL,'$'
	JNZ	LEFT7
	JMP	INFCON			;CHECK FOR INFLUENCING CONSNT
LEFT7:	CMP	AL,'>'
	JZ	RIGHT			;GOTO RIGHT SCAN ROUTINE
	CMP	AL,'='
	JNZ	LEFT9
	JMP	TXFR			;TRANSFER DATA TO OUTPUT BUFFER
LEFT9:	JMP	ASCCHK			;CHECK FOR ASCII CHARACTERS
;
;*********************
; RIGHT SCAN ROUTINE
;*********************
;
RIGHT:	INC	BX			;SET FOR NEXT CHR IN RULE
	PUSH	BX			;SAVE BX
	MOV	BX,OFFSET LRFLAG	;GET LEFT/RIGHT FLAG
	CMP	BYTE PTR [BX],8		;CHECK FOR RIGHT SCAN
	JZ	RPASS			;NOT SET, SKIP SAVING INPBUF POS
	MOV	IXPTR,DI		;SAVE INPUT BUFFER POSITION
	OR	BYTE PTR [BX],8		;SET BIT 8 - RIGHT SCAN
RPASS:	AND	BYTE PTR [BX],254	;CLEAR LEFT SCAN FLAG IF THERE
	POP	BX			;RESTORE BX
	MOV	AL,BYTE PTR [BX]	;GET NEXT CHARACTER FROM RULE
	CMP	AL,'!'
	JZ	NOALPH			;GOTO BLANK ROUTINE
	CMP	AL,'#'
	JNZ	RIGHT2
	JMP	VOWEL			;CHECK FOR VOWELS
RIGHT2:	CMP	AL,':'
	JNZ	RIGHT3
	JMP	CONSTS			;CHK FOR 0 OR MORE CONS
RIGHT3:	CMP	AL,'"'
	JNZ	RIGHT4
	JMP	CONSNT			;CHK FOR 1 CONS MATCH
RIGHT4:	CMP	AL,'+'
	JNZ	RIGHT5
	JMP	FRNTVL			;MATCH FRONTAL VOWEL
RIGHT5:	CMP	AL,'.'
	JNZ	RIGHT6
	JMP	VCNSNT			;CHK VOICED CONSONANT
RIGHT6:	CMP	AL,'%'
	JNZ	RIGHT7
	JMP	SUFFIX			;CHECK SUFFIXES
RIGHT7:	CMP	AL,'='
	JNZ	RIGHT8
	JMP	TXFR			;TRANSFER DATA TO OUTPUT BUF
RIGHT8:	JMP	ASCCHK			;CHECK FOR ASCII CHARACTERS
;
;*********************
; NON-ALPHA TEST = !
;*********************
;
NOALPH:	CALL	SIDE			;RIGHT OR LEFT SIDE CALL?
	JZ	LNO			;LEFT RULE
	INC	DI			;RIGHT RULE - INC INPBUF POINTER
	MOV	AL,BYTE PTR INPBUF [DI]	;GET CHR FROM INPUT BUFFER
	JMP	SHORT RNO		;GO COMPARE
LNO:	DEC	DX			;SET TO BEFORE DI POINTER
	PUSH	SI			;SAVE SI
	MOV	SI,DX			;SET UP INDEX REGISTER
	MOV	AL,BYTE PTR INPBUF [SI]	;GET CHARACTER TO LEFT
	POP	SI			;RESTORE SI
RNO:	SUB	AL,64			;TEST FOR NON ALPHA CHR
	JS	NOALP1			;IF NON ALPHA CHR...SKIP NEXT
	JMP	NEXTRL			;IS ALPHA CHR...GET NEXT RULE
NOALP1:	CALL	SIDE			;CHECK SCAN DIRECTION
	JZ	NOALP2			;BACK TO LEFT SCAN ROUTINE
	JMP	RIGHT			;BACK TO RIGHT SCAN ROUTINE
NOALP2: JMP	LEFT
;
;**********************************
; TEST FOR ONE OR MORE VOWELS = #
;**********************************
;
VOWEL:	PUSH	BX			;SAVE BX
	MOV	BX,OFFSET VMESS		;BX = ADDRESS OF VOWEL LIST
	MOV	AH,VMLEN		;AH = LENGTH OF VOWEL LIST
	CALL	SIDE			;LEFT OR RIGHT SCAN?
	JZ	LVOW			;GO LOOK FOR VOWEL ON LEFT SIDE
	INC	DI			;INC INPUT BUFFER POINTER (RIGHT)
	MOV	AL,BYTE PTR INPBUF [DI]	;GET CHARACTER TO THE RIGHT
	JMP	SHORT RVOW		;GO CHECK CHARACTER TO THE RIGHT
LVOW:	DEC	DX			;POINT TO CHARACTER TO THE LEFT
	PUSH	SI			;SAVE SI
	MOV	SI,DX			;SET UP INDEX REGISTER
	MOV	AL,BYTE PTR INPBUF [SI]	;GET CHARACTER TO THE LEFT
	POP	SI			;RESTORE SI
RVOW:	CMP	AL,BYTE PTR [BX]	;COMPARE VOWEL TO INPUT CHARACTER
	JZ	VCONT			;MATCH?
	INC	BX			;NO, INC VOWEL LIST POINTER
	DEC	AH			;DEC VOWEL LENGTH POINTER
	JNZ	RVOW			;ALL VOWELS CHECKED?
	POP	BX			;YES, RESTORE BX
	JMP	NEXTRL			;NO VOWEL FOUND - TRY NEXT RULE
VCONT:	POP	BX			;FOUND VOWEL - RESTORE BX
	CALL	SIDE			;CHECK DIRECTION OF SCAN
	JZ	VOW1			;LEFT & RIGHT ROUTINES ARE 'FAR'
	JMP	RIGHT			;GOTO RIGHT SCAN ROUTINE
VOW1:	JMP	LEFT			;GOTO LEFT SCAN ROUTINE
;
;******************************
; ZERO OR MORE CONSONANTS = :
;******************************
;
;CONSTS:	CALL	SIDE			;CHECK SCAN DIRECTION
;	JZ	LCON			;LEFT?
;	INC	DI			;NO, INC INPUT BUFFER POINTER
;	JMP	RCON			;GO CHECK
;LCON:	DEC	DX			;DEC INPUT BUFFER FOR LEFT ;SCAN
;RCON:	CALL	SIDE			;LEFT OR RIGHT SCAN?
;	JZ	CONST1
;	JMP	RIGHT			;GOTO RIGHT SCAN ROUTINE
;CONST1:	JMP	LEFT			;GOTO LEFT SCAN ROUTINE
;
CONSTS:	MOV	AH,CONLEN		;AH = LENGTH OF CONSONANT TABLE
	CALL	SIDE			;LEFT OR RIGHT SCAN?
	JZ	LCON			;GO LEFT YOUNG MAN...
	INC	DI			;RIGHT SCAN SO INC INPBUF POINTER
	MOV	AL,BYTE PTR INPBUF [DI]	;GET CHARACTER FROM INPUT BUFFER
	JMP	SHORT RCON		;GO CHECK RIGHT CHARACTER
LCON:	DEC	DX			;LEFT SCAN SO DEC INPBUF POINTER
	PUSH	SI			;SAVE SI
	MOV	SI,DX			;SET UP INDEX REGISTER
	MOV	AL,BYTE PTR INPBUF [SI]	;GET CHARACTER FROM INPUT BUFFER
	POP	SI			;RESTORE SI
RCON:	PUSH	BX			;SAVE BX
	MOV	BX,OFFSET CONMES	;GET ADDRESS OF CONSONANT TABLE
ZLOOP:	CMP	AL,BYTE PTR [BX]	;COMPARE INPUT CHR WITH CONSONANT
	JZ	ZMATCH			;MATCH?
	INC	BX			;NO, POINT TO NEXT CONSONANT
	DEC	AH			;DEC LENGTH OF TABLE
	JNZ	ZLOOP			;CHECKED LAST CONSONANT?
	POP	BX			;YES, RESTORE BX
	JMP	NEXTRL			;GO TRY NEXT RULE
ZMATCH:	POP	BX			;GOT A MATCH, RESTORE BX
	CALL	SIDE			;CHECK SCAN DIRECTION
	JZ	CONSZ1
	JMP	RIGHT			;GOTO RIGHT SCAN ROUTINE
CONSZ1:	JMP	LEFT			;GOTO LEFT SCAN ROUTINE

;
;**************************
; MATCH ONE CONSONANT = "
;**************************
CONSNT:	MOV	AH,CONLEN		;AH = LENGTH OF CONSONANT TABLE
	CALL	SIDE			;LEFT OR RIGHT SCAN?
	JZ	LCONS			;GO LEFT YOUNG MAN...
	INC	DI			;RIGHT SCAN SO INC INPBUF POINTER
	MOV	AL,BYTE PTR INPBUF [DI]	;GET CHARACTER FROM INPUT BUFFER
	JMP	SHORT RCONS		;GO CHECK RIGHT CHARACTER
LCONS:	DEC	DX			;LEFT SCAN SO DEC INPBUF POINTER
	PUSH	SI			;SAVE SI
	MOV	SI,DX			;SET UP INDEX REGISTER
	MOV	AL,BYTE PTR INPBUF [SI]	;GET CHARACTER FROM INPUT BUFFER
	POP	SI			;RESTORE SI
RCONS:	PUSH	BX			;SAVE BX
	MOV	BX,OFFSET CONMES	;GET ADDRESS OF CONSONANT TABLE
CLOOP:	CMP	AL,BYTE PTR [BX]	;COMPARE INPUT CHR WITH CONSONANT
	JZ	CMATCH			;MATCH?
	INC	BX			;NO, POINT TO NEXT CONSONANT
	DEC	AH			;DEC LENGTH OF TABLE
	JNZ	CLOOP			;CHECKED LAST CONSONANT?
	POP	BX			;YES, RESTORE BX
	JMP	NEXTRL			;GO TRY NEXT RULE
CMATCH:	POP	BX			;GOT A MATCH, RESTORE BX
	CALL	SIDE			;CHECK SCAN DIRECTION
	JZ	CONSN1
	JMP	RIGHT			;GOTO RIGHT SCAN ROUTINE
CONSN1:	JMP	LEFT			;GOTO LEFT SCAN ROUTINE
;
;*******************************
; MATCH A VOICED CONSONANT = .
;*******************************
;
VCNSNT:	MOV	AH,VCONLE		;GET LENGTH OF VOICED CONSNT TABLE
	CALL	SIDE			;LEFT OR RIGHT SCAN?
	JZ	VCLFT			;LEFT, GO CHECK IT OUT
	INC	DI			;RIGHT, INC POINTER TO INPUT BUFFER
	MOV	AL,BYTE PTR INPBUF [DI]	;GET CHARACTER FROM INPUT BUFFER
	JMP	SHORT VCRT		;GO AND COMPARE
VCLFT:	DEC	DX			;LEFT, DEC INPUT BUFFER POINTER
	PUSH	SI			;SAVE SI
	MOV	SI,DX			;SET UP INDEX REGISTER
	MOV	AL,[SI]			;GET CHARACTER FROM INPUT BUFFER
	POP	SI			;RESTORE SI
VCRT:	PUSH	BX			;SAVE BX
	MOV	BX,OFFSET VMESSL	;GET ADDRESS OF VOICED CONSNT TBL
VLOOP:	CMP	AL,BYTE PTR [BX]	;COMPARE INPUT CHR AND VOICED CNST
	JZ	VMATCH			;IS THERE A MATCH?
	INC	BX			;NO, POINT TO NEXT VOICED CONSNT
	DEC	AH			;DEC VOICED CONSNT COUNT
	JNZ	VLOOP			;CHECKED ALL VOICED CONSNT?
	POP	BX			;YES, RESTORE BX
	JMP	NEXTRL			;TRY NEXT RULE
VMATCH:	POP	BX			;GOT A MATCH, RESTORE BX
	CALL	SIDE			;LEFT OR RIGHT SCAN?
	JZ	VCNSN1
	JMP	RIGHT			;GOTO RIGHT SCAN ROUTINE
VCNSN1:	JMP	LEFT			;GOTO LEFT SCAN ROUTINE
;
;**************************
; MATCH A FRONT VOWEL = +
;**************************
;
FRNTVL:	CALL	SIDE			;LEFT OR RIGHT SCAN?
	JZ	FVL			;GO CHECK LEFT
	INC	DI			;RIGHT, INC INPUT BUFFER POINTER
	MOV	AL,BYTE PTR INPBUF [DI]	;GET CHARACTER FROM INPUT BUFFER
	JMP	FVR			;GO AND COMPARE
FVL:	DEC	DX			;LEFT, DEC INPUT BUFFER POINTER
	PUSH	SI			;SAVE SI
	MOV	SI,DX			;SET UP INDEX REGISTER
	MOV	AL,BYTE PTR INPBUF [SI]	;GET CHARACTER FROM INPUT BUFFER
	POP	SI			;RESTORE SI
FVR:	CMP	AL,'E'
	JZ	FVMTCH			;MATCH IF 'E'
	CMP	AL,'I'
	JZ	FVMTCH			;MATCH IF 'I'
	CMP	AL,'Y'
	JZ	FVMTCH			;MATCH IF 'Y'
	JMP	NEXTRL			;NO MATCH, TRY NEXT RULE
FVMTCH:	CALL	SIDE			;LEFT OR RIGHT SCAN?
	JZ	FRNTV1
	JMP	RIGHT			;GOTO RIGHT SCAN ROUTINE
FRNTV1:	JMP	LEFT			;GOTO LEFT SCAN ROUTINE
;
;**********************
; TEST FOR SUFFIX'S %
;**********************
;
SUFFIX:	PUSH	BX			;SAVE BX
	INC	DI			;INC INPUT BUFFER POINTER
	PUSH	DI			;SAVE DI
	MOV	AH,SMESSL		;AH = LENGTH OF SUFFIX TABLE
	MOV	BX,OFFSET SMESS		;BX = ADDRESS OF SUFFIX TABLE
SLOOP1:	MOV	AL,BYTE PTR INPBUF [DI]	;GET CHARACTER FROM INPUT BUFFER
	CMP	AL,BYTE PTR [BX]	;COMPARE
	JZ	SECCHK			;MATCH?
SLOOP2:	DEC	AH			;NO, DEC SUFFIX COUNTER
	JZ	ROUTER			;ANY MORE TO COMPARE?
	INC	BX			;YES, INC SUFFIX TABLE POINTER
	MOV	AL,BYTE PTR [BX]	;GET NEXT CHARACTER OF SUFFIX
	CMP	AL,','			;IS IT A COMMA?
	JNZ	SLOOP2			;NO, GO AND TEST NEXT CHARACTER
	POP	DI
	PUSH	DI
	INC	BX			;BUMP PAST COMMA
	JMP	SHORT SLOOP1		;COMPARE NEXT SUFFIX
SECCHK:	INC	BX			;CHECK FOR FINAL MATCH
	MOV	AL,BYTE PTR [BX]	;GET NEXT CHARACTER OF SUFFIX
	CMP	AL,','			;IS IT A COMMA?
	JZ	FNDMTH			;YES, FOUND A MATCH
	INC	DI			;NO, INC INPUT BUFFER POINTER
	DEC	AH			;DEC SUFFIX COUNTER
	JNZ	SLOOP1			;CHECK NEXT SUFFIX IF THERE IS ONE
;
ROUTER:	POP	DI			;NO MATCH, RESTORE DI
	POP	BX			;  AND BX
	JMP	NEXTRL			;TRY NEXT RULE
FNDMTH:	POP	BP			;THROW AWAY DI CAUSE WE GOT A MATCH
	POP	BX			;GOT A MATCH, RESTORE BX
	JMP	RIGHT			;GOTO RIGHT SCAN ROUTINE
;
;**********************
; CHECK SILIBANTS = &
;**********************
;
SIBLNT:	PUSH	BX			;SAVE BX
	MOV	BX,OFFSET SIBMES	;BX = ADDRESS OF SIBILANT TABLE
	MOV	AH,SIBLEN		;AH = LENGTH OF SIBILANT TABLE
	CALL	SIBCON			;GO COMPARE
	POP	BX			;RESTORE BX
	JZ	NEXTRL			;NO MATCH, TRY NEXT RULE
	JMP	LEFT			;MATCH...GO LEFT
;
;***********************
; INFLUENCING CONS = $
;***********************
;
INFCON:	PUSH	BX			;SAVE BX
	MOV	BX,OFFSET CONSM		;BX = ADDRESS OF CONSONANTS
	MOV	AH,CONSLN		;AH = LENGTH OF TABLE
	CALL	SIBCON			;GO COMPARE
	POP	BX			;RESTORE BX
	JZ	NEXTRL			;NO MATCH, TRY NEXT RULE
	JMP	LEFT			;MATCH...GO LEFT
;
;*******************************************************
; COMMON ROUTINE FOR SIBILANT & INFLUENCING CONS CHECK
;*******************************************************
;
SIBCON	PROC
	DEC	DX			;DEC LEFT SCAN POINTER TO INPBUF
	PUSH	DX			;SAVE IT
SIBLOP:	PUSH SI				;SAVE SI
	MOV	SI,DX			;SET UP INDEX REGISTER
	MOV	AL,BYTE PTR INPBUF [SI]	;GET CHARACTER FROM INPUT BUFFER
	POP	SI			;RESTORE SI
	CMP	AL,BYTE PTR [BX]	;COMPARE SIB/CONSNT W/ INPUT CHR
	JZ	CHKAGN			;MATCH?
SIB2:	DEC	AH			;DEC TABLE LENGTH COUNTER
	JZ	SIBERR			;END OF TABLE?
	INC	BX			;NO, INC TABLE POINTER
	MOV	AL,BYTE PTR [BX]	;GET CHARACTER FROM TABLE
	CMP	AL,','			;IS IT A COMMA?
	JNZ	SIB2			;IF NOT, GO COMPRE IT
	POP	DX			;RESTORE LEFT POINTER
	PUSH	DX			;SAVE IT AGAIN?
	INC	BX			;INC TABLE POINTER
	JMP	SHORT SIBLOP		;GO CHECK NEXT
CHKAGN:	INC	BX			;INC TABLE POINTER
	MOV	AL,BYTE PTR [BX]	;GET VALUE FROM TABLE
	CMP	AL,','			;IS IT A COMMA?
	JZ	FNDIT			;FOUND A MATCH
	DEC	DX			;DEC LEFT SCAN POINTER
	DEC	AH			;DEC TABLE LENGTH COUNTER
	JNZ	SIBLOP			;CHECK NEXT CHR IN TABLE
;
SIBERR:	POP	DX			;RESTORE DX
	OR	AL,64			;SET ERROR BIT
	CMP	AL,64			;TEST FOR JMP ON RETURN
	RET				;RETURN TO CALLER
FNDIT:	POP	DX			;RESTORE DX
	AND	AL,191			;RESET ERROR BIT
	CMP	AL,64			;TEST FOR JMP ON RETURN
	RET				;RETURN TO CALLER
SIBCON	ENDP
;
;*******************************************
; CHECK FOR RIGHT OR LEFT ASCII CHARACTERS
;*******************************************
;
ASCCHK:	CALL	SIDE			;CHECK SCAN DIRECTION
	JZ	LASC			;LEFT SCAN?
	INC	DI			;INC INPUT BUFFER POINTER
	MOV	AL,BYTE PTR INPBUF [DI]	;GET CHARACTER FROM INPUT BUFFER
	JMP	SHORT CHECK		;GO COMPARE
LASC:	DEC	DX			;DEC LEFT SCAN INPBUF POINTER
	PUSH SI				;SAVE SI
	MOV	SI,DX			;SET UP INDEX REGISTER
	MOV	AL,BYTE PTR INPBUF [SI]	;GET CHARACTER FROM INPUT BUFFER
	POP	SI
CHECK:	CMP	AL,BYTE PTR [BX]	;INPUT BUFFER CHR AND RULE MATCH?
	JNZ	NEXTRL			;NO, TRY NEXT RULE
	CALL	SIDE			;YES, CHECK DIRECTION OF SCAN
	JZ	ASCHK1
	JMP	RIGHT			;GOTO RIGHT SCAN ROUTINE
ASCHK1:	JMP	LEFT			;GOTO LEFT SCAN ROUTINE
;
;****************************************
; TEST FOR RIGHT OR LEFT SCAN DIRECTION
;****************************************
;
SIDE	PROC
	MOV	AL,LRFLAG		;GET LEFT/RIGHT FLAG
	CMP	AL,1			;CHECK BIT 0
	RET				;RETURN TO CALLER
SIDE	ENDP
;
;**************************
; SET UP TO GET NEXT RULE
;**************************
;
NEXTRL:	NOP	
NLOOP:	MOV	AL,BYTE PTR [BX]	;GET RULE CHARACTER
	CMP	AL,'@'			;FIND RULE SEPARATOR
	JZ	FNDNXT			;FOUND NEW RULE
	CMP	AL,'['			;FOUND END OF THESE RULES
	JNZ	NERROR			;ERROR...FOUND NO MATCH
	JMP	ERROR
NERROR:	INC	BX			;INC RULE TABLE POINTER
	JMP	SHORT NLOOP		;CHECK NEXT RULE
;
FNDNXT:	MOV	AL,0			;CLEAR AL
	MOV	LRFLAG,AL		;CLEAR LEFT RIGHT FLAG
	PUSH	SI			;SAVE SI
	MOV	SI,SAVEIX		;SET UP INTERMEDIATE REGISTER
	MOV	DI,SI			;RESTORE INPBUF PTR FOR NEXT RULE
	POP	SI			;RESTORE SI
	MOV	AL,BYTE PTR INPBUF [DI]	;GET CHARACTER FROM INPUT BUFFER
	INC	BX			;BUMP RULE PTR PAST '@'
	JMP	RULSCN			;TRY NEXT RULE
;
;*******************************
; TRANSFER DATA TO TALK BUFFER
;*******************************
;
TXFR:	INC	BX
TLOOP:	MOV	AL,BYTE PTR [BX]
	CMP	AL,'@'
	JZ	GNXTCH	
	MOV	BYTE PTR OUTBUF [SI],AL
;
	INC	BX
	MOV	AL,BYTE PTR [BX]
	MOV	BYTE PTR FFBUF [SI],AL
;
	INC	BX
	MOV	AL,BYTE PTR [BX]
	MOV	BYTE PTR AABUF [SI],AL
;
	INC	BX
	MOV	AL,BYTE PTR [BX]
	MOV	BYTE PTR RIBUF [SI],AL
;
	INC	BX
	MOV	AL,BYTE PTR [BX]
	MOV	BYTE PTR IOBUF [SI],AL
;
	INC	BX
	INC	SI
	JMP	SHORT TLOOP
;
GNXTCH:	MOV	AL,LRFLAG
	AND	AL,8
	CMP	AL,8
	JNZ	G1
	PUSH	SI			;SAVE SI
	MOV	SI,IXPTR		;SET UP INTERMEDIATE REGISTER
	MOV	DI,SI			;RESTORE INPBUF PTR FOR NEXT RULE
	POP	SI			;RESTORE SI
G1:	INC	DI
	MOV	AL,0
	CMP	AL,BYTE PTR INPBUF [DI]
	JZ	OUTPUT	
	MOV	LRFLAG,AL
	JMP	CHTYPE
;
;****************
; ERROR ROUTINE
;****************
;
ERROR:	JMP	RETURN
;
;*************************
; OUTPUT DATA TO SSI-263
;*************************
;
OUTPUT:	MOV	BYTE PTR OUTBUF+1 [SI],255
	MOV	BX,OFFSET OUTBUF
;
OUT1:	MOV	AL,80H
	MOV	DX,643
	OUT	DX,AL
	NOP
	JMP	SHORT OUT2
;
OUT2:	MOV	AL,0C0H
	MOV	DX,640
	OUT	DX,AL
	NOP
	JMP	SHORT OUT3
;
OUT3:	MOV	AL,70H
	MOV	DX,643
	OUT	DX,AL
	NOP
	JMP	SHORT OLOOP
;
OLOOP:	MOV	AL,BYTE PTR [BX]+256
	MOV	DX,644
	OUT	DX,AL
	NOP
	JMP	SHORT OUT4
;
OUT4:	MOV	AL,BYTE PTR [BX]+512
	MOV	DX,643
	OUT	DX,AL
	NOP
	JMP	SHORT OUT5
;
OUT5:	MOV	AL,BYTE PTR [BX]+768
	MOV	DX,642
	OUT	DX,AL
	NOP
	JMP	SHORT OUT6
;
OUT6:	MOV	AL,BYTE PTR [BX]+1024
	MOV	DX,641
	OUT	DX,AL
	NOP
	JMP	SHORT OUT7
;
OUT7:	MOV	AL,BYTE PTR [BX]
        MOV	DX,640
	OUT	DX,AL
	NOP	
	CMP	AL,255
	JZ	RETURN	

RESCAN:	MOV	DX,640
RESCN1:	IN	AL,DX
	AND	AL,128
	CMP	AL,128
	JNZ	RESCN1	
OL1:	INC	BX
	JMP	SHORT OLOOP

RETURN:	MOV	AL,0H
	MOV	DX,644
	OUT	DX,AL
	NOP
        JMP	SHORT OUT85

OUT85:  MOV	AL,70H
	MOV	DX,643
	OUT	DX,AL
	NOP
	JMP	SHORT OUT9
;
OUT9:	MOV	AL,0H
	MOV	DX,642
	OUT	DX,AL
	NOP
	JMP	SHORT OUT10

OUT10:	MOV	AL,0H
	MOV	DX,641
	OUT	DX,AL
	NOP
	JMP	SHORT OUT11

OUT11:	MOV	AL,0H
	MOV	DX,640
	OUT	DX,AL
	NOP
	JMP	SHORT OUT12

OUT12:	XOR	AL,AL
	MOV	LRFLAG,AL
	RET
BEGN	ENDP
	END	BEGN
