;
; *** Listing 13-11 ***
;
; Determines whether there are more non-negative or negative
; elements in an array of 8-bit signed values, using a
; standard test-and-branch approach and a single LOOP
; instruction.
;
	jmp	Skip
;
ARRAY_LENGTH	equ	256
ByteArray	label	byte
X=0
	rept	ARRAY_LENGTH
	db	X
X=X+1
	endm
;
; Determines whether there are more non-negative or
; negative elements in the specified array of 8-bit
; signed values.
;
; Input:
;	CX = length of array
;	DS:SI = array to check
;
; Output:
;	DX = signed count of the number of non-negative
;		elements found in the array minus the number
;		of negative elements found. (Zero if there
;		are the same number of each type of element.
;		Otherwise, sign bit set if there are more
;		negative elements than non-negative
;		elements, cleared if there are more
;		non-negative elements than negative
;		elements)
;
; Registers altered: AL, CX, DX, SI
;
; Direction flag cleared
;
; Note: Only useful if the surplus of non-negative
;	elements over negative elements is less than
;	32K, or if the surplus of negative elements
;	over non-negative elements is less than or
;	equal to 32K. Otherwise, the signed count
;	returned in DX overflows.
;
; Note: Does not handle arrays that are longer than 64K
;	bytes or cross segment boundaries.
;
CountNegPos:
	cld
	sub	dx,dx	;initialize the count to zero
CountNegPosLoop:
	lodsb		;get the next byte to check
	and	al,al	;see if it's negative or
			; non-negative 
	js	CountNeg ;it's negative
	inc	dx	;count off one non-negative element
	jmp	short CountNegPosLoopBottom
CountNeg:
	dec	dx	;count off one negative element
CountNegPosLoopBottom:
	loop	CountNegPosLoop
	ret
;
Skip:
	call	ZTimerOn
	mov	si,offset ByteArray	;array to check
	mov	cx,ARRAY_LENGTH		;# of bytes to check
	call	CountNegPos		;see whether there
					; are more negative
					; or non-negative
					; elements
	call	ZTimerOff
