;
; *** Listing 13-23 ***
;
; Zeros the high-bit of each byte in a 100-byte array,
; using branched-to in-line code.
;
	jmp	Skip
;
MAXIMUM_ARRAY_LENGTH	equ	200
ARRAY_LENGTH	equ	100
ByteArray	label	byte
	db	ARRAY_LENGTH dup (80h)
;
; Clears the high bit of each byte in an array.
;
; Input:
;	BX = pointer to the start of the array to clear
;	CX = number of bytes to clear (no greater than
;		MAXIMUM_ARRAY_LENGTH)
;
; Output: none
;
; Registers altered: AX, BX, CX
;
ClearHighBits:
;
; Calculate the offset in the in-line code to which to jump
; in order to get the desired number of repetitions.
;
	mov	al,InLineBitClearEnd-SingleRepetitionStart
				;# of bytes per single
				; repetition of
				; AND [BX],AL/INC BX
	mul	cl		;# of code bytes in the # of
				; repetitions desired
	mov	cx,offset InLineBitClearEnd
	sub	cx,ax		;point back just enough
				; instruction bytes from
				; the end of the in-line
				; code to perform the
				; desired # of repetitions
	mov	al,not 80h	;pattern to clear high bits
				; with
	jmp	cx		;finally, branch to perform
				; the desired # of
				; repetitions
;
; In-line code to clear the high bits of up to the maximum #
; of bytes.
;
	rept	MAXIMUM_ARRAY_LENGTH-1
				;maximum # of bytes to clear
				; less 1
	and	[bx],al		;clear the high bit of this
				; byte
	inc	bx		;point to the next byte
	endm
SingleRepetitionStart:		;a single repetition of the
				; loop code, so we can
				; calculate the length of
				; a single repetition
	and	[bx],dl		;clear the high bit of this
		       		; byte
	inc	bx     		;point to the next byte
InLineBitClearEnd:
	ret
;
Skip:
	call	ZTimerOn
	mov	bx,offset ByteArray
				;array in which to clear
				; high bits
	mov	cx,ARRAY_LENGTH	;# of bytes to clear
				; (always less than
				; MAXIMUM_ARRAY_LENGTH)
	call	ClearHighBits	;clear the high bits of the
				; bytes
	call	ZTimerOff
