;
; *** Listing 13-24 ***
;
; Zeros the high-bit of each byte in a 100-byte array,
; using partial in-line code.
;
	jmp	Skip
;
ARRAY_LENGTH	equ	100
ByteArray	label	byte
	db	ARRAY_LENGTH dup (80h)
;
; Clears the high bit of each byte in an array.
;
; Input:
;	BX = pointer to the start of the array to clear
;	CX = number of bytes to clear (must be a multiple
;		of 4)
;
; Output: none
;
; Registers altered: AL, BX, CX
;
ClearHighBits:
	mov	al,not 80h		;pattern to clear
					; high bits with
	shr	cx,1			;# of passes through
	shr	cx,1			; partial in-line
					; loop, which does
					; 4 bytes at a pop
ClearHighBitsLoop:
	rept	4			;we'll put 4 bit-
					; clears back to
					; back, then loop
	and	[bx],al			;clear the high bit
					; of this byte
	inc	bx			;point to the next
					; byte
	endm
	loop	ClearHighBitsLoop
	ret
;
Skip:
	call	ZTimerOn
	mov	bx,offset ByteArray
				;array in which to clear
				; high bits
	mov	cx,ARRAY_LENGTH	;# of bytes to clear
				; (always a multiple of 4)
	call	ClearHighBits	;clear the high bits of the
				; bytes
	call	ZTimerOff
