;
; Program to measure performance of code that takes longer than
; 54 ms to execute.
; Link with LZTIMER.OBJ.
;
; By Michael Abrash 10/30/87
;
stack	segment	para stack 'STACK'
	db	512 dup(?)
stack	ends

Code	segment	para public 'CODE'
	assume	cs:Code, ds:code
	extrn	ZTimerOn:near, ZTimerOff:near, ZTimerReport:near
Start	proc	near
	push	cs
	pop	ds	;point DS to the code segment
;
; Delay for 2-3 seconds, to let the Enter keystroke that started the
; program come back up.
;
	mov	ah,2ch
	int	21h		;get the current time
	mov	bh,dh		;set the current time aside
DelayLoop:
	mov	ah,2ch
	int	21h		;get time
	cmp	dh,bh		;is the new seconds count less than
				; the start seconds count?
	jnb	CheckDelayTime	;no
	add	dh,60		;yes, a minute must have turned over,
				; so add one minute
CheckDelayTime:
	sub	dh,bh		;get time that's passed
	cmp	dh,3		;has it been three seconds?
	jb	DelayLoop	;not yet
;
;Code under test starts here.
;*********************************************************************
;
; Start timing.
;
	call	ZTimerOn
;
	rept	10000
	mul	ax
	endm
;
; Stop timing.
;
	call	ZTimerOff
;*********************************************************************
; Code under test ends here.
;
; Display the results.
;
	call	ZTimerReport
;
; Terminate the program.
;
	mov	ah,4ch
	int	21h
Start	endp
Code	ends
	end	Start
