PROGRAM T_ega_0a;                       {Last mod by JFH on 07/20/95}

{ EXAMPLE OF USING ACCESS OBJECTS }

{ See notes in U_EGA_0a unit about making the access objects used here.
  I have made other objects in Pascal for accessing WK1 and WQ1 files,
  Obj files, COM ports and servicing the interrupts, DBase files,
  comma-quote-delimited files, formated text reports, long-line text
  files, and anywhere I have an application dependent file structure.
  They are easy to do and very reusable.  As I need them in OP or
  Delphi I am converting them where necessary. }

{ Pgm. 07/14/95 by John F Herbster, CIS:72714,3445, Houston, TX.
      for Rick Rogers (CIS:74323,3573). }

USES
  U_EGA_0a in 'U_EGA_0A.PAS',
  WinCrt;

Const InputPath = 'TEST.DXF';

VAR
  Reader: tBasicDFXReaderCls;
  Group: integer; s: string; d: double; i: integer; TestNbr: integer;

{=====} BEGIN {========================================================}

  For TestNbr :=1 to 2 do begin
    Case TestNbr of
      1: begin
        Writeln('Test #',TestNbr,' of simple DXF reader.');
        Reader:=tSimpleDFXReaderCls.Create(InputPath);
        end;
      2: begin
        Writeln('Test #',TestNbr,' of DXF reader with block IO.');
        Reader:=tBlkIoDFXReaderCls.Create(InputPath);
        end;
      end{cases};
    With Reader do begin
      Repeat
        Group:=NextGroupCode;
        If Group>=0
          then begin
            s:=ValStr;
            (*WriteLn(Group:4,' ',s);*)
            end;
        Until Group<0;
      Destroy;
      end;
    WriteLn(Group:4,' (END of test #',TestNbr,')');
    end{TestNbr loop};
 WriteLn('Finished');

{=====} END. {=========================================================}


