unit Anaform;
     {  Olivier Dahan CIS 100531,163
       See built-in help for Licence }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, FileCtrl, DBTables, DB,
  Grids, DBGrids, Report, DBCtrls;


Const
     MaxLignes = 20;   { max Number of levels (path) }
     Separateur = '.'; { separator for displayed path }
type
    St30 = String[30];
    TLigne = Record
                   Objet:st30;       { Object name }
                   Num:Longint;      { Object ID numer in database }
             end;
    TTableau = Array[1..MaxLignes] of TLigne; { internal stack Array }

    ToTab = Object { Stack object - Last In First Out (LIFO) }
            T : Ttableau; { nested levels array }
            C : WOrd;     { array meter }
            procedure Init; { Empty array }
            Procedure Empile(Objet:St30;Num:Word); { put an element on stack }
            Procedure Depile;                      { take last stacked elem. }
            Function DonneNomSommet:St30;          { Last stacked elem. name }
            Function DonneNumSommet:Longint;       { Last Stacked elem. number }
            Function DonneCheminSommet:String;     { L.S.E. path }
            end;


  TForm1 = class(TForm)
    Panel1: TPanel;
    E_NomForm: TEdit;
    Label1: TLabel;
    BitBtn1: TBitBtn;
    B_Analyser: TButton;
    OpenDialog1: TOpenDialog;
    T_Objets: TTable;
    T_Props: TTable;
    T_ObjetsNumObjet: TIntegerField;
    T_ObjetsObjet: TStringField;
    T_ObjetsType: TStringField;
    T_ObjetsPath: TStringField;
    T_PropsNumProprit: TIntegerField;
    T_PropsNom: TStringField;
    Ds_Objets: TDataSource;
    DBG_Objets: TDBGrid;
    B_Convert: TButton;
    Ds_props: TDataSource;
    DBG_Props: TDBGrid;
    T_PropsNumObjet: TIntegerField;
    B_Parcourir: TButton;
    BitBtn2: TBitBtn;
    Rep_ListeObjets: TReport;
    B_LanceRap1: TButton;
    T_PropsValeur: TStringField;
    DBN_Objets: TDBNavigator;
    DBN_Props: TDBNavigator;
    Label2: TLabel;
    Label3: TLabel;
    Bevel1: TBevel;
    RadioGroup1: TRadioGroup;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    CheckBox1: TCheckBox;
    Database: TDatabase;
    procedure B_AnalyserClick(Sender: TObject);
    procedure B_ParcourirClick(Sender: TObject);
    procedure B_ConvertClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure B_LanceRap1Click(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure RadioButton2Click(Sender: TObject);
    procedure RadioButton3Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
  private
    { Private declarations }
    Tableau : ToTab;
  public
    { Public declarations }
    CancelProgress : Boolean;
    { all the following stuff just to make the Treport working fine...}
    DBPath : string;
    Function Datapath : String; { return Path of the data }
    procedure UpdateRSConnect;
    procedure InitRSRUN;
  end;

var
  Form1: TForm1;

implementation
Uses About, progress, commt, inifiles;

{$R *.DFM}

Function Tform1.Datapath : String;
begin DataPath := DBPath; end;

{ add the current connection to RS con file if needed or update it}
procedure Tform1.UpdateRSConnect;
const
  TiniFilename = 'RPTSMITH.CON';   { ReportSmith connections file }
  AppConTitle = 'ANAFORM';
  ConnectNamesSection = 'ConnectNamesSection';
  ConnectNamesKey = 'ConnectNames';
  AFSection = 'AnaFormData';
  TypeKey = 'Type';
  ServerKey = 'Server';
  TypeVal = 61;
  ServerVal = 'PARADOX';  { databases in this application are Pdox }
  DataFilePathKey = 'DataFilePath';
var
  TempStr,
  ConFile: string[127];
  RSCON: TIniFile;
begin
 { the ReportSmith CON file is actually an INI file -- assumes in win dir}
  RSCon := TIniFile.Create(TiniFilename);
  TempStr := RSCon.ReadString(ConnectNamesSection, ConnectNamesKey, '');
  if Pos(AppConTitle,TempStr) = 0 then
  begin
    if TempStr <> '' then
      TempStr := TempStr + ',';
    RSCon.WriteString(ConnectNamesSection, ConnectNamesKey, TempStr+AppConTitle);
  end;
  RSCon.WriteInteger(AFSection, TypeKey, TypeVal);
  RSCon.WriteString(AFSection, DataFilePathKey, DBpath);
  RSCon.WriteString(AFSection, ServerKey, ServerVal);
  RSCon.Free;
end;

procedure Tform1.InitRSRUN;
var
  ParamList: TStringList;
begin
  { get the actual location of the database from the alias or database,
    the path is needed for the reports -- assumes alias is defined }
  ParamList := TStringList.Create;
  try
    Session.GetAliasParams(Database.AliasName, ParamList);
    DBPath := ParamList.Values['PATH'];
  finally
    ParamList.Free;
  end;
  { set up the ReportSmith "connection" identifying the database location }
  UpdateRSConnect;
end;



{ LIFO stack Object definition }
Procedure ToTab.Init;
begin C:=0; fillchar(T,sizeof(T),0); end;

Procedure ToTab.Empile(Objet:St30;Num:Word);
begin if c=MaxLignes then exit;
      inc(c); T[c].Objet:=Objet; T[c].num:=Num; end;

Procedure ToTab.Depile;
begin if c=0 then exit;
         t[c].objet:=''; t[c].num:=0; dec(c); end;

Function ToTab.DonneNomSommet:St30;
begin if c>0 then Result:=T[c].Objet else Result:=''; end;

Function ToTab.DonneNumSommet:Longint;
begin if c>0 then Result:=T[c].Num else Result:=0; end;

Function Totab.DonneCheminSommet:String;
var i:integer;
begin result:='';
for i:=1 to C do if Result<>'' then result:=Result+Separateur+T[i].Objet
                               else Result:=T[i].objet;
end;
{ end of stack object definition }

{ Internal proc / trim leading and heading spaces }
Function Trim(S:String):String;
begin while (length(s)>0) and (s[1]=#32) do delete(s,1,1);
      While (length(s)>0) and (s[length(s)]=#32) do delete(s,length(s),1);
      Result:=S;
end;

{ Analyse the text Form file }
procedure TForm1.B_AnalyserClick(Sender: TObject);
Var Fform:System.text;    { TXT to analyze }
    I:Integer;            { general purpose meter }
    Sana:String[64];      { TXT file name }
    S1:String[255];       { to read from TXT }
    S2,S3 : String[100];  { general purpose vars }
    Fsz: integer;         { computed font size }
    RFsz:real;            { idem, internal use }
    Fp:TF_Progress;       { progress/cancel form }
    Fz:File;              { use to get filesize }
    Fsize:longint;        { size of text file }
begin
  Sana:=Uppercase(E_NomForm.Text);         { DFM name to analyze }
  If (sana='') or (length(sana)<4) then
     begin ShowMessage('Give a Form name please!');
           exit;
     end;
  S3:=copy(sana,length(sana)-3,4);
  if S3='.DFM' then
     begin Sana:=Copy(Sana,1,length(sana)-3)+'TXT'; S3:='.TXT'; end;
  if s3<>'.TXT' then
     begin
     Showmessage('Files of type '+s3+' are not processed !');
     exit;
     end;
  { TXT open}
  System.Assign(Fform,Sana);
     {$i-}
  System.Reset(Fform);
  { there's no Txt file... }
  If ioresult<>0 then
        begin ShowMessage('File '+Sana+#13#10+
                          'not found !');
              exit;
        end;
  System.CLose(Fform); { sure here the file exists }
  System.Assign(Fz,sana); { untyped file to get its size }
  System.Reset(Fz);
  Fsize:=System.FileSize(Fz);
  System.Close(Fz);
  System.Reset(Fform); { re open as text file }
  Fp:=TF_Progress.Create(Self);
  Fp.Show;
  Fp.Gauge1.maxValue:=Fsize;
  CancelProgress:=False;
  { Analyze sequence }
  Screen.Cursor:=crHourglass;
  T_Objets.close; T_Objets.Exclusive:=true; T_Objets.open;
  T_Props.Close; T_Props.Exclusive:=true; T_Props.open;
  T_Objets.Emptytable; { clear tables in exclusive mode }
  T_Props.EmptyTable;
  { once cleared, tables can be shared }
  T_Objets.close; T_Objets.Exclusive:=false; t_objets.open;
  T_props.Close; T_Props.Exclusive:=false; t_Props.open;
  Tableau.init; { Stack init }
  Ds_Objets.Enabled:=false; { datasources are disabled to speed process }
  Ds_Props.Enabled:=false;
  While (Not System.Eof(FForm)) and
        (not CancelProgress) do
        begin
             Application.ProcessMessages; { give a chance other apps...}
             Readln(Fform,S1);
             Fp.gauge1.Progress:=
              Fp.Gauge1.progress+Length(s1)+2; { don't forget cr/lf in size }
             S1:=Trim(S1);
             If Uppercase(Copy(S1,1,6))='OBJECT' then
                Begin { object header }
                Delete(s1,1,7);
                I:=pos(':',S1);
                if i=0 { No class name }
                   then begin S2:=s1; s1:='(no class name)'; end
                   else
                   begin s2:=copy(s1,1,i-1); delete(s1,1,i); { S2:obj name}end;
                S1:=Trim(s1); s3:=s1; s1:=''; {s3: class name }
                S2:=trim(s2); s3:=trim(s3);
                T_Objets.Insert;
                T_Objets.FieldByName('Objet').AsString:=S2;
                T_Objets.FieldByName('Type').AsString:=S3;
                T_Objets.Post;
                Tableau.Empile(S2,T_Objets.FieldByName('NumObjet').AsInteger);
                T_Objets.Edit;
                T_Objets.FieldByName('Path').AsString:=Tableau.DonneCheminSommet;
                T_Objets.Post;
                end else
                If uppercase(Copy(s1,1,3))='END' then Tableau.Depile { object end }
                else { we are processing a property }
                begin
                i:=pos('=',s1);
                if i>0 then
                   begin { there is a value on the line }
                   S2:=Trim(copy(s1,1,i-1)); { S2: property name }
                   i:=pos('{',s1);
                   if i>0 then
                     begin { the value is a binary type }
                     if pos('}',s1)=0 then
                        begin { we have to skeep binary data lines }
                        repeat readln(Fform,s1);
                        until (System.Eof(Fform)) or (pos('}',s1)<>0);
                        end; { end of lines skeep }
                     S3:='(Binaire)';
                     end { end of binary value }
                     else begin
                          i:=pos('(',s1); { value is a list of values }
                          if i>0 then begin
                                      s3:='';
                                      if pos(''')',s1)>0 { All is on the same line }
                                      then begin
                                           s1:=trim(s1); s3:=copy(s1,2,length(s1)-2);
                                           end else { more than one line }
                                      repeat Readln(Fform,s1); S1:=trim(s1);
                                      if pos(''')',s1)=0 then
                                             begin if s3='' then s3:=s1 else s3:=s3+','+s1;
                                             end
                                         else begin if s3='' then s3:=copy(s1,1,length(s1)-1)
                                                             else s3:=s3+','+copy(s1,1,length(s1)-1);
                                              end;
                                      until (system.Eof(Fform)) or (Pos(''')',S1)<>0);
                                      end else { end of values list }
                                      begin { simple value }
                                      i:=pos('=',s1);
                                      s3:=trim(copy(s1,i+1,length(s1)-i));
                                      if uppercase(S2)='FONT.HEIGHT'
                                      then begin val(s3,fsz,i); { point size calculation}
                                           if i<>0 then s3:=s3+' [Size= ?]'
                                              else begin
                                                   rfsz:= ((-20.0/27.0)*(Fsz*1.0))+(10.0/27.0);
                                                   if Frac(rfsz)<0.6 then Fsz:=Trunc(rfsz)
                                                                         else Fsz:=Round(rFsz);
                                                   str(fsz,s1);
                                                   s3:=s3+' [Size = '+s1+']';
                                                   end;
                                           end; { end of size calculation }
                                      end; { end of simple value }
                          end;
                   end { end value on line }
                   else S2:=s1; { by default we take line begninig, analyzor fails... }
                T_props.Insert;
                T_Props.FieldByName('Nom').AsString:=S2;
                T_Props.FieldByName('Valeur').AsString:=S3;
                T_Props.FieldByName('NumObjet').AsInteger :=Tableau.DonneNumSommet;
                T_Props.Post;
                end; { properties analysis end  }
        end;
  System.Close(Fform);
  T_objets.First;
  Ds_Objets.Enabled:=true;
  Ds_Props.Enabled:=true;
  Fp.Release;
  Screen.Cursor:=crDefault;
end;

procedure TForm1.B_ParcourirClick(Sender: TObject);
begin
If OpenDialog1.Execute then { open dialog }
   E_NomForm.Text:=OpenDialog1.Filename;
end;

procedure TForm1.B_ConvertClick(Sender: TObject);
var
P:Pchar; { Teporary var for WinExec call }
EE:Word; { WinExec returned value }
I:integer;
S:String;
begin
  If E_NomForm.text='' then
     begin ShowMessage('Enter a form name please !');
           exit;
     end;
S:=uppercase(E_NomForm.Text); i:=pos('.DFM',S);
if i=0 then begin
            Showmessage('Only DFM files can be converted !');
            exit;
            end;
GetMem(P,100);
  StrPcopy(P,'CONVERT.PIF '+E_NomForm.text);
  { DELPHI DOS CONVERT.EXE utility call via CONVERT.PIF }
  EE:=WinExec(P,sw_shownormal);
  Freemem(P,100);
  { Is there an error ? }
  if (EE>0) and (EE<32) then { winexec error code }
     begin
     ShowMessage('WinExec error N '+IntToStr(EE));
     exit;
     end;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  T_Objets.Close;
  T_Props.Close;
  Database.Connected:=False;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
Database.Connected:=True;
T_objets.Open; { objects file }
T_Props.Open;  { properties file }
InitRSRUN;     { to make the Treport works fine...}
Application.HintColor:=clAqua;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
AboutBox.ShowModal;
end;

{ ReportSmith link - not as easy it seems ! - see InitRSRun }
procedure TForm1.B_LanceRap1Click(Sender: TObject);
begin
F_Comment.ShowModal;
Rep_ListeObjets.ReportDir := ExtractFilePath(Application.Exename);
Rep_ListeObjets.InitialValues.Add('@Commentaire=<'+F_COmment.E_Comment.Text+'>');
Rep_ListeObjets.InitialValues.Add('@FormName=<'+e_nomform.text+'>');
Rep_ListeObjets.Run;
end;

procedure TForm1.RadioButton1Click(Sender: TObject);
begin
T_Objets.indexname:='';
end;

procedure TForm1.RadioButton2Click(Sender: TObject);
begin
T_Objets.IndexName:='IX_TYPE_OBJETS';
end;

procedure TForm1.RadioButton3Click(Sender: TObject);
begin
T_Objets.IndexName:='IX_PATH';
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
Rep_ListeObjets.Preview:=CheckBox1.Checked;
end;

end.
