unit Comparm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons, AdMisc, TComIni;

type
  TComParametersForm = class(TForm)
    PortGroup: TRadioGroup;
    BaudGroup: TRadioGroup;
    ParityGroup: TRadioGroup;
    DataBitsGroup: TRadioGroup;
    StopBitsGroup: TRadioGroup;
    OkBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    procedure OkBtnClick(Sender: TObject);

  public
    constructor Create(AOwner : TComponent); override;
  end;

implementation

{$R *.DFM}

constructor TComParametersForm.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);

  {set radio buttons to default values}
  case (Baud div 10) of
    30   : BaudGroup.ItemIndex := 0;
    60   : BaudGroup.ItemIndex := 1;
    120  : BaudGroup.ItemIndex := 2;
    240  : BaudGroup.ItemIndex := 3;
    480  : BaudGroup.ItemIndex := 4;
    960  : BaudGroup.ItemIndex := 5;
    1920 : BaudGroup.ItemIndex := 6;
    3840 : BaudGroup.ItemIndex := 7;
    5760 : BaudGroup.ItemIndex := 8;
    11520: BaudGroup.ItemIndex := 9;
  end;

  PortGroup.ItemIndex     := Ord(Com[4]) - Ord('1');
  ParityGroup.ItemIndex   := Ord(Parity);
  DataBitsGroup.ItemIndex := 8 - Databits;
  StopBitsGroup.ItemIndex := Stopbits - 1;
end;

procedure TComParametersForm.OkBtnClick(Sender: TObject);
const
  Bauds : array[0..9] of LongInt = (300, 600, 1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200);

begin
  Baud     := Bauds[BaudGroup.ItemIndex];
  Com[4]   := Char(Ord('1') + PortGroup.ItemIndex);
  Parity   := TParity(ParityGroup.ItemIndex);
  Databits := 8 - DataBitsGroup.ItemIndex;
  Stopbits := StopBitsGroup.ItemIndex + 1;
end;

end.

