unit Dialmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, AdModem, AdDial, AdTerm, AdPort, ExGetNum;

type
  TMainForm = class(TForm)
    Terminal: TTerminal;
    DefComPort: TComPort;
    Emulator: TEmulator;
    Dialer: TModemDialer;
    Modem: TModem;
    HiddenPopup: TPopupMenu;
    DialOption: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure DialOptionClick(Sender: TObject);
  private
    Sizing : Boolean;

    procedure SizeWindow;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Sizing := False;

  SizeWindow;
end;

procedure TMainForm.FormResize(Sender: TObject);
begin
  SizeWindow;
end;

procedure TMainForm.SizeWindow;
begin
  if not Sizing then begin
    Sizing := True;
    Terminal.Width := Width;
    Terminal.Height := Height;
    Width := Terminal.Width;
    Height := Terminal.Height;
    Sizing := False;
  end;
end;

procedure TMainForm.DialOptionClick(Sender: TObject);
var
  DoDial : Boolean;
  Frm    : TDialDialog;
  Num    : String;

begin
  DoDial := False;

  Frm := TDialDialog.Create(Self);
  Frm.Number.Text := '';
  if (Frm.ShowModal = mrOK) then begin
    Num := Frm.Number.Text;
    DoDial := (Num <> '');
  end;
  Frm.Free;

  if DoDial then begin
    Dialer.PhoneNumber := Num;
    Dialer.Execute;
  end;
end;

end.

