unit Extrig0;

interface

uses
  SysUtils, WinTypes, WinProcs, WinCrt, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, AdPort;

type
  TExTrigTest = class(TForm)
    ComPort1: TComPort;
    StartTest: TButton;
    Label1: TLabel;
    procedure ComPort1TriggerAvail(CP: TObject; Count: Word);
    procedure ComPort1TriggerData(CP: TObject; TriggerHandle, Len: Word);
    procedure ComPort1TriggerTimer(CP: TObject; TriggerHandle: Word);
    procedure StartTestClick(Sender: TObject);
  private
    { Private declarations }
    TimerHandle : Word;
    DataHandle  : Word;
  public
    { Public declarations }
  end;

var
  ExTrigTest: TExTrigTest;

implementation

{$R *.DFM}

procedure WriteIt(C : Char);
begin
  if Ord(C) > 32 then
    Write(C)
  else
    Write('[', Ord(C), ']');
end;

procedure TExTrigTest.ComPort1TriggerAvail(CP: TObject; Count: Word);
var
  I : Word;
  C : Char;
begin
  WriteLn('Got data available, ', Count, ' bytes received');
  for I := 1 to Count do begin
    C := ComPort1.GetChar;
    WriteIt(C);
  end;
  WriteLn;
  WriteLn('--------');
end;

procedure TExTrigTest.ComPort1TriggerData(CP: TObject; TriggerHandle,
                                          Len: Word);
var
  I : Word;
  C : Char;
begin
  WriteLn('Got data trigger, ', TriggerHandle, ' for ', Len, ' bytes');
  for I := 1 to Len do begin
    C := ComPort1.GetChar;
    WriteIt(C);
  end;
  WriteLn;
  WriteLn('--------');
end;

procedure TExTrigTest.ComPort1TriggerTimer(CP: TObject;
  TriggerHandle: Word);
begin
  WriteLn('Got timer trigger ', TriggerHandle);
end;

procedure TExTrigTest.StartTestClick(Sender: TObject);
begin
  ComPort1.ChangeLengthTrigger(1);
  TimerHandle := ComPort1.AddTimerTrigger;
  ComPort1.SetTimerTrigger(TimerHandle, 91, True);

  (*
  StatusHandle := ComPort1.AddStatusTrigger(stOutBuffUsed);
  ComPort.SetStatusTrigger(StatusHandle, 5, True);
  *)

  DataHandle := ComPort1.AddDataTrigger('OK', True);

  {Send a string to a modem that will hit all triggers}
  ComPort1.PutString('ATI'^M);
end;

end.
